/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.figures;

import java.util.HashMap;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrus.uml.diagram.common.locator.ExternalLabelPositionLocator;
import org.eclipse.papyrus.uml.diagram.sequence.figures.SequencePolylineShape;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;

public class TimeMarkElementFigure
extends SequencePolylineShape {
    public static final int TIME_MARK_LENGTH = 20;
    private int sideOfFigure = 0;

    public TimeMarkElementFigure() {
        this.addPoint(new Point(this.getMapModel().DPtoLP(0), this.getMapModel().DPtoLP(0)));
        this.addPoint(new Point(this.getMapModel().DPtoLP(20), this.getMapModel().DPtoLP(0)));
        this.setLocation(new Point(this.getMapModel().DPtoLP(0), this.getMapModel().DPtoLP(0)));
    }

    public void setCurrentSideOfFigure(int side, Rectangle newLocation, EditPart host, String labelVisualId) {
        IGraphicalEditPart labelChild;
        if (host == null || !(host instanceof IGraphicalEditPart)) {
            return;
        }
        if (this.sideOfFigure != side && (this.sideOfFigure != 0 || side != 16) && (labelChild = ((IGraphicalEditPart)host).getChildBySemanticHint(UMLVisualIDRegistry.getType(labelVisualId))) instanceof IBorderItemEditPart) {
            LayoutConstraint constraint;
            IBorderItemEditPart label = (IBorderItemEditPart)labelChild;
            int labelWidth = label.getFigure().getMinimumSize().width;
            if (label.getNotationView() instanceof Node && (constraint = ((Node)label.getNotationView()).getLayoutConstraint()) instanceof Location) {
                int xLocation = ((Location)constraint).getX();
                int mirroredLocation = -xLocation - labelWidth;
                TransactionalEditingDomain dom = ((IGraphicalEditPart)host).getEditingDomain();
                Command setCmd = SetCommand.create((EditingDomain)dom, (Object)constraint, (Object)NotationPackage.eINSTANCE.getLocation_X(), (Object)mirroredLocation);
                TransactionalCommandStack stack = (TransactionalCommandStack)dom.getCommandStack();
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("silent", true);
                options.put("no_undo", true);
                options.put("unprotected", true);
                try {
                    stack.execute(setCmd, options);
                    IBorderItemLocator locator = label.getBorderItemLocator();
                    Rectangle constrRect = ((ExternalLabelPositionLocator)locator).getConstraint();
                    constrRect.x = mirroredLocation;
                    locator.relocate(label.getFigure());
                }
                catch (InterruptedException e) {
                    UMLDiagramEditorPlugin.log.error((Throwable)e);
                }
                catch (RollbackException e) {
                    UMLDiagramEditorPlugin.log.error((Throwable)e);
                }
            }
        }
        this.sideOfFigure = side;
    }
}

