/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.handler;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.uml.profile.drafter.Activator;
import org.eclipse.papyrus.uml.profile.drafter.ui.handler.AbstractBaseHandler;
import org.eclipse.papyrus.uml.profile.utils.Util;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.papyrus.uml.tools.profile.definition.PapyrusDefinitionAnnotation;
import org.eclipse.papyrus.uml.tools.profile.definition.ProfileRedefinition;
import org.eclipse.papyrus.uml.tools.profile.definition.Version;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.ExtensionEnd;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class CreateProfileHandler
extends AbstractBaseHandler {
    @Override
    public String getCommandName() {
        return "Create new Profile";
    }

    @Override
    protected boolean preExecute(ExecutionEvent event, IEvaluationContext context) throws ExecutionException {
        this.getCachedSelections(context);
        return super.preExecute(event, context);
    }

    @Override
    protected void doExecute(ExecutionEvent event, IEvaluationContext context) {
        String stereotypeName = "MyNewStereotype";
        List<Object> selections = this.getCachedSelections(context);
        if (!(selections.get(0) instanceof Profile)) {
            return;
        }
        try {
            Activator.log.info("Create new profile called ...");
            Profile profile = (Profile)selections.get(0);
            Stereotype stereotype = UMLFactory.eINSTANCE.createStereotype();
            stereotype.setName(stereotypeName);
            profile.getPackagedElements().add((Object)stereotype);
            ElementImport target = this.lookupMetaclass(profile, "Class");
            Extension extension = this.createExtension(stereotype, (Type)target.getImportedElement());
            extension.setName("E_" + stereotype.getName());
            profile.getPackagedElements().add((Object)extension);
            profile.define();
            Version curVersion = Util.getProfileDefinitionVersion((Profile)profile);
            Version version = new Version(curVersion.getMajor(), curVersion.getMinor(), curVersion.getMicro() + 4);
            PapyrusDefinitionAnnotation papyrusAnnotation = new PapyrusDefinitionAnnotation(version, "", "", "", "");
            ProfileRedefinition.redefineProfile((Package)profile, (PapyrusDefinitionAnnotation)papyrusAnnotation);
            ProfileRedefinition.cleanProfile((Package)profile);
            ServicesRegistry servicesRegistry = this.lookupServicesRegistry(context);
            UmlModel umlModel = UmlUtils.getUmlModelChecked((ServicesRegistry)servicesRegistry);
            Package rootPackage = (Package)umlModel.lookupRoot();
            rootPackage.applyProfile(profile);
            Activator.log.info("    ... New profile created");
        }
        catch (NotFoundException e) {
            e.printStackTrace();
            Activator.log.error("    ... Profile creation failed !!", (Throwable)e);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            Activator.log.error("    ... Profile creation failed !!", (Throwable)e);
        }
    }

    private ElementImport lookupMetaclass(Profile profile, String aliasName) {
        for (ElementImport ele : profile.getElementImports()) {
            if (!aliasName.equals(ele.getAlias())) continue;
            return ele;
        }
        return null;
    }

    protected Extension createExtension(Stereotype source, Type target) {
        Extension newExtension = UMLFactory.eINSTANCE.createExtension();
        ExtensionEnd endSource = UMLFactory.eINSTANCE.createExtensionEnd();
        endSource.setName("extension_" + source.getName());
        endSource.setType((Type)source);
        endSource.setAggregation(AggregationKind.COMPOSITE_LITERAL);
        newExtension.getOwnedEnds().add((Object)endSource);
        Property property = UMLFactory.eINSTANCE.createProperty();
        property.setName("base_" + target.getName());
        property.setType(target);
        property.setAssociation((Association)newExtension);
        property.setAggregation(AggregationKind.NONE_LITERAL);
        newExtension.getMemberEnds().add((Object)property);
        source.getOwnedAttributes().add((Object)property);
        return newExtension;
    }

    @Override
    public boolean isEnabled(IEvaluationContext context, List<Object> selections) {
        return !selections.isEmpty() && selections.get(0) instanceof Profile;
    }
}

