/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.papyrus.uml.profile.drafter.Activator;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.StereotypeURLChangeEvent;

public class StereotypeURL {
    static final String QUALIFIED_NAME = "qualifiedName";
    static final String PROFILE_NAME = "profileName";
    static final String STEREOTYPEE_NAME = "stereotypeName";
    static final String RESOURCEE_NAME = "resourceName";
    protected String qualifiedName = "";
    protected String profileName = "";
    protected String stereotypeName = "";
    protected String resourceName = "";
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private static int count = 0;

    public StereotypeURL() {
    }

    public StereotypeURL(String qualifiedName) {
        this.setQualifiedName(qualifiedName);
    }

    public StereotypeURL(String profileName, String stereotypeName) {
        this.profileName = profileName;
        this.stereotypeName = stereotypeName;
        this.qualifiedName = this.computeQualifiedName();
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.computeQualifiedName();
        }
        return this.qualifiedName;
    }

    public synchronized void setQualifiedName(String qualifiedName) {
        qualifiedName = qualifiedName.trim();
        int num = count++;
        try {
            if (qualifiedName == null) {
                return;
            }
            if (this.qualifiedName != null && this.qualifiedName.equals(qualifiedName)) {
                return;
            }
            String stereotypeName = "";
            String profileName = "";
            String resourceName = "";
            if (qualifiedName.startsWith("//")) {
                qualifiedName = qualifiedName.substring(2);
            } else if (qualifiedName.startsWith("/")) {
                qualifiedName = qualifiedName.substring(1);
            }
            int index = qualifiedName.indexOf("/");
            if (index > 0) {
                resourceName = qualifiedName.substring(0, index);
                qualifiedName = qualifiedName.substring(index + 1);
            }
            if ((index = qualifiedName.lastIndexOf("::")) == -1) {
                stereotypeName = qualifiedName;
                profileName = "";
            } else {
                stereotypeName = qualifiedName.substring(index + 2);
                profileName = qualifiedName.substring(0, index);
            }
            this.qualifiedName = StereotypeURL.computeQualifiedName(resourceName, profileName, stereotypeName);
            StereotypeURLChangeEvent ev = this.createStereotypeURLChangeEvent(this.qualifiedName, this.qualifiedName);
            this.stereotypeName = stereotypeName;
            ev.setStereotypeNameValues(this.stereotypeName, this.stereotypeName);
            this.profileName = profileName;
            ev.setProfileNameValues(this.profileName, this.profileName);
            this.resourceName = resourceName;
            ev.setResourceNameValues(this.resourceName, this.resourceName);
            this.qualifiedNameChanged(ev);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    public void clear() {
        this.qualifiedName = "";
        StereotypeURLChangeEvent ev = this.createStereotypeURLChangeEvent(this.qualifiedName, "");
        this.profileName = "";
        ev.setProfileNameValues(this.profileName, "");
        this.stereotypeName = "";
        ev.setStereotypeNameValues(this.stereotypeName, "");
        this.resourceName = "";
        ev.setResourceNameValues(this.resourceName, "");
        this.qualifiedNameChanged(ev);
    }

    public String getStereotypeName() {
        return this.stereotypeName;
    }

    public void setStereotypeName(String stereotypeName) {
        if (stereotypeName == null) {
            return;
        }
        if (this.stereotypeName != null && this.stereotypeName.equals(stereotypeName)) {
            return;
        }
        String oldStereotypeName = this.stereotypeName;
        this.stereotypeName = stereotypeName;
        this.qualifiedName = this.computeQualifiedName();
        StereotypeURLChangeEvent ev = this.createStereotypeURLChangeEvent(this.qualifiedName, this.qualifiedName);
        ev.setStereotypeNameValues(oldStereotypeName, stereotypeName);
        this.qualifiedNameChanged(ev);
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        if (profileName == null) {
            return;
        }
        if (this.profileName != null && this.profileName.equals(profileName)) {
            return;
        }
        String oldProfileName = this.profileName;
        this.profileName = profileName;
        this.qualifiedName = this.computeQualifiedName();
        StereotypeURLChangeEvent ev = this.createStereotypeURLChangeEvent(this.qualifiedName, this.qualifiedName);
        ev.setProfileNameValues(oldProfileName, profileName);
        this.qualifiedNameChanged(ev);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        if (resourceName == null) {
            return;
        }
        if (this.resourceName != null && this.resourceName.equals(resourceName)) {
            return;
        }
        String oldResourceName = this.resourceName;
        this.resourceName = resourceName;
        this.qualifiedName = this.computeQualifiedName();
        StereotypeURLChangeEvent ev = this.createStereotypeURLChangeEvent(this.qualifiedName, this.qualifiedName);
        ev.setResourceNameValues(oldResourceName, resourceName);
        this.qualifiedNameChanged(ev);
    }

    protected void qualifiedNameChanged(StereotypeURLChangeEvent event) {
        this.changeSupport.firePropertyChange(event);
        if (event.isProfileNameChanged()) {
            this.firePropertyChange(PROFILE_NAME, event.getOldProfileName(), event.getProfileName());
        }
        if (event.isStereotypeNameChanged()) {
            this.firePropertyChange(STEREOTYPEE_NAME, event.getOldStereotypeName(), event.getStereotypeName());
        }
        if (event.isResourceNameChanged()) {
            this.firePropertyChange(RESOURCEE_NAME, event.getOldResourceName(), event.getResourceName());
        }
        if (event.isQualifiedNameChanged()) {
            this.firePropertyChange(QUALIFIED_NAME, event.getOldQualifiedName(), event.getQualifiedName());
        }
    }

    protected StereotypeURLChangeEvent createStereotypeURLChangeEvent(String oldValue, String newValue) {
        return new StereotypeURLChangeEvent(this, oldValue, newValue);
    }

    public String computeQualifiedName() {
        return StereotypeURL.computeQualifiedName(this.resourceName, this.profileName, this.stereotypeName);
    }

    public static String computeQualifiedName(String resourceName, String profileName, String stereotypeName) {
        StringBuilder buf = new StringBuilder();
        if (resourceName != null && resourceName.length() > 0) {
            buf.append("//").append(resourceName).append("/");
        }
        if (profileName != null && profileName.length() > 0) {
            buf.append(profileName);
        }
        if (stereotypeName != null && stereotypeName.length() > 0) {
            if (buf.length() > 0 && buf.charAt(buf.length() - 1) != '/') {
                buf.append("::");
            }
            buf.append(stereotypeName);
        }
        return buf.toString();
    }

    public String toString() {
        return this.qualifiedName;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        this.changeSupport.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    public PropertyChangeSupport getChangeSupport() {
        return this.changeSupport;
    }
}

