/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.providers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.uml.diagram.wizards.pages.NewDiagramForExistingModelPage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.NewModelFilePage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectDiagramCategoryPage;
import org.eclipse.papyrus.uml.diagram.wizards.providers.AbstractNewModelStorageProvider;
import org.eclipse.papyrus.uml.diagram.wizards.utils.WizardsHelper;
import org.eclipse.papyrus.uml.diagram.wizards.wizards.CreateModelWizard;
import org.eclipse.papyrus.uml.diagram.wizards.wizards.InitModelWizard;

public class WorkspaceNewModelStorageProvider
extends AbstractNewModelStorageProvider {
    private CreateModelWizard wizard;
    private NewModelFilePage newModelFilePage;
    private SelectDiagramCategoryPage newDiagramCategoryPage;

    @Override
    public boolean canHandle(IStructuredSelection initialSelection) {
        boolean result = false;
        for (Object next : initialSelection.toList()) {
            if (WizardsHelper.adapt(next, IResource.class) == null) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public void init(CreateModelWizard wizard, IStructuredSelection selection) {
        super.init(wizard, selection);
        this.wizard = wizard;
        this.newModelFilePage = this.createNewModelFilePage(selection);
        this.newDiagramCategoryPage = this.createNewDiagramCategoryPage(selection);
    }

    @Override
    public List<? extends IWizardPage> createPages() {
        if (this.newModelFilePage == null && this.newDiagramCategoryPage == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(new WizardPage[]{this.newDiagramCategoryPage, this.newModelFilePage});
    }

    @Override
    public IStatus validateDiagramCategories(String ... newCategories) {
        if (this.newModelFilePage != null) {
            String firstCategory;
            String string = firstCategory = newCategories.length > 0 ? newCategories[0] : null;
            if (newCategories.length > 0) {
                return this.newModelFilePage.diagramExtensionChanged(this.wizard.getDiagramFileExtension(firstCategory));
            }
        }
        return super.validateDiagramCategories(newCategories);
    }

    protected NewModelFilePage createNewModelFilePage(IStructuredSelection selection) {
        if (this.wizard.isCreateProjectWizard() || this.wizard.isCreateMultipleModelsWizard()) {
            return null;
        }
        URI selectedResourceURI = WizardsHelper.getSelectedResourceURI(selection);
        if (this.isCreateFromExistingDomainModel() && selectedResourceURI != null) {
            return new NewDiagramForExistingModelPage(selection, this.wizard.getModelKindName(), String.valueOf(this.getDiagramFileName(selectedResourceURI)) + "." + this.wizard.getDiagramFileExtension(null), this.wizard.getDiagramFileExtension(null));
        }
        return new NewModelFilePage(selection, this.wizard.getModelKindName());
    }

    protected String getDiagramFileName(URI domainModelURI) {
        return domainModelURI.trimFileExtension().lastSegment();
    }

    protected boolean isCreateFromExistingDomainModel() {
        return this.wizard.isInitModelWizard() && ((InitModelWizard)this.wizard).isCreateFromExistingDomainModel();
    }

    @Override
    public URI createNewModelURI(String categoryId) {
        IFile newFile = this.newModelFilePage.createNewFile();
        URI fileURI = URI.createPlatformResourceURI((String)newFile.getFullPath().toString(), (boolean)true);
        try {
            newFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        return fileURI;
    }

    private SelectDiagramCategoryPage createNewDiagramCategoryPage(IStructuredSelection selection) {
        if (this.wizard.isCreateProjectWizard() || this.wizard.isCreateMultipleModelsWizard() || !this.wizard.isPapyrusRootWizard()) {
            return null;
        }
        return new SelectDiagramCategoryPage();
    }

    @Override
    public SelectDiagramCategoryPage getDiagramCategoryPage() {
        return this.newDiagramCategoryPage;
    }
}

