/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.chessextension.managers;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.ui.IEditorPart;
import org.polarsys.chess.contracts.chessextension.Activator;
import org.polarsys.chess.core.constraint.PreferenceProperties;
import org.polarsys.chess.core.views.DiagramStatus;

public class PaletteManager {
    protected static List<Object> lookupSelectedElements(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return structuredSelection.toList();
        }
        if (selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)selection;
            return treeSelection.toList();
        }
        return null;
    }

    public static void setPaletteVisibility(PapyrusMultiDiagramEditor editor, DiagramStatus ds) {
        Boolean checkPalette = org.polarsys.chess.core.Activator.getDefault().getPreferenceStore().getBoolean(PreferenceProperties.PALETTES_IN_VIEW);
        if (!checkPalette.booleanValue()) {
            return;
        }
        try {
            GraphicalEditPart a;
            IEditorPart ep = editor.getActiveEditor();
            if (ep == null) {
                return;
            }
            ISelection selection = ep.getSite().getSelectionProvider().getSelection();
            List<Object> selections = PaletteManager.lookupSelectedElements(selection);
            DiagramEditDomain de = null;
            if (selections.get(0) instanceof GraphicalEditPart) {
                a = (GraphicalEditPart)selections.get(0);
                de = (DiagramEditDomain)a.getDiagramEditDomain();
            } else if (selections.get(0) instanceof ConnectionEditPart) {
                a = (ConnectionEditPart)selections.get(0);
                de = (DiagramEditDomain)a.getDiagramEditDomain();
            }
            if (de == null) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.chess.contracts.chessextension", "cannot retrieve DiagramEditDomain"));
                return;
            }
            PaletteViewer pv = de.getPaletteViewer();
            String viewName = ds.getActiveView();
            String diagramName = ds.getCurrentView().getCurrentDiagramName();
            for (Object o : pv.getPaletteRoot().getChildren()) {
                if (!(o instanceof PaletteDrawer)) continue;
                PaletteDrawer d = (PaletteDrawer)o;
                PaletteManager.setPaletteVisibility(d, viewName, diagramName);
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.chess.contracts.chessextension", e.getMessage()));
            e.printStackTrace();
        }
    }

    private static void setPaletteVisibility(PaletteDrawer paletteDrawer, String viewName, String diagramName) {
        if (!viewName.equals("SystemView")) {
            return;
        }
        paletteDrawer.setVisible(true);
        paletteDrawer.getLabel();
        String paletteId = paletteDrawer.getId();
        if (viewName.equals("SystemView")) {
            if (diagramName.compareTo("BlockDefinition") == 0) {
                paletteDrawer.setVisible(false);
                if (paletteId.compareTo("ForeverBDDAssociationsDrawerID") == 0 || paletteId.compareTo("ForeverBDDModelElementsDrawerID") == 0 || paletteId.compareTo("ForeverBDDPortAndFlowsDrawerID") == 0 || paletteId.compareTo("ForeverBDDDataTypesDrawerID") == 0 || paletteId.compareTo("ForeverBDDContractsDrawerID") == 0) {
                    paletteDrawer.setVisible(true);
                }
            }
            if (diagramName.equals("InternalBlock")) {
                paletteDrawer.setVisible(false);
                if (paletteId.compareTo("ForeverIBDNodesDrawerID") == 0 || paletteId.compareTo("ForeverIBDEdgesDrawerID") == 0) {
                    paletteDrawer.setVisible(true);
                }
            }
            if (diagramName.equals("PapyrusUMLClassDiagram")) {
                paletteDrawer.setVisible(true);
            }
            if (diagramName.equals("CompositeStructure")) {
                paletteDrawer.setVisible(true);
            }
        }
    }
}

