/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.sam.arg.ui.figures;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.opencert.sam.arg.ui.figures.FixedConnectionAnchor;

public class DefaultSizeNodeFigureWithFixedAnchors
extends DefaultSizeNodeFigure {
    private HashMap<String, FixedConnectionAnchor> anchors = new HashMap();

    public DefaultSizeNodeFigureWithFixedAnchors(Dimension defSize, HashMap<String, PrecisionPoint> anchorLocations) {
        this(defSize.width, defSize.height, anchorLocations);
    }

    public DefaultSizeNodeFigureWithFixedAnchors(int width, int height, HashMap<String, PrecisionPoint> anchorLocations) {
        super(width, height);
        if (anchorLocations.size() == 0) {
            throw new IllegalArgumentException("At least one fixed anchor must be specified");
        }
        for (String terminal : anchorLocations.keySet()) {
            PrecisionPoint anchorLocation = anchorLocations.get(terminal);
            this.anchors.put(terminal, new FixedConnectionAnchor((IFigure)this, anchorLocation));
        }
    }

    public ConnectionAnchor getSourceConnectionAnchorAt(Point p) {
        return this.findNearestAnchorFrom(p);
    }

    public ConnectionAnchor getTargetConnectionAnchorAt(Point p) {
        return this.findNearestAnchorFrom(p);
    }

    public ConnectionAnchor getConnectionAnchor(String terminal) {
        return (ConnectionAnchor)this.anchors.get(terminal);
    }

    public String getConnectionAnchorTerminal(ConnectionAnchor c) {
        String selectedTerminal = null;
        Iterator<String> terminals = this.anchors.keySet().iterator();
        while (terminals.hasNext() && selectedTerminal == null) {
            String terminal = terminals.next();
            FixedConnectionAnchor anchor = this.anchors.get(terminal);
            if (anchor != c) continue;
            selectedTerminal = terminal;
        }
        return selectedTerminal;
    }

    private ConnectionAnchor findNearestAnchorFrom(Point point) {
        ConnectionAnchor result = null;
        if (point == null || this.anchors.size() == 1) {
            result = (ConnectionAnchor)this.anchors.values().iterator().next();
        } else {
            double minDistance = Double.MAX_VALUE;
            String nearestTerminal = null;
            for (String terminal : this.anchors.keySet()) {
                FixedConnectionAnchor anchor = this.anchors.get(terminal);
                Point anchorPosition = anchor.getLocation();
                double distance = point.getDistance(anchorPosition);
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                nearestTerminal = terminal;
            }
            result = (ConnectionAnchor)this.anchors.get(nearestTerminal);
        }
        return result;
    }
}

