/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.sam.arg.ui.views;

import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.opencert.sam.arg.ui.dnd.TreeDragFileListener;
import org.eclipse.opencert.sam.arg.ui.util.TreeListFiles;
import org.eclipse.opencert.sam.arg.ui.views.ExplorerComponent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;

public class ExpandBarView
extends ViewPart {
    public static final String ID = "org.eclipse.opencert.sam.arg.ui.views.ExpandBarView";
    ExplorerComponent MEView0;
    ExplorerComponent MEView1;
    private ExpandBar viewer;
    private DrillDownAdapter drillDownAdapter0;
    private Action doubleClickAction0;
    private DrillDownAdapter drillDownAdapter1;
    private Action doubleClickAction1;

    public void createPartControl(Composite parent) {
        String modulesDir = Platform.getPreferencesService().getString("org.eclipse.opencert.sam.preferences", "modulePathPreference", "Modules Dir wrong", null);
        String patternsDir = Platform.getPreferencesService().getString("org.eclipse.opencert.sam.preferences", "patternPathPreference", "Patterns Dir wrong", null);
        String sDirFiles = String.valueOf(patternsDir.substring(0, patternsDir.lastIndexOf("\\"))) + "\\MyResults";
        this.viewer = new ExpandBar(parent, 512);
        Composite container0 = new Composite((Composite)this.viewer, 0);
        FillLayout layout0 = new FillLayout();
        container0.setLayout((Layout)layout0);
        this.MEView0 = new ExplorerComponent(this.getViewSite(), patternsDir, "Pattern Explorer");
        this.MEView0.createPartControl(container0);
        URL url = ((Object)((Object)this)).getClass().getResource("/icons/database-16.gif");
        Image image0 = ImageDescriptor.createFromURL((URL)url).createImage();
        ExpandItem item0 = new ExpandItem(this.viewer, 0, 0);
        item0.setText("Pattern Explorer");
        item0.setHeight(container0.computeSize((int)-1, (int)-1).y);
        item0.setControl((Control)container0);
        item0.setImage(image0);
        Composite container1 = new Composite((Composite)this.viewer, 0);
        FillLayout layout1 = new FillLayout();
        container1.setLayout((Layout)layout1);
        this.MEView1 = new ExplorerComponent(this.getViewSite(), modulesDir, "Module Explorer");
        this.MEView1.createPartControl(container1);
        Image image1 = ImageDescriptor.createFromURL((URL)url).createImage();
        ExpandItem item1 = new ExpandItem(this.viewer, 0, 1);
        item1.setText("Module Explorer");
        item1.setHeight(container1.computeSize((int)-1, (int)-1).y);
        item1.setControl((Control)container1);
        item1.setImage(image1);
        container0.setRedraw(true);
        item1.setExpanded(true);
        this.viewer.addExpandListener(new ExpandListener(){

            public void itemExpanded(ExpandEvent e) {
                ExpandItem item = (ExpandItem)e.item;
                ExplorerComponent ec = item.getText().compareTo("Pattern Explorer") == 0 ? ExpandBarView.this.MEView0 : ExpandBarView.this.MEView1;
                ExplorerComponent.ViewContentProvider cp = (ExplorerComponent.ViewContentProvider)ec.viewer.getContentProvider();
                cp.initialize();
                ec.viewer.setInput((Object)ExpandBarView.this.getViewSite());
                ec.viewer.expandToLevel(-1);
            }

            public void itemCollapsed(ExpandEvent e) {
            }
        });
        this.makeActions();
        this.contributeToActionBars();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.MEView0.viewer.getControl(), "org.eclipse.opencert.sam.arg.ui.viewer");
        this.drillDownAdapter0 = new DrillDownAdapter(this.MEView0.viewer);
        this.hookContextMenu(this.MEView0.viewer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.MEView1.viewer.getControl(), "org.eclipse.opencert.sam.arg.ui.viewer");
        this.drillDownAdapter1 = new DrillDownAdapter(this.MEView1.viewer);
        this.hookContextMenu(this.MEView1.viewer);
        int operations = 1;
        Transfer[] transferTypes = new Transfer[]{LocalTransfer.getInstance()};
        this.MEView0.viewer.addDragSupport(operations, transferTypes, (DragSourceListener)new TreeDragFileListener((Viewer)this.MEView0.viewer, sDirFiles));
        this.MEView1.viewer.addDragSupport(operations, transferTypes, (DragSourceListener)new TreeDragFileListener((Viewer)this.MEView1.viewer, sDirFiles));
    }

    private void hookContextMenu(final TreeViewer vw) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ExpandBarView.this.fillContextMenu(manager, vw);
            }
        });
        Menu menu = menuMgr.createContextMenu(vw.getControl());
        vw.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)vw);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
    }

    private void fillContextMenu(IMenuManager manager, TreeViewer vw) {
        if (vw.equals(this.MEView0.viewer)) {
            this.drillDownAdapter0.addNavigationActions(manager);
        } else if (vw.equals(this.MEView1.viewer)) {
            this.drillDownAdapter1.addNavigationActions(manager);
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
    }

    private void fillLocalToolBar(IToolBarManager manager, TreeViewer vw) {
        if (vw.equals(this.MEView0.viewer)) {
            this.drillDownAdapter0.addNavigationActions(manager);
        } else if (vw.equals(this.MEView1.viewer)) {
            this.drillDownAdapter1.addNavigationActions(manager);
        }
    }

    private void makeActions() {
        this.doubleClickAction0 = new Action(){

            public void run() {
                ISelection selection = ExpandBarView.this.MEView0.viewer.getSelection();
                TreeListFiles.TreeObject obj = (TreeListFiles.TreeObject)((IStructuredSelection)selection).getFirstElement();
                File file = new File(obj.getFullName());
                if (!file.isFile() || !obj.getFullName().contains(".arg") && !obj.getFullName().contains(".gsn1")) {
                    return;
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IPath location = Path.fromOSString((String)file.getAbsolutePath());
                IFile file2 = workspace.getRoot().getFileForLocation(location);
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    page.openEditor((IEditorInput)new FileEditorInput(file2), PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file2.getFullPath().toString()).getId());
                }
                catch (PartInitException exception) {
                    exception.printStackTrace();
                }
            }
        };
        this.doubleClickAction1 = new Action(){

            public void run() {
                ISelection selection = ExpandBarView.this.MEView1.viewer.getSelection();
                TreeListFiles.TreeObject obj = (TreeListFiles.TreeObject)((IStructuredSelection)selection).getFirstElement();
                File file = new File(obj.getFullName());
                if (!file.isFile() || !obj.getFullName().contains(".arg") && !obj.getFullName().contains(".gsn1")) {
                    return;
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IPath location = Path.fromOSString((String)file.getAbsolutePath());
                IFile file2 = workspace.getRoot().getFileForLocation(location);
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    page.openEditor((IEditorInput)new FileEditorInput(file2), PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file2.getFullPath().toString()).getId());
                }
                catch (PartInitException exception) {
                    exception.printStackTrace();
                }
            }
        };
    }

    public void setFocus() {
        this.viewer.setFocus();
    }
}

