/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.refactoring;

import org.apache.log4j.Logger;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameLocalVariableProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameNonVirtualMethodProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeParameterProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameVirtualMethodProcessor;

public class JdtRenameRefactoringProcessorFactory {
    private static final Logger LOG = Logger.getLogger(JdtRenameRefactoringProcessorFactory.class);

    public JavaRenameProcessor createRenameProcessor(IJavaElement element) {
        try {
            switch (element.getElementType()) {
                case 7: {
                    return new RenameTypeProcessor((IType)element);
                }
                case 8: {
                    return new RenameFieldProcessor((IField)element);
                }
                case 9: {
                    if (((IMethod)element).isConstructor()) break;
                    if (Flags.isStatic((int)((IMethod)element).getFlags())) {
                        return new RenameNonVirtualMethodProcessor((IMethod)element);
                    }
                    return new RenameVirtualMethodProcessor((IMethod)element);
                }
                case 15: {
                    return new RenameTypeParameterProcessor((ITypeParameter)element);
                }
                case 14: {
                    return new RenameLocalVariableProcessor((ILocalVariable)element);
                }
            }
        }
        catch (JavaModelException exc) {
            LOG.error((Object)("Error creating refactoring processor for " + element.getElementName()), (Throwable)exc);
        }
        return null;
    }
}

