/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.evm.evidspec.evidence.util;

import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JOptionPane;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.opencert.evm.evidspec.evidence.util.ImageUtils;
import org.eclipse.opencert.infra.svnkit.MainClass;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNNodeKind;

public class SVNTreeDialog
extends Dialog {
    protected ILabelProvider labelProvider;
    protected IContentProvider contentProvider;
    protected String displayName;
    protected ItemProvider values;
    protected String result;
    protected MainClass validateInstance;
    protected Boolean onlyFolders;
    public Tree choiceTree;
    public final String EVDLG_IMGS_DIR_OPEN = "dir_open";
    public final String EVDLG_IMGS_DIR_CLOSED = "dir_closed";
    public final String EVDLG_IMGS_FILE = "file";
    private ImageUtils imageUtility;

    public SVNTreeDialog(Shell parent, ILabelProvider labelProvider, MainClass validateInstance, boolean onlyFolders, String currentValues, String displayName, ImageUtils imageUtil) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.labelProvider = labelProvider;
        this.validateInstance = validateInstance;
        this.onlyFolders = onlyFolders;
        this.displayName = displayName;
        this.imageUtility = imageUtil;
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(Collections.emptyList());
        this.values = new ItemProvider((AdapterFactory)adapterFactory, currentValues);
        this.contentProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.displayName);
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        GridLayout contentsGridLayout = (GridLayout)contents.getLayout();
        contentsGridLayout.numColumns = 1;
        GridData contentsGridData = (GridData)contents.getLayoutData();
        contentsGridData.horizontalAlignment = 4;
        contentsGridData.verticalAlignment = 4;
        Composite choiceComposite = new Composite(contents, 0);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalAlignment = 0x1000008;
        choiceComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        data.horizontalAlignment = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        choiceComposite.setLayout((Layout)layout);
        this.choiceTree = new Tree(choiceComposite, 67584);
        GridData choiceTreeGridData = new GridData();
        choiceTreeGridData.verticalAlignment = 4;
        choiceTreeGridData.horizontalAlignment = 4;
        choiceTreeGridData.widthHint = Display.getCurrent().getBounds().width / 5;
        choiceTreeGridData.heightHint = Display.getCurrent().getBounds().height / 5;
        choiceTreeGridData.grabExcessHorizontalSpace = true;
        choiceTreeGridData.grabExcessVerticalSpace = true;
        this.choiceTree.setLayoutData((Object)choiceTreeGridData);
        ArrayList roots = this.validateInstance.listEntries("", this.onlyFolders.booleanValue());
        int i = 0;
        while (i < roots.size()) {
            TreeItem root = new TreeItem(this.choiceTree, 0);
            SVNDirEntry entry = (SVNDirEntry)roots.get(i);
            root.setText(entry.getName());
            if (entry.getKind() == SVNNodeKind.DIR) {
                root.setImage(this.imageUtility.getClosedDirImage());
            } else {
                this.imageUtility.PutImage((Item)root, entry.getName());
            }
            root.setData((Object)entry.getName());
            new TreeItem(root, 0);
            ++i;
        }
        this.choiceTree.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                TreeItem root = (TreeItem)event.item;
                TreeItem[] items = root.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].getData() != null) {
                        return;
                    }
                    items[i].dispose();
                    ++i;
                }
                String filePath = (String)root.getData();
                ArrayList files = SVNTreeDialog.this.validateInstance.listEntries(filePath, SVNTreeDialog.this.onlyFolders.booleanValue());
                if (files == null) {
                    return;
                }
                int i2 = 0;
                while (i2 < files.size()) {
                    TreeItem item = new TreeItem(root, 0);
                    SVNDirEntry subEntry = (SVNDirEntry)files.get(i2);
                    item.setText(subEntry.getName());
                    if (subEntry.getKind() == SVNNodeKind.DIR) {
                        item.setImage(SVNTreeDialog.this.imageUtility.getClosedDirImage());
                    } else {
                        SVNTreeDialog.this.imageUtility.PutImage((Item)item, subEntry.getName());
                    }
                    item.setData((Object)(String.valueOf(filePath) + "/" + subEntry.getName()));
                    if (subEntry.getKind() == SVNNodeKind.DIR) {
                        new TreeItem(item, 0);
                    }
                    ++i2;
                }
            }
        });
        return contents;
    }

    protected void okPressed() {
        String value = "";
        if (this.choiceTree != null) {
            try {
                TreeItem[] selection = this.choiceTree.getSelection();
                TreeItem item = selection[0];
                value = item.getData().toString();
                if (!this.onlyFolders.booleanValue() && !this.validateInstance.existsFileRepo(value)) {
                    JOptionPane.showMessageDialog(null, "A file must be selected", "Error", 1);
                    return;
                }
                this.values.getChildren().add((Object)value);
            }
            catch (RuntimeException runtimeException) {}
        }
        this.result = value;
        super.okPressed();
    }

    public boolean close() {
        this.contentProvider.dispose();
        return super.close();
    }

    public String getResult() {
        return this.result;
    }
}

