/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.swt.graphics.Color;

public class Rectangular3DBorder
extends LineBorder {
    int borderwidth;

    public Rectangular3DBorder(int borderwidth, Color color) {
        super(color);
        this.borderwidth = borderwidth;
        this.setWidth(1);
    }

    public Insets getInsets(IFigure figure) {
        Insets insetsNew = super.getInsets(figure);
        insetsNew.top = 0;
        insetsNew.left = 0;
        insetsNew.bottom = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(insetsNew.bottom + this.borderwidth);
        insetsNew.right = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(insetsNew.right + this.borderwidth);
        return insetsNew;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        graphics.pushState();
        tempRect.setBounds(Rectangular3DBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        int width = this.getWidth();
        if (width > 0 && width % 2 == 1) {
            --Rectangular3DBorder.tempRect.width;
            --Rectangular3DBorder.tempRect.height;
        }
        tempRect.shrink(width / 2, width / 2);
        graphics.setLineWidth(width);
        if (this.getColor() != null) {
            graphics.setForegroundColor(this.getColor());
        } else {
            graphics.setForegroundColor(ColorConstants.black);
        }
        graphics.drawRectangle(tempRect);
        Rectangle newRect = new Rectangle(tempRect);
        newRect.width += this.borderwidth;
        newRect.height += this.borderwidth;
        graphics.setClip(newRect);
        PointList plt = new PointList();
        plt.addPoint(Rectangular3DBorder.tempRect.x + Rectangular3DBorder.tempRect.width, Rectangular3DBorder.tempRect.y + Rectangular3DBorder.tempRect.height);
        plt.addPoint(Rectangular3DBorder.tempRect.x + Rectangular3DBorder.tempRect.width, Rectangular3DBorder.tempRect.y);
        plt.addPoint(Rectangular3DBorder.tempRect.x + Rectangular3DBorder.tempRect.width + this.borderwidth, Rectangular3DBorder.tempRect.y + this.borderwidth);
        plt.addPoint(Rectangular3DBorder.tempRect.x + Rectangular3DBorder.tempRect.width + this.borderwidth, Rectangular3DBorder.tempRect.y + Rectangular3DBorder.tempRect.height + this.borderwidth);
        plt.addPoint(Rectangular3DBorder.tempRect.x + this.borderwidth, Rectangular3DBorder.tempRect.y + Rectangular3DBorder.tempRect.height + this.borderwidth);
        plt.addPoint(Rectangular3DBorder.tempRect.x, Rectangular3DBorder.tempRect.y + Rectangular3DBorder.tempRect.height);
        plt.addPoint(Rectangular3DBorder.tempRect.x + Rectangular3DBorder.tempRect.width, Rectangular3DBorder.tempRect.y + Rectangular3DBorder.tempRect.height);
        if (this.getColor() != null) {
            graphics.setBackgroundColor(this.getColor());
        } else {
            graphics.setBackgroundColor(ColorConstants.gray);
        }
        graphics.fillPolygon(plt);
        graphics.popState();
    }
}

