/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.internal.emf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationCatalogManager;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationCatalogManagerFactory;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.papyrus.emf.facet.custom.ui.CustomizedContentProviderUtils;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.emf.CustomizationComparator;
import org.eclipse.papyrus.infra.emf.readonly.spi.IReadOnlyManagerProcessor;
import org.eclipse.papyrus.infra.emf.spi.resolver.IEObjectResolver;
import org.eclipse.papyrus.infra.ui.internal.emf.readonly.EditorReloadProcessor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.papyrus.infra.ui.emf";
    private static Activator plugin;
    public static LogHelper log;
    private ServiceRegistration<IEObjectResolver> eobjectResolverReg;
    private ServiceRegistration<IReadOnlyManagerProcessor> roManagerProcessorReg;
    private ICustomizationManager customizationManager;
    public static final String CUSTOMIZATION_MANAGER_SECTION = "org.eclipse.papyrus.infra.ui.emf.customizationManager";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)this);
        this.eobjectResolverReg = context.registerService(IEObjectResolver.class, CustomizedContentProviderUtils::resolve, null);
        this.roManagerProcessorReg = context.registerService(IReadOnlyManagerProcessor.class, (Object)new EditorReloadProcessor(), null);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.roManagerProcessorReg != null) {
            this.roManagerProcessorReg.unregister();
            this.roManagerProcessorReg = null;
        }
        if (this.eobjectResolverReg != null) {
            this.eobjectResolverReg.unregister();
            this.eobjectResolverReg = null;
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void saveCustomizationManagerState() {
        IDialogSettings dialogSettings = this.getBrowserCustomizationDialogSettings();
        List appliedCustomizations = this.getCustomizationManager().getManagedCustomizations();
        List registeredCustomizations = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager(this.getCustomizationManager().getResourceSet()).getRegisteredCustomizations();
        for (Customization customization : registeredCustomizations) {
            boolean isApplied = appliedCustomizations.contains(customization);
            String settingKey = this.getSettingKey(customization);
            dialogSettings.put(settingKey, isApplied);
        }
    }

    private String getSettingKey(Customization customization) {
        return customization.eResource().getURI().toString();
    }

    protected IDialogSettings getBrowserCustomizationDialogSettings() {
        String sectionId = CUSTOMIZATION_MANAGER_SECTION;
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(sectionId);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(sectionId);
        }
        return settings;
    }

    private void init(ICustomizationManager customizationManager) {
        IDialogSettings settings = this.getBrowserCustomizationDialogSettings();
        try {
            ICustomizationCatalogManager customCatalog = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager(customizationManager.getResourceSet());
            List registryAllCustomizations = customCatalog.getRegisteredCustomizations();
            ArrayList<Customization> orderedCustomizationList = new ArrayList<Customization>();
            for (Customization customization : registryAllCustomizations) {
                String settingKey = this.getSettingKey(customization);
                boolean isActive = false;
                isActive = settings.get(settingKey) == null ? customization.isMustBeLoadedByDefault() : settings.getBoolean(settingKey);
                if (!isActive) continue;
                orderedCustomizationList.add(customization);
            }
            Collections.sort(orderedCustomizationList, new CustomizationComparator());
            customizationManager.getManagedCustomizations().addAll(orderedCustomizationList);
        }
        catch (Throwable e) {
            log.log((IStatus)new Status(4, PLUGIN_ID, "Error initializing customizations", e));
        }
    }

    public void restoreDefaultCustomizationManager() {
        DialogSettings settings = (DialogSettings)this.getDialogSettings();
        settings.removeSection(CUSTOMIZATION_MANAGER_SECTION);
    }

    public ICustomizationManager getCustomizationManager() {
        if (this.customizationManager == null) {
            this.customizationManager = org.eclipse.papyrus.infra.emf.Activator.getDefault().getCustomizationManager();
            this.init(this.getCustomizationManager());
        }
        return this.customizationManager;
    }
}

