/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.storage.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.customization.properties.Activator;
import org.eclipse.papyrus.customization.properties.storage.actions.IContextCopyAction;
import org.eclipse.papyrus.customization.properties.storage.actions.IContextDeleteAction;
import org.eclipse.papyrus.customization.properties.storage.actions.IContextEditAction;
import org.eclipse.papyrus.customization.properties.storage.actions.IContextStorageActionProvider;
import org.eclipse.papyrus.infra.core.utils.OneTimeRegistryReader;
import org.eclipse.papyrus.infra.properties.contexts.Context;

public class ContextStorageActionRegistry {
    private static final String EXT_POINT = "contextStorage";
    private final List<IContextStorageActionProvider> providers = new ArrayList<IContextStorageActionProvider>();

    public ContextStorageActionRegistry() {
        new MyRegistryReader().readRegistry();
    }

    public List<IContextStorageActionProvider> getStorageActionProviders() {
        return Collections.unmodifiableList(this.providers);
    }

    public IContextStorageActionProvider getStorageActionProvider(Context context) {
        IContextStorageActionProvider result = IContextStorageActionProvider.READ_ONLY;
        for (IContextStorageActionProvider next : this.providers) {
            if (!next.providesFor(context)) continue;
            result = next;
            break;
        }
        return result;
    }

    public IContextCopyAction getContextCopyAction(Context context) {
        return this.getStorageActionProvider(context).getContextCopyAction();
    }

    public IContextEditAction getContextEditAction(Context context) {
        return this.getStorageActionProvider(context).getContextEditAction();
    }

    public IContextDeleteAction getContextDeleteAction(Context context) {
        return this.getStorageActionProvider(context).getContextDeleteAction();
    }

    private class MyRegistryReader
    extends OneTimeRegistryReader {
        private static final String A_CLASS = "class";
        private static final String E_ACTION_PROVIDER = "actionProvider";
        private Map<IContextStorageActionProvider, IConfigurationElement> providerElements;

        MyRegistryReader() {
            super(Platform.getExtensionRegistry(), "org.eclipse.papyrus.customization.properties", ContextStorageActionRegistry.EXT_POINT);
            this.providerElements = new HashMap<IContextStorageActionProvider, IConfigurationElement>();
        }

        public void readRegistry() {
            super.readRegistry();
            Collections.sort(ContextStorageActionRegistry.this.providers, new Comparator<IContextStorageActionProvider>(){

                @Override
                public int compare(IContextStorageActionProvider o1, IContextStorageActionProvider o2) {
                    int result = 0;
                    if (MyRegistryReader.this.isOurs(o1)) {
                        result = MyRegistryReader.this.isOurs(o2) ? 0 : -1;
                    } else if (MyRegistryReader.this.isOurs(o2)) {
                        result = 1;
                    }
                    return result;
                }
            });
        }

        private boolean isOurs(IContextStorageActionProvider provider) {
            boolean result = false;
            IConfigurationElement config = this.providerElements.get(provider);
            if (config != null) {
                "org.eclipse.papyrus.customization.properties".equals(config.getContributor().getName());
            }
            return result;
        }

        protected boolean readElement(IConfigurationElement element) {
            boolean result = true;
            if (E_ACTION_PROVIDER.equals(element.getName())) {
                try {
                    ContextStorageActionRegistry.this.providers.add((IContextStorageActionProvider)element.createExecutableExtension(A_CLASS));
                }
                catch (Exception e) {
                    result = false;
                    Activator.log.error("Failed to instantiate context storage action provider extension.", (Throwable)e);
                }
            }
            return result;
        }
    }
}

