/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.es2as;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.AssociationClass;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.ProfileApplication;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Stereotype;
import org.eclipse.ocl.pivot.StereotypeExtender;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.ecore.es2as.AbstractExternal2AS;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.AliasAdapter;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.External2AS;
import org.eclipse.ocl.pivot.internal.utilities.PivotObjectImpl;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.uml.UMLStandaloneSetup;
import org.eclipse.ocl.pivot.uml.internal.es2as.AssociationClassProperties;
import org.eclipse.ocl.pivot.uml.internal.es2as.ModelAnalysis;
import org.eclipse.ocl.pivot.uml.internal.es2as.ProfileAnalysis;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2ASDeclarationSwitch;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2ASReferenceSwitch;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2ASUseSwitch;
import org.eclipse.ocl.pivot.uml.internal.oclforuml.OCLforUMLPackage;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;
import org.eclipse.ocl.pivot.values.UnlimitedValue;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.resource.UMLResource;
import org.eclipse.uml2.uml.resources.util.UMLResourcesUtil;
import org.eclipse.uml2.uml.util.UMLUtil;

public abstract class UML2AS
extends AbstractExternal2AS {
    public static final @NonNull TracingOption ADD_ELEMENT_EXTENSION = new TracingOption("org.eclipse.ocl.pivot", "uml2as/addElementExtension");
    public static final @NonNull TracingOption ADD_IMPORTED_RESOURCE = new TracingOption("org.eclipse.ocl.pivot", "uml2as/addImportedResource");
    public static final @NonNull TracingOption ADD_PROFILE_APPLICATION = new TracingOption("org.eclipse.ocl.pivot", "uml2as/addProfileApplication");
    public static final @NonNull TracingOption ADD_STEREOTYPE_APPLICATION = new TracingOption("org.eclipse.ocl.pivot", "uml2as/addStereotypeApplication");
    public static final @NonNull TracingOption ADD_TYPE_EXTENSION = new TracingOption("org.eclipse.ocl.pivot", "uml2as/addTypeExtension");
    public static final @NonNull TracingOption APPLICABLE_STEREOTYPES = new TracingOption("org.eclipse.ocl.pivot", "uml2as/applicableStereotypes");
    public static final @NonNull TracingOption CONVERT_RESOURCE = new TracingOption("org.eclipse.ocl.pivot", "uml2as/convertResource");
    public static final @NonNull TracingOption TYPE_EXTENSIONS = new TracingOption("org.eclipse.ocl.pivot", "uml2as/typeExtensions");
    protected static final @NonNull String OCLforUML = (String)ClassUtil.nonNullModel((Object)NameUtil.getOriginalName((ENamedElement)((ENamedElement)ClassUtil.nonNullModel((Object)OCLforUMLPackage.eINSTANCE))));
    protected static final @NonNull String OCLforUML_COLLECTION = "OCLforUML::" + OCLforUMLPackage.Literals.COLLECTION.getName();
    protected static final @NonNull String OCLforUML_COLLECTION_IS_NULL_FREE_NAME = OCLforUMLPackage.Literals.COLLECTION__IS_NULL_FREE.getName();
    protected static final @NonNull String OCLforUML_COLLECTIONS = "OCLforUML::" + OCLforUMLPackage.Literals.COLLECTIONS.getName();
    protected static final @NonNull String OCLforUML_COLLECTIONS_IS_NULL_FREE_NAME = OCLforUMLPackage.Literals.COLLECTIONS__IS_NULL_FREE.getName();
    public static final @NonNull String STEREOTYPE_BASE_PREFIX = "base_";
    public static final @NonNull String STEREOTYPE_EXTENSION_PREFIX = "extension_";
    private static final Logger logger = Logger.getLogger(UML2AS.class);
    protected final @NonNull Resource umlResource;
    protected Model pivotModel = null;
    private URI umlURI = null;
    private final @NonNull Map<@NonNull AssociationClass, @NonNull AssociationClassProperties> association2properties = new HashMap<AssociationClass, AssociationClassProperties>();

    public static @NonNull UML2AS getAdapter(@NonNull Resource resource, @NonNull EnvironmentFactoryInternal environmentFactory) {
        UMLStandaloneSetup.assertInitialized();
        UML2AS adapter = (UML2AS)UML2AS.findAdapter((Resource)resource, (EnvironmentFactoryInternal)environmentFactory);
        if (adapter == null) {
            adapter = new Outer(resource, environmentFactory);
        }
        return adapter;
    }

    public static @Nullable String getBody(@NonNull OpaqueExpression opaqueExpression) {
        EList bodies = opaqueExpression.getBodies();
        EList languages = opaqueExpression.getLanguages();
        int bodiesSize = bodies.size();
        int languagesSize = languages.size();
        int i = 0;
        while (i < languagesSize) {
            if ("OCL".equals(languages.get(i))) break;
            ++i;
        }
        if (i < bodiesSize) {
            return (String)bodies.get(i);
        }
        return null;
    }

    public static Model importFromUML(@NonNull EnvironmentFactoryInternal environmentFactory, String alias, Resource umlResource) throws ParserException {
        if (umlResource == null) {
            return null;
        }
        UML2AS conversion = UML2AS.getAdapter(umlResource, environmentFactory);
        return conversion.getASModel();
    }

    public static Element importFromUML(@NonNull EnvironmentFactoryInternal environmentFactory, String alias, EObject eObject) throws ParserException {
        if (eObject == null) {
            return null;
        }
        Resource umlResource = eObject.eResource();
        if (umlResource == null) {
            return null;
        }
        UML2AS conversion = UML2AS.getAdapter(umlResource, environmentFactory);
        Model pivotModel = conversion.getASModel();
        return conversion.getCreated(Element.class, eObject);
    }

    public static void initialize() {
        IdManager.addMetamodelEPackage((String)((String)ClassUtil.nonNullEMF((Object)"http://www.eclipse.org/uml2/5.0.0/UML")), (String)"$uml$");
        IdManager.addMetamodelEPackage((String)((String)ClassUtil.nonNullEMF((Object)"http://www.eclipse.org/uml2/5.0.0/Types")), (String)"$types$");
    }

    public static String initialize(@NonNull ResourceSet resourceSet) {
        UMLStandaloneSetup.init();
        UMLResourcesUtil.init((ResourceSet)resourceSet);
        String resourcesPluginId = "org.eclipse.uml2.uml.resources";
        String resourcesLocation = null;
        StandaloneProjectMap projectMap = StandaloneProjectMap.getAdapter((ResourceSet)resourceSet);
        URI locationURI = projectMap.getLocation("org.eclipse.uml2.uml.resources");
        if (locationURI != null) {
            resourcesLocation = locationURI.toString();
            while (resourcesLocation.endsWith("/")) {
                resourcesLocation = resourcesLocation.substring(0, resourcesLocation.length() - 1);
            }
        }
        if (resourcesLocation == null) {
            return "'org.eclipse.uml2.uml.resources' not found on class-path";
        }
        Map uriMap = resourceSet.getURIConverter().getURIMap();
        uriMap.put(URI.createURI((String)"pathmap://UML_PROFILES/"), URI.createURI((String)(String.valueOf(resourcesLocation) + "/profiles/")));
        uriMap.put(URI.createURI((String)"pathmap://UML_METAMODELS/"), URI.createURI((String)(String.valueOf(resourcesLocation) + "/metamodels/")));
        uriMap.put(URI.createURI((String)"pathmap://UML_LIBRARIES/"), URI.createURI((String)(String.valueOf(resourcesLocation) + "/libraries/")));
        return null;
    }

    public static String initialize(@NonNull StandaloneProjectMap projectMap) {
        UMLStandaloneSetup.init();
        UMLResourcesUtil.init(null);
        String resourcesPluginId = "org.eclipse.uml2.uml.resources";
        String resourcesLocation = null;
        URI locationURI = projectMap.getLocation("org.eclipse.uml2.uml.resources");
        if (locationURI != null) {
            resourcesLocation = locationURI.toString();
            while (resourcesLocation.endsWith("/")) {
                resourcesLocation = resourcesLocation.substring(0, resourcesLocation.length() - 1);
            }
        }
        if (resourcesLocation == null) {
            return "'org.eclipse.uml2.uml.resources' not found on class-path";
        }
        Map uriMap = URIConverter.URI_MAP;
        uriMap.put(URI.createURI((String)"pathmap://UML_PROFILES/"), URI.createURI((String)(String.valueOf(resourcesLocation) + "/profiles/")));
        uriMap.put(URI.createURI((String)"pathmap://UML_METAMODELS/"), URI.createURI((String)(String.valueOf(resourcesLocation) + "/metamodels/")));
        uriMap.put(URI.createURI((String)"pathmap://UML_LIBRARIES/"), URI.createURI((String)(String.valueOf(resourcesLocation) + "/libraries/")));
        return null;
    }

    public static boolean isUML(@NonNull Resource resource) {
        EList contents = resource.getContents();
        for (EObject content : contents) {
            if (!(content instanceof org.eclipse.uml2.uml.Package)) continue;
            return true;
        }
        return false;
    }

    public static UML2AS loadFromUML(@NonNull ASResource umlASResource, @NonNull URI umlURI) {
        EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.getEnvironmentFactory((Resource)umlASResource);
        Resource umlResource = environmentFactory.getResourceSet().getResource(umlURI, true);
        if (umlResource == null) {
            return null;
        }
        UML2AS conversion = UML2AS.getAdapter(umlResource, environmentFactory);
        try {
            conversion.getASModel();
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return conversion;
    }

    protected UML2AS(@NonNull Resource umlResource, @NonNull EnvironmentFactoryInternal environmentFactory) {
        super(environmentFactory);
        if (CONVERT_RESOURCE.isActive()) {
            CONVERT_RESOURCE.println(umlResource.getURI().toString());
        }
        this.umlResource = umlResource;
        environmentFactory.addExternal2AS((External2AS)this);
        CompleteModelInternal completeModel = environmentFactory.getCompleteModel();
        completeModel.addPackageURI2completeURI((String)ClassUtil.nonNullEMF((Object)"http://www.eclipse.org/uml2/5.0.0/UML"), "$uml$");
        completeModel.addPackageURI2completeURI((String)ClassUtil.nonNullEMF((Object)"http://www.eclipse.org/uml2/5.0.0/Types"), "$types$");
    }

    void addAssociationClassProperties(@NonNull AssociationClass asAssociationClass, @NonNull AssociationClassProperties asProperties) {
        this.association2properties.put(asAssociationClass, asProperties);
    }

    public abstract void addCreated(@NonNull EObject var1, @NonNull Element var2);

    public void addImportedPackage(@NonNull org.eclipse.uml2.uml.Package importedPackage) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)importedPackage);
        Resource importedResource = (Resource)ClassUtil.nonNullEMF((Object)rootContainer.eResource());
        this.addImportedResource(importedResource);
    }

    public void addImportedPackages(@NonNull List<? extends org.eclipse.uml2.uml.Package> importedPackages) {
        for (org.eclipse.uml2.uml.Package package_ : importedPackages) {
            if (package_ == null) continue;
            this.addImportedPackage(package_);
        }
    }

    public abstract void addImportedResource(@NonNull Resource var1);

    public abstract void addProfileApplication(@NonNull ProfileApplication var1);

    public abstract void addProperty(@NonNull Class var1, @NonNull Property var2);

    public abstract void addStereotype(@NonNull Stereotype var1);

    public abstract void addStereotypeApplication(@NonNull EObject var1);

    public abstract void addTypeExtension(@NonNull StereotypeExtender var1);

    protected Model basicGetPivotModel() {
        return this.pivotModel;
    }

    public void copyModelElement(@NonNull Element pivotElement, @NonNull org.eclipse.uml2.uml.Element umlElement) {
        this.setOriginalMapping(pivotElement, (EObject)umlElement);
    }

    public void copyNamedElement(@NonNull NamedElement pivotElement, @NonNull org.eclipse.uml2.uml.NamedElement umlNamedElement) {
        this.copyModelElement((Element)pivotElement, (org.eclipse.uml2.uml.Element)umlNamedElement);
        String name = umlNamedElement.getName();
        pivotElement.setName(name);
    }

    protected @NonNull URI createPivotURI() {
        URI uri = this.umlResource.getURI();
        if (uri == null) {
            throw new IllegalStateException("Missing resource URI");
        }
        return PivotUtilInternal.getASURI((URI)uri);
    }

    public abstract void error(@NonNull String var1);

    public abstract @Nullable Type getASType(@NonNull EObject var1);

    @Nullable AssociationClassProperties getAssociationClassProperties(@NonNull AssociationClass asAssociationClass) {
        return this.association2properties.get(asAssociationClass);
    }

    public abstract @NonNull UML2ASDeclarationSwitch getDeclarationPass();

    public @NonNull Resource getResource() {
        return this.umlResource;
    }

    public abstract @NonNull Outer getRoot();

    @NonNull List<@NonNull org.eclipse.uml2.uml.Property> getSafeMemberEnds(@NonNull Association umlAssociation) {
        ArrayList<@NonNull org.eclipse.uml2.uml.Property> safeMemberEnds = new ArrayList<org.eclipse.uml2.uml.Property>();
        for (org.eclipse.uml2.uml.Property umlProperty : umlAssociation.getMemberEnds()) {
            if (umlProperty == null) continue;
            String name = umlProperty.getName();
            boolean isSafe = true;
            for (org.eclipse.uml2.uml.Property umlSafeProperty : safeMemberEnds) {
                if (!ClassUtil.safeEquals((Object)name, (Object)umlSafeProperty.getName())) continue;
                isSafe = false;
                break;
            }
            if (!isSafe) continue;
            safeMemberEnds.add(umlProperty);
        }
        return safeMemberEnds;
    }

    public @NonNull URI getURI() {
        return (URI)ClassUtil.nonNullState((Object)this.umlResource.getURI());
    }

    protected @NonNull Model installDeclarations(@NonNull Resource asResource) {
        URI pivotURI = asResource.getURI();
        Model pivotModel2 = this.pivotModel = PivotUtil.createModel((String)(this.umlURI != null ? this.umlURI.toString() : pivotURI.toString()));
        asResource.getContents().add((Object)pivotModel2);
        UML2ASDeclarationSwitch declarationPass = this.getDeclarationPass();
        ArrayList<Package> rootPackages = new ArrayList<Package>();
        for (EObject eObject : this.umlResource.getContents()) {
            Object pivotElement = declarationPass.doSwitch(eObject);
            if (pivotElement instanceof Package) {
                rootPackages.add((Package)pivotElement);
                continue;
            }
            if (pivotElement == null) continue;
            this.error("Bad UML content : " + eObject.eClass().getName());
        }
        PivotUtilInternal.refreshList((List)pivotModel2.getOwnedPackages(), rootPackages);
        return pivotModel2;
    }

    protected boolean isPivot(@NonNull Collection<EObject> umlContents) {
        if (umlContents.size() != 1) {
            return false;
        }
        EObject umlRoot = umlContents.iterator().next();
        if (!(umlRoot instanceof EPackage)) {
            return false;
        }
        EPackage umlPackage = (EPackage)umlRoot;
        if (umlPackage.getEClassifier(PivotPackage.Literals.ENUMERATION_LITERAL.getName()) == null) {
            return false;
        }
        if (umlPackage.getEClassifier(PivotPackage.Literals.EXPRESSION_IN_OCL.getName()) == null) {
            return false;
        }
        if (umlPackage.getEClassifier(PivotPackage.Literals.OPERATION_CALL_EXP.getName()) == null) {
            return false;
        }
        return umlPackage.getEClassifier(PivotPackage.Literals.TEMPLATE_PARAMETER_SUBSTITUTION.getName()) != null;
    }

    public abstract void queueUse(@NonNull EObject var1);

    protected <T extends Element> @NonNull T refreshElement(@NonNull java.lang.Class<T> pivotClass, EClass pivotEClass, @NonNull EObject umlElement) {
        assert (pivotEClass != null);
        EFactory eFactoryInstance = pivotEClass.getEPackage().getEFactoryInstance();
        EObject pivotElement = eFactoryInstance.create(pivotEClass);
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException();
        }
        Element castElement = (Element)pivotElement;
        return (T)castElement;
    }

    protected <T extends NamedElement> @NonNull T refreshNamedElement(@NonNull java.lang.Class<T> pivotClass, EClass pivotEClass, @NonNull org.eclipse.uml2.uml.NamedElement umlNamedElement) {
        assert (pivotEClass != null);
        EFactory eFactoryInstance = pivotEClass.getEPackage().getEFactoryInstance();
        EObject pivotElement = eFactoryInstance.create(pivotEClass);
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException();
        }
        NamedElement castElement = (NamedElement)pivotElement;
        castElement.setName(umlNamedElement.getName());
        return (T)castElement;
    }

    public ExpressionInOCL refreshOpaqueExpression(@NonNull OpaqueExpression umlExpression) {
        ExpressionInOCL pivotElement = this.refreshNamedElement(ExpressionInOCL.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (org.eclipse.uml2.uml.NamedElement)umlExpression);
        pivotElement.setBody(null);
        EList umlBodies = umlExpression.getBodies();
        EList umlLanguages = umlExpression.getLanguages();
        int i = 0;
        while (i < umlBodies.size()) {
            String umlBody;
            String umlLanguage;
            String asLanguage = "OCL";
            if (i < umlLanguages.size() && (umlLanguage = (String)umlLanguages.get(i)) != null && umlLanguage.length() > 0) {
                asLanguage = umlLanguage;
            }
            if ((umlBody = (String)umlBodies.get(i)) != null && asLanguage.equals("OCL")) {
                Operation umlOperation;
                EObject eContainerContainer;
                EObject eContainer = umlExpression.eContainer();
                if (eContainer instanceof Constraint && (eContainerContainer = eContainer.eContainer()) instanceof Operation && (umlOperation = (Operation)eContainerContainer).getBodyCondition() == eContainer) {
                    umlBody = PivotUtilInternal.getBodyExpression((String)umlBody);
                }
                pivotElement.setBody(umlBody);
                break;
            }
            ++i;
        }
        this.copyNamedElement((NamedElement)pivotElement, (org.eclipse.uml2.uml.NamedElement)umlExpression);
        return pivotElement;
    }

    public abstract void resolveMultiplicity(@NonNull TypedElement var1, @NonNull org.eclipse.uml2.uml.TypedElement var2);

    public @Nullable Stereotype resolveStereotype(@NonNull EObject umlStereotypeApplication, @NonNull List<org.eclipse.uml2.uml.Element> umlStereotypedElements) {
        ClassUtil.nonNullState((Object)this.pivotModel);
        EClass umlStereotypeEClass = umlStereotypeApplication.eClass();
        if (!(umlStereotypeApplication instanceof DynamicEObjectImpl)) {
            Stereotype asStereotype = (Stereotype)this.metamodelManager.getASOfEcore(Stereotype.class, (EObject)umlStereotypeEClass);
            return asStereotype;
        }
        org.eclipse.uml2.uml.Package umlStereotypedPackage = null;
        Iterator<org.eclipse.uml2.uml.Element> iterator = umlStereotypedElements.iterator();
        block0: while (iterator.hasNext()) {
            org.eclipse.uml2.uml.Element umlStereotypedElement;
            org.eclipse.uml2.uml.Element eObject = umlStereotypedElement = iterator.next();
            while (eObject != null) {
                if (eObject instanceof org.eclipse.uml2.uml.Package) {
                    if (umlStereotypedPackage == null) {
                        umlStereotypedPackage = (org.eclipse.uml2.uml.Package)eObject;
                        continue block0;
                    }
                    if (umlStereotypedPackage == (org.eclipse.uml2.uml.Package)eObject) continue block0;
                    logger.error((Object)("Conflicting packages for stereotype application of " + umlStereotypeEClass.getName()));
                    continue block0;
                }
                eObject = eObject.eContainer();
            }
        }
        EPackage umlProfileEPackage = umlStereotypeEClass.getEPackage();
        if (umlStereotypedPackage != null) {
            String profileNsURI = umlProfileEPackage.getNsURI();
            org.eclipse.uml2.uml.Package umlPackage = umlStereotypedPackage;
            while (umlPackage != null) {
                for (org.eclipse.uml2.uml.ProfileApplication umlProfileApplication : umlPackage.getProfileApplications()) {
                    Profile umlProfile = umlProfileApplication.getAppliedProfile();
                    if (!profileNsURI.equals(umlProfile.getURI())) continue;
                    org.eclipse.uml2.uml.Stereotype umlStereotype = umlProfile.getOwnedStereotype(umlStereotypeEClass.getName());
                    return umlStereotype != null ? (Stereotype)this.getCreated(Stereotype.class, (EObject)umlStereotype) : null;
                }
                umlPackage = umlPackage.getNestingPackage();
            }
            String profileName = umlProfileEPackage.getName();
            org.eclipse.uml2.uml.Package umlPackage2 = umlStereotypedPackage;
            while (umlPackage2 != null) {
                for (org.eclipse.uml2.uml.ProfileApplication umlProfileApplication : umlPackage2.getProfileApplications()) {
                    Profile umlProfile = umlProfileApplication.getAppliedProfile();
                    if (!profileName.equals(umlProfile.getName())) continue;
                    org.eclipse.uml2.uml.Stereotype umlStereotype = umlProfile.getOwnedStereotype(umlStereotypeEClass.getName());
                    return umlStereotype != null ? (Stereotype)this.getCreated(Stereotype.class, (EObject)umlStereotype) : null;
                }
                umlPackage2 = umlPackage2.getNestingPackage();
            }
        }
        logger.error((Object)("Missing package for stereotype application of " + umlStereotypeEClass.getName()));
        return null;
    }

    protected @Nullable Type resolveType(@NonNull org.eclipse.uml2.uml.Type umlType) {
        Type pivotType = (Type)this.getCreated(Type.class, (EObject)umlType);
        if (pivotType != null) {
            return pivotType;
        }
        if (umlType instanceof PrimitiveType) {
            if (UMLUtil.isBoolean((org.eclipse.uml2.uml.Type)umlType)) {
                return this.standardLibrary.getBooleanType();
            }
            if (UMLUtil.isInteger((org.eclipse.uml2.uml.Type)umlType)) {
                return this.standardLibrary.getIntegerType();
            }
            if (UMLUtil.isReal((org.eclipse.uml2.uml.Type)umlType)) {
                return this.standardLibrary.getRealType();
            }
            if (UMLUtil.isString((org.eclipse.uml2.uml.Type)umlType)) {
                return this.standardLibrary.getStringType();
            }
            if (UMLUtil.isUnlimitedNatural((org.eclipse.uml2.uml.Type)umlType)) {
                return this.standardLibrary.getUnlimitedNaturalType();
            }
        }
        return pivotType;
    }

    protected @Nullable Type resolveTypeParameter(@NonNull EGenericType eGenericType) {
        EClassifier eClassifier = eGenericType.getEClassifier();
        ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
        if (eTypeParameter != null) {
            EList eTypeArguments = eGenericType.getETypeArguments();
            assert (eClassifier == null);
            assert (eTypeArguments.isEmpty());
            Type pivotType = (Type)this.getCreated(Type.class, (EObject)eTypeParameter);
            return pivotType;
        }
        return null;
    }

    protected @Nullable Type resolveWildcardType(@NonNull EGenericType eGenericType) {
        EObject eContainer;
        List list;
        int index;
        assert (eGenericType.getETypeArguments().isEmpty());
        assert (eGenericType.getEClassifier() == null);
        EClassifier eClassifier = eGenericType.getERawType();
        assert (eClassifier == EcorePackage.Literals.EJAVA_OBJECT);
        Class pivotElement = PivotFactory.eINSTANCE.createClass();
        String name = "wildcard";
        EReference eFeature = eGenericType.eContainmentFeature();
        if (eFeature != null && eFeature.isMany() && (index = (list = (List)(eContainer = eGenericType.eContainer()).eGet(eGenericType.eContainingFeature())).indexOf(eGenericType)) != 0) {
            name = String.valueOf(name) + index;
        }
        pivotElement.setName(name);
        return pivotElement;
    }

    protected void setOriginalMapping(@NonNull Element pivotElement, @NonNull EObject umlElement) {
        ((PivotObjectImpl)pivotElement).setESObject(umlElement);
        this.addCreated(umlElement, pivotElement);
    }

    public void setUMLURI(URI umlURI) {
        this.umlURI = umlURI;
    }

    public String toString() {
        return String.valueOf(this.umlResource.getURI());
    }

    public static class Inner
    extends UML2AS {
        protected final @NonNull Outer root;

        protected Inner(@NonNull Resource umlResource, @NonNull Outer root) {
            super(umlResource, root.getEnvironmentFactory());
            this.root = root;
        }

        @Override
        public void addCreated(@NonNull EObject umlElement, @NonNull Element pivotElement) {
            this.root.addCreated(umlElement, pivotElement);
        }

        public void addGenericType(@NonNull EGenericType eObject) {
            this.root.addGenericType(eObject);
        }

        @Override
        public void addImportedResource(@NonNull Resource importedResource) {
            this.root.addImportedResource(importedResource);
        }

        public void addMapping(@NonNull EObject eObject, @NonNull Element pivotElement) {
            this.root.addMapping(eObject, pivotElement);
        }

        @Override
        public void addProfileApplication(@NonNull ProfileApplication asProfileApplication) {
            this.root.addProfileApplication(asProfileApplication);
        }

        @Override
        public void addProperty(@NonNull Class asType, @NonNull Property asProperty) {
            this.root.addProperty(asType, asProperty);
        }

        @Override
        public void addStereotype(@NonNull Stereotype asStereotype) {
            this.root.addStereotype(asStereotype);
        }

        @Override
        public void addStereotypeApplication(@NonNull EObject stereotypeApplication) {
            this.root.addStereotypeApplication(stereotypeApplication);
        }

        @Override
        public void addTypeExtension(@NonNull StereotypeExtender asTypeExtension) {
            this.root.addTypeExtension(asTypeExtension);
        }

        @Override
        public void error(@NonNull String message) {
            this.root.error(message);
        }

        public @NonNull Model getASModel() throws ParserException {
            Model pivotModel2 = this.pivotModel;
            if (pivotModel2 == null) {
                pivotModel2 = this.root.getASModel();
                Resource asResource = this.pivotModel.eResource();
                if (asResource == null) {
                    throw new IllegalStateException("Missing containing resource");
                }
                this.metamodelManager.installResource(asResource);
            }
            return pivotModel2;
        }

        @Override
        public @Nullable Type getASType(@NonNull EObject eObject) {
            return this.root.getASType(eObject);
        }

        public <T extends Element> @Nullable T getCreated(@NonNull java.lang.Class<T> requiredClass, @NonNull EObject eObject) {
            return this.root.getCreated(requiredClass, eObject);
        }

        public @Nullable Map<@NonNull EObject, @NonNull Element> getCreatedMap() {
            return this.root.getCreatedMap();
        }

        @Override
        public @NonNull UML2ASDeclarationSwitch getDeclarationPass() {
            return this.root.getDeclarationPass();
        }

        @Override
        public @NonNull Outer getRoot() {
            return this.root;
        }

        public void queueReference(@NonNull EObject umlElement) {
            this.root.queueReference(umlElement);
        }

        @Override
        public void queueUse(@NonNull EObject umlElement) {
            this.root.queueUse(umlElement);
        }

        @Override
        public void resolveMultiplicity(@NonNull TypedElement pivotElement, @NonNull org.eclipse.uml2.uml.TypedElement umlTypedElement) {
            this.root.resolveMultiplicity(pivotElement, umlTypedElement);
        }
    }

    public static class Outer
    extends UML2AS {
        private @NonNull Map<@NonNull EObject, @NonNull Element> createMap = new HashMap<EObject, Element>();
        private @NonNull Set<EObject> referencers = new HashSet<EObject>();
        private @NonNull Set<EObject> users = new HashSet<EObject>();
        private @NonNull Set<UML2AS> allConverters = new HashSet<UML2AS>();
        private List<Resource.Diagnostic> errors = null;
        protected final @NonNull ProfileAnalysis profileAnalysis = new ProfileAnalysis(this);
        protected final @NonNull ModelAnalysis modelAnalysis = new ModelAnalysis(this, this.profileAnalysis);
        protected final @NonNull UML2ASDeclarationSwitch declarationPass = new UML2ASDeclarationSwitch(this);
        protected final @NonNull UML2ASReferenceSwitch referencePass = new UML2ASReferenceSwitch(this);
        protected final @NonNull UML2ASUseSwitch usePass = new UML2ASUseSwitch(this);
        private @Nullable List<Resource> importedResources = null;
        private @NonNull Map<Class, List<Property>> type2properties = new HashMap<Class, List<Property>>();
        private final @NonNull Map<org.eclipse.uml2.uml.NamedElement, Boolean> namedElement2isNullFree = new HashMap<org.eclipse.uml2.uml.NamedElement, Boolean>();

        protected Outer(@NonNull Resource umlResource, @NonNull EnvironmentFactoryInternal environmentFactory) {
            super(umlResource, environmentFactory);
        }

        @Override
        public void addCreated(@NonNull EObject eObject, @NonNull Element pivotElement) {
            Element oldElement = this.createMap.put(eObject, pivotElement);
        }

        public void addGenericType(@NonNull EGenericType eObject) {
        }

        @Override
        public void addImportedResource(@NonNull Resource importedResource) {
            if (importedResource != this.umlResource) {
                List<Resource> importedResources2 = this.importedResources;
                if (importedResources2 == null) {
                    this.importedResources = importedResources2 = new ArrayList<Resource>();
                }
                if (!importedResources2.contains(importedResource)) {
                    URI uri = importedResource.getURI();
                    if (ADD_IMPORTED_RESOURCE.isActive()) {
                        ADD_IMPORTED_RESOURCE.println(String.valueOf(uri));
                    }
                    importedResources2.add(importedResource);
                }
            }
        }

        public void addMapping(@NonNull EObject eObject, @NonNull Element pivotElement) {
            if (pivotElement instanceof PivotObjectImpl) {
                ((PivotObjectImpl)pivotElement).setESObject(eObject);
            }
            this.addCreated(eObject, pivotElement);
        }

        @Override
        public void addProfileApplication(@NonNull ProfileApplication asProfileApplication) {
            this.modelAnalysis.addProfileApplication(asProfileApplication);
        }

        @Override
        public void addProperty(@NonNull Class asType, @NonNull Property asProperty) {
            List<Property> asProperties = this.type2properties.get(asType);
            if (asProperties == null) {
                asProperties = new ArrayList<Property>();
                this.type2properties.put(asType, asProperties);
            }
            asProperties.add(asProperty);
        }

        @Override
        public void addStereotype(@NonNull Stereotype asStereotype) {
            this.profileAnalysis.addStereotype(asStereotype);
        }

        @Override
        public void addStereotypeApplication(@NonNull EObject stereotypeApplication) {
            this.modelAnalysis.addStereotypeApplication(stereotypeApplication);
        }

        @Override
        public void addTypeExtension(@NonNull StereotypeExtender asTypeExtension) {
            this.profileAnalysis.addTypeExtension(asTypeExtension);
        }

        @Override
        public void error(@NonNull String message) {
            if (this.errors == null) {
                this.errors = new ArrayList<Resource.Diagnostic>();
            }
            this.errors.add((Resource.Diagnostic)new XMIException(message));
        }

        public @NonNull Model getASModel() throws ParserException {
            Model pivotModel2 = this.pivotModel;
            if (pivotModel2 == null) {
                URI pivotURI = this.createPivotURI();
                ASResource asResource = this.metamodelManager.getResource(pivotURI, "org.eclipse.ocl.oclas.uml");
                try {
                    pivotModel2 = this.installDeclarations((Resource)asResource);
                    this.installImports();
                    this.installReferencers();
                    this.modelAnalysis.installStereotypes();
                    this.installProperties();
                    this.installUsers();
                }
                catch (Exception e) {
                    throw new ParserException((Throwable)e, "Failed to load '" + pivotURI + "' : " + e.getMessage());
                }
                if (this.errors != null) {
                    asResource.getErrors().addAll(this.errors);
                }
                this.installAliases((Resource)asResource);
                this.metamodelManager.installResource((Resource)asResource);
                ResourceSet resourceSet = this.umlResource.getResourceSet();
                if (resourceSet != null) {
                    this.environmentFactory.addExternalResources(resourceSet);
                }
            }
            return pivotModel2;
        }

        @Override
        public Type getASType(@NonNull EObject eObject) {
            Element pivotElement = this.createMap.get(eObject);
            if (pivotElement == null) {
                UML2AS converter;
                Resource resource = eObject.eResource();
                if (resource != this.umlResource && resource != null && this.allConverters.add(converter = Outer.getAdapter(resource, this.environmentFactory))) {
                    try {
                        converter.getASModel();
                    }
                    catch (ParserException e) {
                        @NonNull String message = e.getMessage();
                        this.error(message);
                    }
                }
                pivotElement = this.createMap.get(eObject);
            }
            if (pivotElement == null) {
                this.error("Unresolved " + eObject);
            } else if (!(pivotElement instanceof Type)) {
                this.error("Incompatible " + eObject);
            } else {
                return (Type)pivotElement;
            }
            return null;
        }

        public <T extends Element> @Nullable T getCreated(@NonNull java.lang.Class<T> requiredClass, @NonNull EObject eObject) {
            Element element = this.createMap.get(eObject);
            if (element == null) {
                Resource resource = eObject.eResource();
                if (resource == this.umlResource) {
                    return null;
                }
                List<Resource> importedResources2 = this.importedResources;
                if (importedResources2 != null && importedResources2.contains(resource)) {
                    return null;
                }
                try {
                    return (T)this.metamodelManager.getASOf(requiredClass, eObject);
                }
                catch (ParserException e) {
                    return null;
                }
            }
            if (!requiredClass.isAssignableFrom(element.getClass())) {
                logger.error((Object)("UML " + element.getClass().getName() + "' element is not a '" + requiredClass.getName() + "'"));
                return null;
            }
            Element castElement = element;
            return (T)castElement;
        }

        public @Nullable Map<@NonNull EObject, @NonNull Element> getCreatedMap() {
            return this.createMap;
        }

        @Override
        public final @NonNull UML2ASDeclarationSwitch getDeclarationPass() {
            return this.declarationPass;
        }

        public @Nullable List<Resource> getImportedResources() {
            return this.importedResources;
        }

        @Override
        public @NonNull Outer getRoot() {
            return this;
        }

        protected void installAliases(@NonNull Resource asResource) {
            AliasAdapter umlAdapter = AliasAdapter.findAdapter((Resource)this.umlResource);
            if (umlAdapter != null) {
                Map umlAliasMap = umlAdapter.getAliasMap();
                AliasAdapter pivotAdapter = AliasAdapter.getAdapter((Resource)asResource);
                Map pivotAliasMap = pivotAdapter.getAliasMap();
                for (EObject eObject : umlAliasMap.keySet()) {
                    String alias = (String)umlAliasMap.get(eObject);
                    Element element = this.createMap.get(eObject);
                    pivotAliasMap.put(element, alias);
                }
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        protected void installImports() throws ParserException {
            List<Resource> importedResources2 = this.importedResources;
            if (importedResources2 != null) {
                int i = 0;
                while (i < importedResources2.size()) {
                    Resource importedResource = importedResources2.get(i);
                    if (importedResource instanceof UMLResource) {
                        Object adapter = UML2AS.findAdapter((Resource)importedResource, (EnvironmentFactoryInternal)this.environmentFactory);
                        if (adapter == null) {
                            Inner importedAdapter = new Inner(importedResource, this);
                            URI pivotURI = importedAdapter.createPivotURI();
                            ASResource asResource = this.metamodelManager.getResource(pivotURI, "org.eclipse.ocl.oclas.uml");
                            importedAdapter.installDeclarations((Resource)asResource);
                            adapter = importedAdapter;
                            this.metamodelManager.installResource((Resource)asResource);
                        } else {
                            @NonNull @NonNull Map importedCreatedMap = adapter.getCreatedMap();
                            if (importedCreatedMap != null) {
                                this.createMap.putAll(importedCreatedMap);
                            }
                        }
                    } else if (importedResource != null) {
                        this.environmentFactory.loadResource(importedResource, null);
                    }
                    ++i;
                }
            }
        }

        protected void installProperties() {
            for (Class pivotType : this.type2properties.keySet()) {
                List<Property> asProperties = this.type2properties.get(pivotType);
                Collections.sort(asProperties, NameUtil.NAMEABLE_COMPARATOR);
                this.refreshList((List)ClassUtil.nonNullEMF((Object)pivotType.getOwnedProperties()), asProperties);
            }
        }

        protected void installReferencers() {
            for (EObject eObject : this.referencers) {
                this.referencePass.doSwitch(eObject);
            }
        }

        protected void installUsers() {
            for (EObject eObject : this.users) {
                this.usePass.doSwitch(eObject);
            }
        }

        public void queueReference(@NonNull EObject umlElement) {
            this.referencers.add(umlElement);
        }

        @Override
        public void queueUse(@NonNull EObject umlElement) {
            this.users.add(umlElement);
        }

        private @NonNull Boolean isNullFree(@Nullable EObject eObject) {
            if (eObject == null) {
                return ValueUtil.TRUE_VALUE;
            }
            if (eObject instanceof org.eclipse.uml2.uml.Class || eObject instanceof org.eclipse.uml2.uml.Package) {
                org.eclipse.uml2.uml.NamedElement umlElement = (org.eclipse.uml2.uml.NamedElement)eObject;
                Boolean isNullFree = this.namedElement2isNullFree.get(umlElement);
                if (isNullFree == null) {
                    Object value;
                    org.eclipse.uml2.uml.Stereotype umlStereotype = umlElement.getAppliedStereotype(OCLforUML_COLLECTIONS);
                    if (umlStereotype != null && (value = umlElement.getValue(umlStereotype, OCLforUML_COLLECTIONS_IS_NULL_FREE_NAME)) instanceof Boolean) {
                        isNullFree = (Boolean)value;
                    }
                    if (isNullFree == null) {
                        isNullFree = this.isNullFree(umlElement.eContainer());
                    }
                    this.namedElement2isNullFree.put(umlElement, isNullFree);
                }
                return isNullFree;
            }
            return this.isNullFree(eObject.eContainer());
        }

        @Override
        public void resolveMultiplicity(@NonNull TypedElement pivotElement, @NonNull org.eclipse.uml2.uml.TypedElement umlTypedElement) {
            boolean isRequired = false;
            org.eclipse.uml2.uml.Type umlType = umlTypedElement.getType();
            if (umlType != null) {
                Type pivotType = this.resolveType(umlType);
                if (umlTypedElement instanceof MultiplicityElement && pivotType != null) {
                    MultiplicityElement umlMultiplicity = (MultiplicityElement)umlTypedElement;
                    int lower = umlMultiplicity.getLower();
                    int upper = umlMultiplicity.getUpper();
                    if (upper == 1) {
                        isRequired = lower == 1;
                    } else {
                        Object value;
                        isRequired = true;
                        boolean isOrdered = umlMultiplicity.isOrdered();
                        boolean isUnique = umlMultiplicity.isUnique();
                        Boolean isNullFree = null;
                        org.eclipse.uml2.uml.Stereotype umlStereotype = umlMultiplicity.getAppliedStereotype(OCLforUML_COLLECTION);
                        if (umlStereotype != null && (value = umlMultiplicity.getValue(umlStereotype, OCLforUML_COLLECTION_IS_NULL_FREE_NAME)) instanceof Boolean) {
                            isNullFree = (Boolean)value;
                        }
                        if (isNullFree == null) {
                            isNullFree = this.isNullFree(umlMultiplicity.eContainer());
                        }
                        IntegerValue lowerValue = ValueUtil.integerValueOf((int)lower);
                        UnlimitedValue upperValue = upper == -1 ? ValueUtil.UNLIMITED_VALUE : ValueUtil.unlimitedNaturalValueOf((int)upper);
                        pivotType = this.environmentFactory.getMetamodelManager().getCollectionType(isOrdered, isUnique, pivotType, isNullFree == Boolean.TRUE, lowerValue, (UnlimitedNaturalValue)upperValue);
                    }
                }
                pivotElement.setType(pivotType);
            } else {
                pivotElement.setType((Type)this.standardLibrary.getOclVoidType());
            }
            pivotElement.setIsRequired(isRequired);
        }
    }
}

