/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.model.project;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.emf.mwe2.runtime.Mandatory;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.Issues;
import org.eclipse.xtext.xtext.generator.model.ManifestAccess;
import org.eclipse.xtext.xtext.generator.model.PluginXmlAccess;
import org.eclipse.xtext.xtext.generator.model.project.BundleProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.RuntimeProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.SubProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.WebProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.XtextProjectConfig;

@Accessors
public class StandardProjectConfig
extends XtextProjectConfig {
    private boolean mavenLayout;
    private boolean createEclipseMetaData;
    private String rootPath;
    private String baseName;

    @Mandatory
    public String setBaseName(String baseName) {
        this.baseName = baseName;
        return this.baseName;
    }

    @Mandatory
    public String setRootPath(String rootPath) {
        this.rootPath = rootPath;
        return this.rootPath;
    }

    @Override
    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (this.rootPath == null) {
            issues.addError("The property 'rootPath' must be set", this);
        }
        if (this.baseName == null) {
            issues.addError("The property 'baseName' must be set", this);
        }
    }

    @Override
    public void setDefaults() {
        super.setDefaults();
        List<? extends SubProjectConfig> _enabledProjects = this.getEnabledProjects();
        Procedures.Procedure1<SubProjectConfig> _function = new Procedures.Procedure1<SubProjectConfig>(){

            public void apply(SubProjectConfig it) {
                String _srcGenPath;
                boolean _tripleEquals_4;
                String _srcPath;
                boolean _tripleEquals_3;
                String _metaInfPath;
                boolean _tripleEquals_2;
                String _rootPath;
                boolean _tripleEquals_1;
                boolean _tripleEquals;
                String _name = it.getName();
                boolean bl = _tripleEquals = _name == null;
                if (_tripleEquals) {
                    String _computeName = StandardProjectConfig.this.computeName(it);
                    it.setName(_computeName);
                }
                boolean bl2 = _tripleEquals_1 = (_rootPath = it.getRootPath()) == null;
                if (_tripleEquals_1) {
                    String _computeRoot = StandardProjectConfig.this.computeRoot(it);
                    it.setRoot(_computeRoot);
                }
                boolean bl3 = _tripleEquals_2 = (_metaInfPath = it.getMetaInfPath()) == null;
                if (_tripleEquals_2) {
                    String _computeMetaInf = StandardProjectConfig.this.computeMetaInf(it);
                    it.setMetaInf(_computeMetaInf);
                }
                boolean bl4 = _tripleEquals_3 = (_srcPath = it.getSrcPath()) == null;
                if (_tripleEquals_3) {
                    String _computeSrc = StandardProjectConfig.this.computeSrc(it);
                    it.setSrc(_computeSrc);
                }
                boolean bl5 = _tripleEquals_4 = (_srcGenPath = it.getSrcGenPath()) == null;
                if (_tripleEquals_4) {
                    String _computeSrcGen = StandardProjectConfig.this.computeSrcGen(it);
                    it.setSrcGen(_computeSrcGen);
                }
                if (it instanceof BundleProjectConfig && StandardProjectConfig.this.createEclipseMetaData) {
                    PluginXmlAccess _pluginXml;
                    boolean _tripleEquals_6;
                    boolean _tripleEquals_5;
                    ManifestAccess _manifest = ((BundleProjectConfig)it).getManifest();
                    boolean bl6 = _tripleEquals_5 = _manifest == null;
                    if (_tripleEquals_5) {
                        ManifestAccess _newManifestAccess = StandardProjectConfig.this.newManifestAccess();
                        ((BundleProjectConfig)it).setManifest(_newManifestAccess);
                    }
                    boolean bl7 = _tripleEquals_6 = (_pluginXml = ((BundleProjectConfig)it).getPluginXml()) == null;
                    if (_tripleEquals_6) {
                        PluginXmlAccess _newPluginXmlAccess = StandardProjectConfig.this.newPluginXmlAccess();
                        ((BundleProjectConfig)it).setPluginXml(_newPluginXmlAccess);
                    }
                }
                if (it instanceof RuntimeProjectConfig) {
                    boolean _tripleEquals_7;
                    String _ecoreModelPath = ((RuntimeProjectConfig)it).getEcoreModelPath();
                    boolean bl8 = _tripleEquals_7 = _ecoreModelPath == null;
                    if (_tripleEquals_7) {
                        String _computeEcoreModel = StandardProjectConfig.this.computeEcoreModel((RuntimeProjectConfig)it);
                        ((RuntimeProjectConfig)it).setEcoreModel(_computeEcoreModel);
                    }
                }
                if (it instanceof WebProjectConfig) {
                    boolean _tripleEquals_8;
                    String _assetsPath = ((WebProjectConfig)it).getAssetsPath();
                    boolean bl9 = _tripleEquals_8 = _assetsPath == null;
                    if (_tripleEquals_8) {
                        String _computeAssets = StandardProjectConfig.this.computeAssets((WebProjectConfig)it);
                        ((WebProjectConfig)it).setAssets(_computeAssets);
                    }
                }
            }
        };
        IterableExtensions.forEach(_enabledProjects, (Procedures.Procedure1)_function);
    }

    protected String computeName(SubProjectConfig project) {
        WebProjectConfig _web;
        SubProjectConfig _ideaPlugin;
        BundleProjectConfig _eclipsePluginTest;
        BundleProjectConfig _eclipsePlugin;
        BundleProjectConfig _genericIde;
        BundleProjectConfig _runtimeTest;
        String _switchResult = null;
        boolean _matched = false;
        RuntimeProjectConfig _runtime = this.getRuntime();
        if (Objects.equal((Object)project, (Object)_runtime)) {
            _matched = true;
            _switchResult = this.baseName;
        }
        if (!_matched && Objects.equal((Object)project, (Object)(_runtimeTest = this.getRuntimeTest()))) {
            _matched = true;
            String _xifexpression = null;
            _xifexpression = !this.mavenLayout ? String.valueOf(this.baseName) + ".tests" : this.baseName;
            _switchResult = _xifexpression;
        }
        if (!_matched && Objects.equal((Object)project, (Object)(_genericIde = this.getGenericIde()))) {
            _matched = true;
            _switchResult = String.valueOf(this.baseName) + ".ide";
        }
        if (!_matched && Objects.equal((Object)project, (Object)(_eclipsePlugin = this.getEclipsePlugin()))) {
            _matched = true;
            _switchResult = String.valueOf(this.baseName) + ".ui";
        }
        if (!_matched && Objects.equal((Object)project, (Object)(_eclipsePluginTest = this.getEclipsePluginTest()))) {
            _matched = true;
            String _xifexpression_1 = null;
            _xifexpression_1 = !this.mavenLayout ? String.valueOf(this.baseName) + ".ui.tests" : String.valueOf(this.baseName) + ".ui";
            _switchResult = _xifexpression_1;
        }
        if (!_matched && Objects.equal((Object)project, (Object)(_ideaPlugin = this.getIdeaPlugin()))) {
            _matched = true;
            _switchResult = String.valueOf(this.baseName) + ".idea";
        }
        if (!_matched && Objects.equal((Object)project, (Object)(_web = this.getWeb()))) {
            _matched = true;
            _switchResult = String.valueOf(this.baseName) + ".web";
        }
        return _switchResult;
    }

    protected String computeRoot(SubProjectConfig project) {
        String _name = project.getName();
        return String.valueOf(this.rootPath) + "/" + _name;
    }

    protected String computeSrc(SubProjectConfig project) {
        String _rootPath = project.getRootPath();
        String _plus = String.valueOf(_rootPath) + "/";
        String _xifexpression = null;
        if (this.mavenLayout) {
            String _computeSourceSet = this.computeSourceSet(project);
            String _plus_1 = "src/" + _computeSourceSet;
            _xifexpression = String.valueOf(_plus_1) + "/java";
        } else {
            _xifexpression = "src";
        }
        return String.valueOf(_plus) + _xifexpression;
    }

    protected String computeSrcGen(SubProjectConfig project) {
        String _rootPath = project.getRootPath();
        String _plus = String.valueOf(_rootPath) + "/";
        String _xifexpression = null;
        if (this.mavenLayout) {
            String _computeSourceSet = this.computeSourceSet(project);
            String _plus_1 = "src/" + _computeSourceSet;
            _xifexpression = String.valueOf(_plus_1) + "/xtext-gen";
        } else {
            _xifexpression = "src-gen";
        }
        return String.valueOf(_plus) + _xifexpression;
    }

    protected String computeMetaInf(SubProjectConfig project) {
        String _rootPath = project.getRootPath();
        String _plus = String.valueOf(_rootPath) + "/";
        String _xifexpression = null;
        if (this.mavenLayout) {
            String _computeSourceSet = this.computeSourceSet(project);
            String _plus_1 = "src/" + _computeSourceSet;
            _xifexpression = String.valueOf(_plus_1) + "/resources/META-INF";
        } else {
            _xifexpression = "META-INF";
        }
        return String.valueOf(_plus) + _xifexpression;
    }

    protected String computeEcoreModel(RuntimeProjectConfig project) {
        String _rootPath = project.getRootPath();
        String _plus = String.valueOf(_rootPath) + "/";
        return String.valueOf(_plus) + "model/generated";
    }

    protected String computeAssets(WebProjectConfig project) {
        String _rootPath = project.getRootPath();
        String _plus = String.valueOf(_rootPath) + "/";
        String _xifexpression = null;
        if (this.mavenLayout) {
            String _computeSourceSet = this.computeSourceSet(project);
            String _plus_1 = "src/" + _computeSourceSet;
            _xifexpression = String.valueOf(_plus_1) + "/webapp";
        } else {
            _xifexpression = "WebRoot";
        }
        return String.valueOf(_plus) + _xifexpression;
    }

    protected String computeSourceSet(SubProjectConfig project) {
        String _xifexpression = null;
        List<? extends SubProjectConfig> _testProjects = this.getTestProjects();
        boolean _contains = _testProjects.contains(project);
        _xifexpression = _contains ? "test" : "main";
        return _xifexpression;
    }

    @Pure
    public boolean isMavenLayout() {
        return this.mavenLayout;
    }

    public void setMavenLayout(boolean mavenLayout) {
        this.mavenLayout = mavenLayout;
    }

    @Pure
    public boolean isCreateEclipseMetaData() {
        return this.createEclipseMetaData;
    }

    public void setCreateEclipseMetaData(boolean createEclipseMetaData) {
        this.createEclipseMetaData = createEclipseMetaData;
    }

    @Pure
    public String getRootPath() {
        return this.rootPath;
    }

    @Pure
    public String getBaseName() {
        return this.baseName;
    }
}

