/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.infra.properties.property;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DataTypeKind implements Enumerator
{
    ENUMERATION(0, "Enumeration", "Enumeration"),
    STRING(1, "String", "String"),
    INTEGER(2, "Integer", "Integer"),
    FLOAT(3, "Float", "Float");

    public static final int ENUMERATION_VALUE = 0;
    public static final int STRING_VALUE = 1;
    public static final int INTEGER_VALUE = 2;
    public static final int FLOAT_VALUE = 3;
    private static final DataTypeKind[] VALUES_ARRAY;
    public static final List<DataTypeKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DataTypeKind[]{ENUMERATION, STRING, INTEGER, FLOAT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DataTypeKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataTypeKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataTypeKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataTypeKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataTypeKind get(int value) {
        switch (value) {
            case 0: {
                return ENUMERATION;
            }
            case 1: {
                return STRING;
            }
            case 2: {
                return INTEGER;
            }
            case 3: {
                return FLOAT;
            }
        }
        return null;
    }

    private DataTypeKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

