/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.infra.mappings.mapping;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MapKind implements Enumerator
{
    FULL(0, "full", "full"),
    PARTIAL(1, "partial", "partial"),
    NO_MAP(2, "noMap", "noMap");

    public static final int FULL_VALUE = 0;
    public static final int PARTIAL_VALUE = 1;
    public static final int NO_MAP_VALUE = 2;
    private static final MapKind[] VALUES_ARRAY;
    public static final List<MapKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MapKind[]{FULL, PARTIAL, NO_MAP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MapKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MapKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MapKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MapKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MapKind get(int value) {
        switch (value) {
            case 0: {
                return FULL;
            }
            case 1: {
                return PARTIAL;
            }
            case 2: {
                return NO_MAP;
            }
        }
        return null;
    }

    private MapKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

