/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.common.sdk.core.internal.exported.utils;

import com.ibm.icu.lang.UCharacter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.papyrus.emf.facet.common.sdk.core.internal.Activator;
import org.eclipse.papyrus.emf.facet.common.sdk.core.internal.Messages;
import org.eclipse.papyrus.emf.facet.util.core.Logger;
import org.eclipse.papyrus.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.papyrus.emf.facet.util.core.internal.exported.FolderUtils;
import org.osgi.framework.Bundle;

public final class ProjectUtils {
    private static final String JAVA_VERSION = "J2SE-1.5";

    private ProjectUtils() {
    }

    public static void addPdeClassPath(IProject project) throws JavaModelException {
        IClasspathEntry[] oldClassPath;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] iClasspathEntryArray = oldClassPath = javaProject.getRawClasspath();
        int n = oldClassPath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            if (classpathEntry.getPath().equals((Object)new Path("org.eclipse.pde.core.requiredPlugins"))) {
                return;
            }
            ++n2;
        }
        IClasspathEntry[] newClassPath = new IClasspathEntry[oldClassPath.length + 1];
        System.arraycopy(oldClassPath, 0, newClassPath, 0, oldClassPath.length);
        newClassPath[oldClassPath.length] = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins"));
        javaProject.setRawClasspath(newClassPath, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void createManifest(IProject project) throws CoreException {
        IFile manifestFile;
        IFolder folder = project.getFolder("META-INF");
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!(manifestFile = folder.getFile("MANIFEST.MF")).exists()) {
            StringBuffer manifestSB = new StringBuffer();
            manifestSB.append("Manifest-Version: 1.0\n");
            manifestSB.append("Bundle-ManifestVersion: 2\n");
            manifestSB.append("Bundle-Name: " + project.getName() + "\n");
            String packageName = ProjectUtils.packageName(project.getName());
            manifestSB.append("Bundle-SymbolicName: " + packageName + ";singleton:=true\n");
            manifestSB.append("Bundle-Version: 0.0.1.qualifier\n");
            manifestSB.append("Bundle-Activator: " + ProjectUtils.bundleActivatorQualifiedName(packageName) + "\n");
            manifestSB.append("Require-Bundle: org.eclipse.core.runtime,\n");
            manifestSB.append(" org.eclipse.papyrus.emf.facet.util.core\n");
            manifestSB.append("Bundle-RequiredExecutionEnvironment: J2SE-1.5\n");
            manifestSB.append("Bundle-ActivationPolicy: lazy\n");
            manifestSB.append("Bundle-ClassPath: .,bin\n");
            ByteArrayInputStream source = new ByteArrayInputStream(manifestSB.toString().getBytes());
            manifestFile.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private static String bundleActivatorQualifiedName(String packageName) {
        return String.valueOf(packageName) + ".Activator";
    }

    private static void createActivator(IProject project) throws CoreException {
        String packageName = ProjectUtils.packageName(project.getName());
        String qualifiedName = ProjectUtils.bundleActivatorQualifiedName(packageName);
        String path = qualifiedName.replaceAll("\\.", "/");
        IFile activatorFile = project.getFile(new Path("src").append(path).addFileExtension("java"));
        FolderUtils.createFolder((IFolder)((IFolder)activatorFile.getParent()));
        if (!activatorFile.exists()) {
            try {
                String template = FileUtils.getFileContents((Bundle)Activator.getDefault().getBundle(), (String)"resources/Activator.java.template");
                String activatorContents = template.replace("{0}", packageName);
                ByteArrayInputStream source = new ByteArrayInputStream(activatorContents.getBytes());
                activatorFile.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException e) {
                Logger.logError((Throwable)e, (String)"Couldn't create Activator", (Plugin)Activator.getDefault());
            }
        }
    }

    public static String packageName(String name) {
        IStatus status;
        StringBuilder builder = new StringBuilder();
        int prev = 32;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') {
                builder.append(c);
                prev = c;
            } else if (c >= '0' && c <= '9') {
                if (builder.length() == 0 || prev == 46) {
                    builder.append("_");
                }
                builder.append(c);
                prev = c;
            } else if (c == '.') {
                if (prev != 46) {
                    if (builder.length() == 0 || prev >= 48 && prev <= 57) {
                        builder.append("_");
                    }
                    builder.append(c);
                    prev = c;
                }
            } else {
                builder.append("_");
            }
            ++i;
        }
        String result = builder.toString();
        if (result.length() > 0 && UCharacter.isUpperCase((int)result.charAt(0))) {
            result = String.valueOf(UCharacter.toLowerCase((int)result.charAt(0))) + result.substring(1);
        }
        if (!(status = JavaConventions.validatePackageName((String)result, (String)"1.5", (String)"1.5")).isOK()) {
            Logger.logWarning((String)("Couldn't make valid package name from project name: " + status.getMessage()), (Plugin)Activator.getDefault());
            return name;
        }
        return result;
    }

    public static void addPdeNature(IProject project) throws CoreException {
        String pluginNature = "org.eclipse.pde.PluginNature";
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        if (!Arrays.asList(natures).contains("org.eclipse.pde.PluginNature")) {
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = "org.eclipse.pde.PluginNature";
            description.setNatureIds(newNatures);
            project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void addPdeBuilder(IProject project) throws CoreException {
        ICommand[] oldBuildSpec;
        IProjectDescription projectDescription = project.getDescription();
        ICommand[] iCommandArray = oldBuildSpec = project.getDescription().getBuildSpec();
        int n = oldBuildSpec.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if ("org.eclipse.pde.ManifestBuilder".equals(command.getBuilderName())) {
                return;
            }
            ++n2;
        }
        ICommand[] newBuildSpec = new ICommand[oldBuildSpec.length + 2];
        System.arraycopy(oldBuildSpec, 0, newBuildSpec, 0, oldBuildSpec.length);
        ICommand command1 = project.getDescription().newCommand();
        command1.setBuilderName("org.eclipse.pde.ManifestBuilder");
        ICommand command2 = project.getDescription().newCommand();
        command2.setBuilderName("org.eclipse.pde.SchemaBuilder");
        newBuildSpec[oldBuildSpec.length] = command1;
        newBuildSpec[oldBuildSpec.length + 1] = command2;
        projectDescription.setBuildSpec(newBuildSpec);
        project.setDescription(projectDescription, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void configureAsJavaProject(IProject project, IProgressMonitor monitor) throws CoreException {
        IClasspathEntry[] existingClassPath;
        ProjectUtils.addNature(project, monitor, "org.eclipse.jdt.core.javanature");
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPath path = project.getFullPath().append("bin");
        javaProject.setOutputLocation(path, null);
        ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
        IFolder sourceFolder = project.getFolder("src");
        if (!sourceFolder.exists()) {
            sourceFolder.create(false, true, monitor);
            classpathEntries.add(JavaCore.newSourceEntry((IPath)javaProject.getPath().append((IPath)new Path("src"))));
        }
        Path jrePath = new Path(String.valueOf(JavaRuntime.JRE_CONTAINER) + "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/" + JAVA_VERSION);
        boolean hasJrePath = false;
        IClasspathEntry[] iClasspathEntryArray = existingClassPath = javaProject.getRawClasspath();
        int n = existingClassPath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            if (jrePath.equals((Object)classpathEntry.getPath())) {
                hasJrePath = true;
            }
            ++n2;
        }
        if (!hasJrePath) {
            classpathEntries.add(JavaCore.newContainerEntry((IPath)jrePath));
            javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[0]), monitor);
        }
    }

    public static void configureAsPluginProject(IProject project) throws CoreException {
        ProjectUtils.addPdeNature(project);
        ProjectUtils.addPdeClassPath(project);
        ProjectUtils.createManifest(project);
        ProjectUtils.createActivator(project);
    }

    public static void addNature(IProject project, IProgressMonitor monitor, String natureId) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        if (!Arrays.asList(natures).contains(natureId)) {
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 1, natures.length);
            newNatures[0] = natureId;
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
    }

    public static void createBuildProperties(IProject project) throws CoreException {
        IFile buildFile = project.getFile("build.properties");
        if (!buildFile.exists()) {
            StringBuffer buildSB = new StringBuffer();
            buildSB.append("source.. = src/\n");
            buildSB.append("output.. = bin/\n");
            buildSB.append("bin.includes = META-INF/,\\\n");
            buildSB.append("               .\n");
            ByteArrayInputStream source = new ByteArrayInputStream(buildSB.toString().getBytes());
            buildFile.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void createEmfFacetProject(IProject project, IPath projectLocation, IProgressMonitor monitor) throws CoreException {
        ProjectUtils.createPluginProject(project, projectLocation, monitor, false);
        ProjectUtils.addNature(project, monitor, "org.eclipse.papyrus.emf.facet.common.sdk.core.ProjectNature");
        monitor.done();
    }

    public static void createPluginProject(IProject project, IPath projectLocation, IProgressMonitor monitor, boolean monitorDone) throws CoreException {
        IProjectDescription description;
        monitor.beginTask(Messages.ProjectUtils_createPluginProject, -1);
        if (!project.exists()) {
            description = project.getWorkspace().newProjectDescription(project.getName());
            if (!Platform.getLocation().equals((Object)projectLocation)) {
                description.setLocation(projectLocation);
            }
        } else {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "The project already exists"));
        }
        project.create(description, monitor);
        project.open(monitor);
        ProjectUtils.configureAsJavaProject(project, monitor);
        ProjectUtils.configureAsPluginProject(project);
        ProjectUtils.createBuildProperties(project);
        if (monitorDone) {
            monitor.done();
        }
    }

    public static boolean isEmfFacetProject(IProject project) {
        block3: {
            try {
                if (project.isAccessible()) break block3;
                return false;
            }
            catch (CoreException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                return false;
            }
        }
        return project.getNature("org.eclipse.papyrus.emf.facet.common.sdk.core.ProjectNature") != null;
    }

    public static boolean isInEmfFacetProject(IPath path) {
        IProject project = ProjectUtils.getProject(path);
        return ProjectUtils.isEmfFacetProject(project);
    }

    public static IProject getProject(IPath path) {
        IProject project;
        if (path.segmentCount() == 1) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
        } else {
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
            project = folder.getProject();
        }
        return project;
    }
}

