/*******************************************************************************
 * Copyright (c) 2006, 2016 Soyatec (http://www.soyatec.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Soyatec - initial API and implementation
 *******************************************************************************/
package org.eclipse.pmf.pim.interactive.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.pmf.pim.interactive.util.InteractiveAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc --> <!--
 * end-user-doc -->
 * @generated
 */
public class InteractiveItemProviderAdapterFactory extends
		InteractiveAdapterFactory implements ComposeableAdapterFactory,
		IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement
	 * {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @generated
	 */
	public InteractiveItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.pmf.pim.interactive.TriggerAction} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TriggerActionItemProvider triggerActionItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.pmf.pim.interactive.TriggerAction}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createTriggerActionAdapter() {
		if (triggerActionItemProvider == null) {
			triggerActionItemProvider = new TriggerActionItemProvider(this);
		}

		return triggerActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.pmf.pim.interactive.DataPredicate} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected DataPredicateItemProvider dataPredicateItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.pmf.pim.interactive.DataPredicate}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDataPredicateAdapter() {
		if (dataPredicateItemProvider == null) {
			dataPredicateItemProvider = new DataPredicateItemProvider(this);
		}

		return dataPredicateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.pmf.pim.interactive.UIPredicate} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected UIPredicateItemProvider uiPredicateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.interactive.UIPredicate}.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUIPredicateAdapter() {
		if (uiPredicateItemProvider == null) {
			uiPredicateItemProvider = new UIPredicateItemProvider(this);
		}

		return uiPredicateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.interactive.ExpressionCondition} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ExpressionConditionItemProvider expressionConditionItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.pmf.pim.interactive.ExpressionCondition}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createExpressionConditionAdapter() {
		if (expressionConditionItemProvider == null) {
			expressionConditionItemProvider = new ExpressionConditionItemProvider(
					this);
		}

		return expressionConditionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.pmf.pim.interactive.SetAction} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected SetActionItemProvider setActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.interactive.SetAction}.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSetActionAdapter() {
		if (setActionItemProvider == null) {
			setActionItemProvider = new SetActionItemProvider(this);
		}

		return setActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.pmf.pim.interactive.Trigger} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TriggerItemProvider triggerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.interactive.Trigger}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTriggerAdapter() {
		if (triggerItemProvider == null) {
			triggerItemProvider = new TriggerItemProvider(this);
		}

		return triggerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.pmf.pim.interactive.PredicateTerm} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PredicateTermItemProvider predicateTermItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.pmf.pim.interactive.PredicateTerm}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPredicateTermAdapter() {
		if (predicateTermItemProvider == null) {
			predicateTermItemProvider = new PredicateTermItemProvider(this);
		}

		return predicateTermItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.interactive.ConditionTrigger} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConditionTriggerItemProvider conditionTriggerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.interactive.ConditionTrigger}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConditionTriggerAdapter() {
		if (conditionTriggerItemProvider == null) {
			conditionTriggerItemProvider = new ConditionTriggerItemProvider(
					this);
		}

		return conditionTriggerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.interactive.EventTrigger} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventTriggerItemProvider eventTriggerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.interactive.EventTrigger}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventTriggerAdapter() {
		if (eventTriggerItemProvider == null) {
			eventTriggerItemProvider = new EventTriggerItemProvider(this);
		}

		return eventTriggerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pmf.pim.interactive.ClassHandlerAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClassHandlerActionItemProvider classHandlerActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pmf.pim.interactive.ClassHandlerAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClassHandlerActionAdapter() {
		if (classHandlerActionItemProvider == null) {
			classHandlerActionItemProvider = new ClassHandlerActionItemProvider(
					this);
		}

		return classHandlerActionItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory
				.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setParentAdapterFactory(
			ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>)
					|| (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to
	 * {@link #parentAdapterFactory}. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void dispose() {
		if (triggerActionItemProvider != null)
			triggerActionItemProvider.dispose();
		if (dataPredicateItemProvider != null)
			dataPredicateItemProvider.dispose();
		if (uiPredicateItemProvider != null)
			uiPredicateItemProvider.dispose();
		if (expressionConditionItemProvider != null)
			expressionConditionItemProvider.dispose();
		if (setActionItemProvider != null)
			setActionItemProvider.dispose();
		if (triggerItemProvider != null)
			triggerItemProvider.dispose();
		if (predicateTermItemProvider != null)
			predicateTermItemProvider.dispose();
		if (conditionTriggerItemProvider != null)
			conditionTriggerItemProvider.dispose();
		if (eventTriggerItemProvider != null)
			eventTriggerItemProvider.dispose();
		if (classHandlerActionItemProvider != null)
			classHandlerActionItemProvider.dispose();
	}

}
