/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.RequestCounter;
import org.eclipse.rap.rwt.internal.protocol.ClientMessage;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.protocol.RequestMessage;
import org.eclipse.rap.rwt.internal.protocol.ResponseMessage;
import org.eclipse.rap.rwt.internal.remote.MessageChainReference;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.UISessionImpl;
import org.eclipse.rap.rwt.service.ServiceHandler;
import org.eclipse.rap.rwt.service.UISession;

public class LifeCycleServiceHandler
implements ServiceHandler {
    private static final String PROP_ERROR = "error";
    private static final String ATTR_LAST_RESPONSE_MESSAGE = String.valueOf(LifeCycleServiceHandler.class.getName()) + "#lastResponseMessage";
    private final MessageChainReference messageChainReference;

    public LifeCycleServiceHandler(MessageChainReference messageChainReference) {
        this.messageChainReference = messageChainReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        UISessionImpl uiSession = (UISessionImpl)ContextProvider.getUISession();
        if (uiSession == null) {
            LifeCycleServiceHandler.setJsonResponseHeaders((ServletResponse)response);
            LifeCycleServiceHandler.writeSessionTimeoutError(response);
        } else {
            Object object = uiSession.getRequestLock();
            synchronized (object) {
                this.synchronizedService(request, response);
            }
        }
    }

    void synchronizedService(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.processUIRequest(request, response);
        }
        catch (IOException exception) {
            LifeCycleServiceHandler.shutdownUISession();
            throw exception;
        }
        catch (RuntimeException exception) {
            LifeCycleServiceHandler.shutdownUISession();
            throw exception;
        }
    }

    private void processUIRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RequestMessage requestMessage = LifeCycleServiceHandler.readRequestMessage(request);
        LifeCycleServiceHandler.setJsonResponseHeaders((ServletResponse)response);
        if (LifeCycleServiceHandler.isSessionShutdown(requestMessage)) {
            LifeCycleServiceHandler.shutdownUISession();
            LifeCycleServiceHandler.writeEmptyMessage((ServletResponse)response);
        } else if (!LifeCycleServiceHandler.isRequestCounterValid(requestMessage)) {
            if (LifeCycleServiceHandler.isDuplicateRequest(requestMessage)) {
                LifeCycleServiceHandler.writeBufferedResponse(response);
            } else {
                LifeCycleServiceHandler.writeInvalidRequestCounterError(response);
            }
        } else {
            ResponseMessage responseMessage = this.processMessage(requestMessage);
            LifeCycleServiceHandler.writeResponseMessage(responseMessage, (ServletResponse)response);
            RequestCounter.getInstance().nextRequestId();
        }
    }

    private static RequestMessage readRequestMessage(HttpServletRequest request) {
        try {
            return new ClientMessage(JsonObject.readFrom(LifeCycleServiceHandler.getReader(request)));
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unable to read the json message", ioe);
        }
    }

    private static Reader getReader(HttpServletRequest request) throws IOException {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return new InputStreamReader((InputStream)request.getInputStream(), encoding);
    }

    private ResponseMessage processMessage(RequestMessage requestMessage) {
        return this.messageChainReference.get().handleMessage(requestMessage);
    }

    static boolean isRequestCounterValid(RequestMessage requestMessage) {
        int expectedRequestId = RequestCounter.getInstance().currentRequestId();
        JsonValue sentRequestId = requestMessage.getHead().get("requestCounter");
        if (sentRequestId == null) {
            return false;
        }
        return sentRequestId.asInt() == expectedRequestId;
    }

    private static boolean isDuplicateRequest(RequestMessage requestMessage) {
        int currentRequestId = RequestCounter.getInstance().currentRequestId();
        JsonValue sentRequestId = requestMessage.getHead().get("requestCounter");
        return sentRequestId != null && sentRequestId.asInt() == currentRequestId - 1;
    }

    private static void shutdownUISession() {
        UISessionImpl uiSession = (UISessionImpl)ContextProvider.getUISession();
        uiSession.shutdown();
    }

    private static void writeInvalidRequestCounterError(HttpServletResponse response) throws IOException {
        LifeCycleServiceHandler.writeError(response, 412, "invalid request counter");
    }

    private static void writeSessionTimeoutError(HttpServletResponse response) throws IOException {
        LifeCycleServiceHandler.writeError(response, 403, "session timeout");
    }

    private static void writeError(HttpServletResponse response, int statusCode, String errorType) throws IOException {
        response.setStatus(statusCode);
        ProtocolMessageWriter writer = new ProtocolMessageWriter();
        writer.appendHead(PROP_ERROR, JsonValue.valueOf(errorType));
        writer.createMessage().toJson().writeTo(response.getWriter());
    }

    private static boolean isSessionShutdown(RequestMessage requestMessage) {
        return JsonValue.TRUE.equals(requestMessage.getHead().get("shutdown"));
    }

    private static void setJsonResponseHeaders(ServletResponse response) {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
    }

    private static void writeEmptyMessage(ServletResponse response) throws IOException {
        new ProtocolMessageWriter().createMessage().toJson().writeTo(response.getWriter());
    }

    private static void writeResponseMessage(ResponseMessage responseMessage, ServletResponse response) throws IOException {
        LifeCycleServiceHandler.bufferMessage(responseMessage);
        responseMessage.toJson().writeTo(response.getWriter());
    }

    private static void writeBufferedResponse(HttpServletResponse response) throws IOException {
        LifeCycleServiceHandler.getBufferedMessage().toJson().writeTo(response.getWriter());
    }

    private static void bufferMessage(ResponseMessage responseMessage) {
        UISession uiSession = ContextProvider.getUISession();
        if (uiSession != null) {
            uiSession.setAttribute(ATTR_LAST_RESPONSE_MESSAGE, responseMessage);
        }
    }

    private static ResponseMessage getBufferedMessage() {
        return (ResponseMessage)ContextProvider.getUISession().getAttribute(ATTR_LAST_RESPONSE_MESSAGE);
    }
}

