/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable.masterdetail;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.map.AbstractObservableMap;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.internal.databinding.identity.IdentityMap;
import org.eclipse.core.internal.databinding.identity.IdentitySet;
import org.eclipse.core.internal.databinding.observable.Util;

public class MapDetailValueObservableMap<K, M, E>
extends AbstractObservableMap<K, E>
implements IObserving {
    private IObservableMap<K, M> masterMap;
    private IObservableFactory<? super M, IObservableValue<E>> observableValueFactory;
    private Object detailValueType;
    private Set<Map.Entry<K, E>> entrySet;
    private IdentityHashMap<K, IObservableValue<E>> keyDetailMap = new IdentityHashMap();
    private IdentitySet<IObservableValue<E>> staleDetailObservables = new IdentitySet();
    private IMapChangeListener<K, M> masterMapListener = event -> this.handleMasterMapChange(event.diff);
    private IStaleListener masterStaleListener = staleEvent -> this.fireStale();
    private IStaleListener detailStaleListener = new IStaleListener(){

        @Override
        public void handleStale(StaleEvent staleEvent) {
            MapDetailValueObservableMap.this.addStaleDetailObservable((IObservableValue)staleEvent.getObservable());
        }
    };

    public MapDetailValueObservableMap(IObservableMap<K, M> masterMap, IObservableFactory<? super M, IObservableValue<E>> observableValueFactory, Object detailValueType) {
        super(masterMap.getRealm());
        this.masterMap = masterMap;
        this.observableValueFactory = observableValueFactory;
        this.detailValueType = detailValueType;
        masterMap.addMapChangeListener(this.masterMapListener);
        masterMap.addStaleListener(this.masterStaleListener);
        masterMap.addDisposeListener(event -> this.dispose());
        Map emptyMap = Collections.emptyMap();
        MapDiff initMasterDiff = Diffs.computeMapDiff(emptyMap, masterMap);
        this.handleMasterMapChange(initMasterDiff);
    }

    private void handleMasterMapChange(MapDiff<? extends K, ? extends M> diff) {
        IdentityMap<K, E> oldValues = new IdentityMap<K, E>();
        IdentityMap<K, Object> newValues = new IdentityMap<K, Object>();
        Set<K> addedKeys = diff.getAddedKeys();
        for (K addedKey : addedKeys) {
            this.addDetailObservable(addedKey);
            IObservableValue<E> detailValue = this.getDetailObservableValue(addedKey);
            newValues.put(addedKey, detailValue.getValue());
        }
        Set<K> removedKeys = diff.getRemovedKeys();
        for (K removedKey : removedKeys) {
            IObservableValue<E> detailValue = this.getDetailObservableValue(removedKey);
            oldValues.put(removedKey, detailValue.getValue());
            this.removeDetailObservable(removedKey);
        }
        Set<K> changedKeys = diff.getChangedKeys();
        for (K changedKey : changedKeys) {
            IObservableValue<E> oldDetailValue = this.getDetailObservableValue(changedKey);
            oldValues.put(changedKey, oldDetailValue.getValue());
            this.removeDetailObservable(changedKey);
            this.addDetailObservable(changedKey);
            IObservableValue<E> newDetailValue = this.getDetailObservableValue(changedKey);
            newValues.put(changedKey, newDetailValue.getValue());
        }
        this.fireMapChange(Diffs.createMapDiff(addedKeys, removedKeys, changedKeys, oldValues, newValues));
    }

    private void addDetailObservable(K addedKey) {
        M masterElement = this.masterMap.get(addedKey);
        IObservableValue<E> detailValue = this.keyDetailMap.get(addedKey);
        if (detailValue == null) {
            detailValue = this.createDetailObservable(masterElement);
            this.keyDetailMap.put(addedKey, detailValue);
            detailValue.addValueChangeListener(event -> {
                if (!event.getObservableValue().isStale()) {
                    this.staleDetailObservables.remove(event.getSource());
                }
                this.fireMapChange(Diffs.createMapDiffSingleChange(addedKey, event.diff.getOldValue(), event.diff.getNewValue()));
            });
            if (detailValue.isStale()) {
                this.addStaleDetailObservable(detailValue);
            }
        }
        detailValue.addStaleListener(this.detailStaleListener);
    }

    private IObservableValue<E> createDetailObservable(M masterElement) {
        ObservableTracker.setIgnore(true);
        try {
            IObservableValue<E> iObservableValue = this.observableValueFactory.createObservable(masterElement);
            return iObservableValue;
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    }

    private void removeDetailObservable(Object removedKey) {
        if (this.isDisposed()) {
            return;
        }
        IObservableValue<E> detailValue = this.keyDetailMap.remove(removedKey);
        this.staleDetailObservables.remove(detailValue);
        detailValue.dispose();
    }

    private IObservableValue<E> getDetailObservableValue(Object masterKey) {
        return this.keyDetailMap.get(masterKey);
    }

    private void addStaleDetailObservable(IObservableValue<E> detailObservable) {
        boolean wasStale = this.isStale();
        this.staleDetailObservables.add(detailObservable);
        if (!wasStale) {
            this.fireStale();
        }
    }

    @Override
    public Set<K> keySet() {
        this.getterCalled();
        return this.masterMap.keySet();
    }

    @Override
    public E get(Object key) {
        this.getterCalled();
        if (!this.containsKey(key)) {
            return null;
        }
        IObservableValue<E> detailValue = this.getDetailObservableValue(key);
        return detailValue.getValue();
    }

    @Override
    public E put(K key, E value) {
        if (!this.containsKey(key)) {
            return null;
        }
        IObservableValue<E> detailValue = this.getDetailObservableValue(key);
        E oldValue = detailValue.getValue();
        detailValue.setValue(value);
        return oldValue;
    }

    @Override
    public boolean containsKey(Object key) {
        this.getterCalled();
        return this.masterMap.containsKey(key);
    }

    @Override
    public E remove(Object key) {
        this.checkRealm();
        if (!this.containsKey(key)) {
            return null;
        }
        IObservableValue<E> detailValue = this.getDetailObservableValue(key);
        E oldValue = detailValue.getValue();
        this.masterMap.remove(key);
        return oldValue;
    }

    @Override
    public int size() {
        this.getterCalled();
        return this.masterMap.size();
    }

    @Override
    public boolean isStale() {
        return super.isStale() || this.masterMap != null && this.masterMap.isStale() || this.staleDetailObservables != null && !this.staleDetailObservables.isEmpty();
    }

    @Override
    public Object getKeyType() {
        return this.masterMap.getKeyType();
    }

    @Override
    public Object getValueType() {
        return this.detailValueType;
    }

    @Override
    public Object getObserved() {
        return this.masterMap;
    }

    @Override
    public synchronized void dispose() {
        if (this.masterMap != null) {
            this.masterMap.removeMapChangeListener(this.masterMapListener);
            this.masterMap.removeStaleListener(this.masterStaleListener);
        }
        if (this.keyDetailMap != null) {
            for (IObservableValue<E> detailValue : this.keyDetailMap.values()) {
                detailValue.dispose();
            }
            this.keyDetailMap.clear();
        }
        this.masterMap = null;
        this.observableValueFactory = null;
        this.detailValueType = null;
        this.keyDetailMap = null;
        this.masterStaleListener = null;
        this.detailStaleListener = null;
        this.staleDetailObservables = null;
        super.dispose();
    }

    @Override
    public Set<Map.Entry<K, E>> entrySet() {
        this.getterCalled();
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private void getterCalled() {
        ObservableTracker.getterCalled(this);
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, E>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, E>> iterator() {
            final Iterator keyIterator = MapDetailValueObservableMap.this.keySet().iterator();
            return new Iterator<Map.Entry<K, E>>(){

                @Override
                public boolean hasNext() {
                    return keyIterator.hasNext();
                }

                @Override
                public Map.Entry<K, E> next() {
                    Object key = keyIterator.next();
                    return new MapEntry(key);
                }

                @Override
                public void remove() {
                    keyIterator.remove();
                }
            };
        }

        @Override
        public int size() {
            return MapDetailValueObservableMap.this.size();
        }
    }

    private final class MapEntry
    implements Map.Entry<K, E> {
        private final K key;

        private MapEntry(K key) {
            this.key = key;
        }

        @Override
        public K getKey() {
            MapDetailValueObservableMap.this.getterCalled();
            return this.key;
        }

        @Override
        public E getValue() {
            return MapDetailValueObservableMap.this.get(this.getKey());
        }

        @Override
        public E setValue(E value) {
            return MapDetailValueObservableMap.this.put(this.getKey(), value);
        }

        @Override
        public boolean equals(Object o) {
            MapDetailValueObservableMap.this.getterCalled();
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            return Util.equals(this.getKey(), that.getKey()) && Util.equals(this.getValue(), that.getValue());
        }

        @Override
        public int hashCode() {
            MapDetailValueObservableMap.this.getterCalled();
            Object value = this.getValue();
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (value == null ? 0 : value.hashCode());
        }
    }
}

