/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.properties;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.ui.internal.messages.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.eclipse.ui.navigator.INavigatorContentService;

public class BasicTabbedPropertySheetTitleProvider
extends LabelProvider {
    private ILabelProvider labelProvider;
    private IDescriptionProvider descriptionProvider;

    protected ILabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.initProviders();
        }
        return this.labelProvider;
    }

    protected IDescriptionProvider getDescriptionProvider() {
        if (this.descriptionProvider == null) {
            this.initProviders();
        }
        return this.descriptionProvider;
    }

    protected void initProviders() {
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        INavigatorContentService contentService = (INavigatorContentService)part.getAdapter(INavigatorContentService.class);
        if (contentService != null) {
            this.labelProvider = contentService.createCommonLabelProvider();
            this.descriptionProvider = contentService.createCommonDescriptionProvider();
        } else {
            EditingDomain editingDomain;
            IEditingDomainProvider editingDomainProvider = (IEditingDomainProvider)part.getAdapter(IEditingDomainProvider.class);
            if (editingDomainProvider != null && (editingDomain = editingDomainProvider.getEditingDomain()) instanceof TransactionalEditingDomain) {
                AdapterFactory adapterFactory = (AdapterFactory)part.getAdapter(AdapterFactory.class);
                if (adapterFactory == null && editingDomain instanceof AdapterFactoryEditingDomain) {
                    adapterFactory = ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
                }
                this.labelProvider = new TransactionalAdapterFactoryLabelProvider((TransactionalEditingDomain)editingDomain, adapterFactory);
                this.descriptionProvider = new DelegatingDescriptionProvider(this.labelProvider);
            }
        }
    }

    protected Object unwrap(Object element) {
        return AdapterFactoryEditingDomain.unwrap((Object)element);
    }

    public Image getImage(Object element) {
        ILabelProvider labelProvider = this.getLabelProvider();
        if (labelProvider != null) {
            if (element instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)element;
                if (structuredSelection.size() == 1 && (element = this.unwrap(structuredSelection.getFirstElement())) != null) {
                    return labelProvider.getImage(element);
                }
            } else {
                Object unwrapped = this.unwrap(element);
                if (unwrapped != null) {
                    return labelProvider.getImage(unwrapped);
                }
            }
        }
        return null;
    }

    public String getText(Object element) {
        IDescriptionProvider descriptionProvider = this.getDescriptionProvider();
        if (descriptionProvider != null) {
            if (element instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)element;
                if (structuredSelection.size() == 1) {
                    element = this.unwrap(structuredSelection.getFirstElement());
                }
                if (element != null) {
                    return descriptionProvider.getDescription(element);
                }
            } else {
                Object unwrapped = this.unwrap(element);
                if (unwrapped != null) {
                    return descriptionProvider.getDescription(unwrapped);
                }
            }
        }
        return null;
    }

    protected class DelegatingDescriptionProvider
    implements IDescriptionProvider {
        private ILabelProvider labelProvider;

        public DelegatingDescriptionProvider(ILabelProvider labelProvider) {
            Assert.isNotNull((Object)labelProvider);
            this.labelProvider = labelProvider;
        }

        public String getDescription(Object anElement) {
            block7: {
                block6: {
                    if (!(anElement instanceof IStructuredSelection)) break block6;
                    List collection = ((IStructuredSelection)anElement).toList();
                    switch (collection.size()) {
                        case 0: {
                            return Messages.label_selectedNothing;
                        }
                        case 1: {
                            Object object = collection.iterator().next();
                            String text = this.labelProvider.getText(object);
                            if (text != null && text.length() > 0) {
                                return text;
                            }
                            break block7;
                        }
                        default: {
                            return NLS.bind((String)Messages.label_multipleItemsSelected, (Object)Integer.toString(collection.size()));
                        }
                    }
                }
                String text = this.labelProvider.getText(anElement);
                if (text != null && text.length() > 0) {
                    return text;
                }
            }
            return " ";
        }
    }
}

