/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.editors.forms;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryContentProvider;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.editors.forms.internal.Activator;
import org.eclipse.sphinx.emf.editors.forms.internal.DefaultSaveable;
import org.eclipse.sphinx.emf.editors.forms.internal.messages.Messages;
import org.eclipse.sphinx.emf.editors.forms.pages.GenericContentsTreePage;
import org.eclipse.sphinx.emf.editors.forms.pages.MessagePage;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.ui.util.EcoreUIUtil;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.workspace.domain.WorkspaceEditingDomainManager;
import org.eclipse.sphinx.emf.workspace.loading.ModelLoadManager;
import org.eclipse.sphinx.emf.workspace.saving.ModelSaveManager;
import org.eclipse.sphinx.emf.workspace.ui.saving.BasicModelSaveablesProvider;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.sphinx.platform.ui.util.SelectionUtil;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.navigator.SaveablesProvider;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicTransactionalFormEditor
extends FormEditor
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker,
IPersistableEditor,
ITabbedPropertySheetPageContributor,
ISaveablesSource {
    private static final String TAG_EDITOR_DIRTY_ON_WORKBENCH_CLOSE = "editorDirtyOnWorkbenchClose";
    protected IUndoContext undoContext;
    private EObject modelRoot = null;
    private EObject oldModelRoot = null;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected Set<IPropertySheetPage> propertySheetPages = new HashSet<IPropertySheetPage>();
    protected ISelectionProvider selectionProvider;
    protected ISelectionProvider currentSelectionProvider;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected boolean refreshOnActivation = false;
    protected IFormPage loadingEditorInputPage;
    protected SaveablesProvider modelSaveablesProvider;
    protected AdapterFactoryItemDelegator itemDelegator;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof ContentOutline) {
                if (((ContentOutline)part).getCurrentPage() == BasicTransactionalFormEditor.this.contentOutlinePage) {
                    BasicTransactionalFormEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)BasicTransactionalFormEditor.this);
                    BasicTransactionalFormEditor.this.setCurrentSelectionProvider((ISelectionProvider)BasicTransactionalFormEditor.this.contentOutlineViewer);
                }
            } else if (part instanceof PropertySheet) {
                if (BasicTransactionalFormEditor.this.propertySheetPages.contains(((PropertySheet)part).getCurrentPage())) {
                    BasicTransactionalFormEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)BasicTransactionalFormEditor.this);
                    BasicTransactionalFormEditor.this.handleActivate();
                }
            } else if (part == BasicTransactionalFormEditor.this) {
                BasicTransactionalFormEditor.this.setCurrentSelectionProvider(BasicTransactionalFormEditor.this.selectionProvider);
                BasicTransactionalFormEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part instanceof PropertySheet) {
                ((PropertySheet)part).getCurrentPage().dispose();
                BasicTransactionalFormEditor.this.propertySheetPages.remove(((PropertySheet)part).getCurrentPage());
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private ResourceSetListener resourceLoadedListener;
    private ResourceSetListener resourceMovedListener;
    private ResourceSetListener resourceRemovedListener;
    private IOperationHistoryListener affectedObjectsListener;
    private ResourceSetListener objectRemovedListener;
    private CommandStackListener commandStackListener;

    protected void handleActivate() {
        EditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain instanceof AdapterFactoryEditingDomain && ((AdapterFactoryEditingDomain)editingDomain).getResourceToReadOnlyMap() != null) {
            ((AdapterFactoryEditingDomain)editingDomain).getResourceToReadOnlyMap().clear();
        }
        if (this.refreshOnActivation) {
            this.refreshActivePage();
            this.refreshOnActivation = false;
        }
        this.setSelection(this.getSelection());
    }

    public BasicTransactionalFormEditor() {
        this.undoContext = new ObjectUndoContext((Object)this);
        this.addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                if (BasicTransactionalFormEditor.this.getPageCount() <= 1) {
                    BasicTransactionalFormEditor.this.hideTabs();
                } else {
                    BasicTransactionalFormEditor.this.showTabs();
                }
            }
        });
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        if (BasicTransactionalFormEditor.this.currentSelectionProvider != null) {
                            if (BasicTransactionalFormEditor.this.currentSelectionProvider instanceof Viewer) {
                                ((Viewer)BasicTransactionalFormEditor.this.currentSelectionProvider).setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                            } else {
                                BasicTransactionalFormEditor.this.currentSelectionProvider.setSelection((ISelection)new StructuredSelection(theSelection.toArray()));
                            }
                        }
                    }
                    catch (RuntimeException runtimeException) {}
                }
            };
            runnable.run();
        }
    }

    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
        this.setCurrentSelectionProvider(selectionProvider);
    }

    protected void setCurrentSelectionProvider(ISelectionProvider selectionProvider) {
        if (this.currentSelectionProvider != selectionProvider) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        BasicTransactionalFormEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentSelectionProvider != null) {
                this.currentSelectionProvider.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (selectionProvider != null) {
                selectionProvider.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentSelectionProvider = selectionProvider;
            this.setSelection((ISelection)(this.currentSelectionProvider != null ? this.currentSelectionProvider.getSelection() : StructuredSelection.EMPTY));
        }
    }

    public Viewer getViewer() {
        if (this.currentSelectionProvider instanceof Viewer) {
            return (Viewer)this.currentSelectionProvider;
        }
        return null;
    }

    public void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        EditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain != null) {
            viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter(editingDomain, (Viewer)viewer));
        }
    }

    protected void updateEditorInput(URI newURI) {
        Assert.isNotNull((Object)newURI);
        URI newInputURI = newURI;
        URI oldInputURI = EcoreUIUtil.getURIFromEditorInput((IEditorInput)this.getEditorInput());
        if (!newURI.hasFragment() && oldInputURI != null && oldInputURI.hasFragment()) {
            newInputURI = newURI.appendFragment(oldInputURI.fragment());
        }
        if (!newInputURI.equals((Object)oldInputURI)) {
            URIEditorInput newInput = new URIEditorInput(newInputURI);
            this.setInputWithNotify((IEditorInput)newInput);
            this.setTitleToolTip(this.getTitleToolTip());
        }
    }

    public Object getModelRoot() {
        URI editorInputURI;
        if ((this.modelRoot == null || this.modelRoot.eIsProxy() || this.modelRoot.eResource() == null || !this.modelRoot.eResource().isLoaded()) && (editorInputURI = EcoreUIUtil.getURIFromEditorInput((IEditorInput)this.getEditorInput())) != null) {
            if (this.oldModelRoot == null) {
                this.oldModelRoot = this.modelRoot;
            }
            this.modelRoot = this.getEObject(editorInputURI);
            if (this.modelRoot != null && this.oldModelRoot != null) {
                this.oldModelRoot = null;
            }
        }
        return this.modelRoot;
    }

    public Object getOldModelRoot() {
        return this.oldModelRoot;
    }

    protected EObject getEObject(final URI uri) {
        final TransactionalEditingDomain editingDomain = this.getEditingDomain(uri);
        if (editingDomain != null) {
            final boolean loadOnDemand = this.getEditorInput() instanceof FileStoreEditorInput;
            try {
                return (EObject)TransactionUtil.runExclusive((TransactionalEditingDomain)editingDomain, (RunnableWithResult)new RunnableWithResult.Impl<EObject>(){

                    public void run() {
                        if (uri.hasFragment()) {
                            this.setResult(EcoreResourceUtil.getModelFragment((ResourceSet)editingDomain.getResourceSet(), (URI)uri, (boolean)loadOnDemand));
                        } else {
                            this.setResult(EcoreResourceUtil.getModelRoot((ResourceSet)editingDomain.getResourceSet(), (URI)uri, (boolean)loadOnDemand));
                        }
                    }
                });
            }
            catch (InterruptedException ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)ex);
            }
        }
        return null;
    }

    protected TransactionalEditingDomain getEditingDomain(URI uri) {
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((URI)uri);
        if (editingDomain == null && this.getEditorInput() instanceof FileStoreEditorInput && ((FileStoreEditorInput)this.getEditorInput()).exists()) {
            String modelNamespace = EcoreResourceUtil.readModelNamespace(null, (URI)EcoreUIUtil.getURIFromEditorInput((IEditorInput)this.getEditorInput()));
            editingDomain = WorkspaceEditingDomainManager.INSTANCE.getEditingDomainMapping().getEditingDomain(null, MetaModelDescriptorRegistry.INSTANCE.getDescriptor(java.net.URI.create(modelNamespace)));
        }
        return editingDomain;
    }

    protected Map<?, ?> getLoadOptions() {
        return EcoreResourceUtil.getDefaultLoadOptions();
    }

    public Resource getModelRootResource() {
        Object modelRoot = this.getModelRoot();
        if (modelRoot instanceof EObject) {
            return ((EObject)modelRoot).eResource();
        }
        return null;
    }

    protected String getEditorInputName() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            return editorInput.getName();
        }
        Object modelRoot = this.getModelRoot();
        AdapterFactoryItemDelegator itemDelegator = this.getItemDelegator();
        if (modelRoot != null && itemDelegator != null) {
            return itemDelegator.getText(modelRoot);
        }
        return editorInput.getName();
    }

    protected Image getEditorInputImage() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            ImageDescriptor imageDescriptor = editorInput.getImageDescriptor();
            return ExtendedImageRegistry.getInstance().getImage((Object)imageDescriptor);
        }
        Object modelRoot = this.getModelRoot();
        AdapterFactoryItemDelegator itemDelegator = this.getItemDelegator();
        if (modelRoot != null && itemDelegator != null) {
            Object imageURL = itemDelegator.getImage(modelRoot);
            return ExtendedImageRegistry.getInstance().getImage(imageURL);
        }
        ImageDescriptor imageDescriptor = editorInput.getImageDescriptor();
        return ExtendedImageRegistry.getInstance().getImage((Object)imageDescriptor);
    }

    public IUndoContext getUndoContext() {
        return this.undoContext;
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1 && this.getContainer() instanceof CTabFolder) {
            ((CTabFolder)this.getContainer()).setTabHeight(0);
            ((CTabFolder)this.getContainer()).layout();
        }
    }

    protected void showTabs() {
        if (this.getPageCount() > 1 && this.getContainer() instanceof CTabFolder) {
            ((CTabFolder)this.getContainer()).setTabHeight(-1);
            ((CTabFolder)this.getContainer()).layout();
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(AdapterFactory.class)) {
            return this.getAdapterFactory();
        }
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? this.getContentOutlinePage() : null;
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        if (key.equals(IUndoContext.class)) {
            return this.undoContext;
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    BasicTransactionalFormEditor.this.contentOutlineViewer = this.getTreeViewer();
                    BasicTransactionalFormEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    Object modelRoot = BasicTransactionalFormEditor.this.getModelRoot();
                    EditingDomain editingDomain = BasicTransactionalFormEditor.this.getEditingDomain();
                    AdapterFactory adapterFactory = BasicTransactionalFormEditor.this.getAdapterFactory();
                    if (editingDomain != null && adapterFactory != null) {
                        BasicTransactionalFormEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new TransactionalAdapterFactoryContentProvider((TransactionalEditingDomain)editingDomain, adapterFactory));
                        BasicTransactionalFormEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new TransactionalAdapterFactoryLabelProvider((TransactionalEditingDomain)editingDomain, adapterFactory));
                        BasicTransactionalFormEditor.this.contentOutlineViewer.setInput(modelRoot);
                    } else if (BasicTransactionalFormEditor.this.contentOutlineViewer.getContentProvider() != null) {
                        BasicTransactionalFormEditor.this.contentOutlineViewer.setInput(null);
                    }
                    BasicTransactionalFormEditor.this.createContextMenuFor((StructuredViewer)BasicTransactionalFormEditor.this.contentOutlineViewer);
                    if (modelRoot != null) {
                        BasicTransactionalFormEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(modelRoot), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    BasicTransactionalFormEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    BasicTransactionalFormEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    BasicTransactionalFormEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        TabbedPropertySheetPage propertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        this.propertySheetPages.add((IPropertySheetPage)propertySheetPage);
        return propertySheetPage;
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.selectionProvider != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            ArrayList selectionList = new ArrayList();
            selectionList.add(selectedElement);
            while (selectedElements.hasNext()) {
                selectionList.add(selectedElements.next());
            }
            this.selectionProvider.setSelection((ISelection)new StructuredSelection(selectionList));
        }
    }

    public boolean isDirty() {
        if (this.getEditorInput() instanceof FileStoreEditorInput && ((FileStoreEditorInput)this.getEditorInput()).exists()) {
            return ((BasicCommandStack)this.getEditingDomain().getCommandStack()).isSaveNeeded();
        }
        Object modelRoot = this.getModelRoot();
        if (modelRoot instanceof EObject) {
            return ModelSaveManager.INSTANCE.isDirty(((EObject)modelRoot).eResource());
        }
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        if (this.getEditorInput() instanceof FileStoreEditorInput && ((FileStoreEditorInput)this.getEditorInput()).exists()) {
            return this.isDirty();
        }
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.getEditorInput() instanceof FileStoreEditorInput) {
            this.saveResource();
        } else {
            try {
                Object modelRoot = this.getModelRoot();
                if (modelRoot instanceof EObject) {
                    ModelSaveManager.INSTANCE.saveModel(((EObject)modelRoot).eResource(), this.getSaveOptions(), false, monitor);
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    protected void saveResource() {
        final EditingDomain editingDomain = this.getEditingDomain();
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                if (!(BasicTransactionalFormEditor.this.getModelRootResource().getContents().isEmpty() && !BasicTransactionalFormEditor.this.isPersisted(BasicTransactionalFormEditor.this.getModelRootResource()) || editingDomain.isReadOnly(BasicTransactionalFormEditor.this.getModelRootResource()))) {
                    try {
                        BasicTransactionalFormEditor.this.getModelRootResource().save(saveOptions);
                    }
                    catch (Exception exception) {
                        PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)exception);
                    }
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)exception);
        }
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.getEditingDomain().getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    protected Map<?, ?> getSaveOptions() {
        return EcoreResourceUtil.getDefaultSaveOptions();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null) {
            final URI newResourceURI = EcorePlatformUtil.createURI((IPath)path);
            try {
                EditingDomain editingDomain = this.getEditingDomain();
                if (editingDomain != null) {
                    ((TransactionalEditingDomain)editingDomain).runExclusive(new Runnable(){

                        public void run() {
                            Resource rootResource = BasicTransactionalFormEditor.this.getModelRootResource();
                            if (rootResource != null) {
                                rootResource.setURI(newResourceURI);
                            }
                            BasicTransactionalFormEditor.this.updateEditorInput(newResourceURI);
                        }
                    });
                }
            }
            catch (InterruptedException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
                return;
            }
            IStatusLineManager statusLineManager = this.getActionBars().getStatusLineManager();
            IProgressMonitor monitor = statusLineManager != null ? statusLineManager.getProgressMonitor() : new NullProgressMonitor();
            this.doSave(monitor);
        }
    }

    public void gotoMarker(IMarker marker) {
        try {
            EditingDomain editingDomain;
            EObject notifier;
            String uriAttribute;
            if (marker.isSubtypeOf("org.eclipse.emf.ecore.diagnostic") && (uriAttribute = marker.getAttribute("uri", null)) != null && (notifier = this.getEObject(URI.createURI((String)uriAttribute, (boolean)true))) != null && (editingDomain = this.getEditingDomain()) != null) {
                this.setSelectionToViewer(Collections.singleton(((AdapterFactoryEditingDomain)editingDomain).getWrapper((Object)notifier)));
            }
        }
        catch (CoreException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(this.getEditorInputName());
        this.setTitleImage(this.getEditorInputImage());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        this.addTransactionalEditingDomainListeners((TransactionalEditingDomain)this.getEditingDomain());
        this.modelSaveablesProvider = this.createModelSaveablesProvider();
        this.modelSaveablesProvider.init(this.createModelSaveablesLifecycleListener());
    }

    public void setFocus() {
        Control control;
        int pageIndex = this.getActivePage();
        if (pageIndex != -1 && (control = this.getControl(pageIndex)) != null) {
            control.setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = !SelectionUtil.getStructuredSelection((ISelection)selection).isEmpty() ? selection : this.getDefaultSelection();
        for (ISelectionChangedListener listener : new ArrayList<ISelectionChangedListener>(this.selectionChangedListeners)) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.editorSelection));
        }
        this.setStatusLineManager(this.editorSelection);
    }

    public ISelection getDefaultSelection() {
        Object modelRoot = this.getModelRoot();
        if (modelRoot != null) {
            return new StructuredSelection(modelRoot);
        }
        return StructuredSelection.EMPTY;
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.currentSelectionProvider != null && this.currentSelectionProvider == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(BasicTransactionalFormEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        Object object = collection.iterator().next();
                        String text = this.getItemDelegator() != null ? this.getItemDelegator().getText(object) : "";
                        Object image = this.getItemDelegator() != null ? this.getItemDelegator().getImage(object) : null;
                        statusLineManager.setMessage(ExtendedImageRegistry.getInstance().getImage(image), text);
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(BasicTransactionalFormEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return Activator.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return Activator.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public IOperationHistory getOperationHistory() {
        IWorkspaceCommandStack commandStack;
        EditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain != null && (commandStack = (IWorkspaceCommandStack)editingDomain.getCommandStack()) != null) {
            return commandStack.getOperationHistory();
        }
        return null;
    }

    public void dispose() {
        this.removeTransactionalEditingDomainListeners((TransactionalEditingDomain)this.getEditingDomain());
        IOperationHistory operationHistory = this.getOperationHistory();
        if (operationHistory != null) {
            operationHistory.dispose(this.getUndoContext(), true, true, true);
        }
        this.getSite().getPage().removePartListener(this.partListener);
        if (this.getActionBarContributor() != null && this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().deactivate();
            this.getActionBarContributor().setActiveEditor(null);
        }
        for (IPropertySheetPage propertySheetPage : this.propertySheetPages) {
            propertySheetPage.dispose();
        }
        this.propertySheetPages.clear();
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        if (this.modelSaveablesProvider != null) {
            this.modelSaveablesProvider.dispose();
        }
        if (this.getEditorInput() instanceof FileStoreEditorInput) {
            EcoreResourceUtil.unloadResource((Resource)this.getModelRootResource(), (boolean)true);
        }
        super.dispose();
    }

    protected boolean isDisposed() {
        return this.pages == null;
    }

    protected boolean showOutlineView() {
        return true;
    }

    protected void addTransactionalEditingDomainListeners(TransactionalEditingDomain editingDomain) {
        if (editingDomain != null) {
            if (this.getEditorInput() instanceof FileStoreEditorInput) {
                this.commandStackListener = this.createCommandStackListener();
                Assert.isNotNull((Object)this.commandStackListener);
                editingDomain.getCommandStack().addCommandStackListener(this.commandStackListener);
            } else {
                this.resourceLoadedListener = this.createResourceLoadedListener();
                Assert.isNotNull((Object)this.resourceLoadedListener);
                editingDomain.addResourceSetListener(this.resourceLoadedListener);
                this.resourceMovedListener = this.createResourceMovedListener();
                Assert.isNotNull((Object)this.resourceMovedListener);
                editingDomain.addResourceSetListener(this.resourceMovedListener);
                this.resourceRemovedListener = this.createResourceRemovedListener();
                Assert.isNotNull((Object)this.resourceRemovedListener);
                editingDomain.addResourceSetListener(this.resourceRemovedListener);
                this.objectRemovedListener = this.createObjectRemovedListener();
                Assert.isNotNull((Object)this.objectRemovedListener);
                editingDomain.addResourceSetListener(this.objectRemovedListener);
                this.affectedObjectsListener = this.createAffectedObjectsListener();
                Assert.isNotNull((Object)this.affectedObjectsListener);
                ((IWorkspaceCommandStack)editingDomain.getCommandStack()).getOperationHistory().addOperationHistoryListener(this.affectedObjectsListener);
            }
        }
    }

    protected void removeTransactionalEditingDomainListeners(TransactionalEditingDomain editingDomain) {
        if (editingDomain != null) {
            if (this.resourceLoadedListener != null) {
                editingDomain.removeResourceSetListener(this.resourceLoadedListener);
            }
            if (this.resourceMovedListener != null) {
                editingDomain.removeResourceSetListener(this.resourceMovedListener);
            }
            if (this.resourceRemovedListener != null) {
                editingDomain.removeResourceSetListener(this.resourceRemovedListener);
            }
            if (this.objectRemovedListener != null) {
                editingDomain.removeResourceSetListener(this.objectRemovedListener);
            }
            if (this.affectedObjectsListener != null) {
                IOperationHistory operationHistory = ((IWorkspaceCommandStack)editingDomain.getCommandStack()).getOperationHistory();
                operationHistory.removeOperationHistoryListener(this.affectedObjectsListener);
            }
            if (this.commandStackListener != null) {
                IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)editingDomain.getCommandStack();
                commandStack.removeCommandStackListener(this.commandStackListener);
            }
        }
    }

    protected CommandStackListener createCommandStackListener() {
        return new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                ExtendedPlatformUI.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        BasicTransactionalFormEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            BasicTransactionalFormEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        for (IPropertySheetPage propertySheetPage : (this).BasicTransactionalFormEditor.this.propertySheetPages) {
                            if (propertySheetPage == null || propertySheetPage.getControl().isDisposed()) continue;
                            if (propertySheetPage instanceof PropertySheetPage) {
                                ((PropertySheetPage)propertySheetPage).refresh();
                                continue;
                            }
                            if (!(propertySheetPage instanceof TabbedPropertySheetPage)) continue;
                            ((TabbedPropertySheetPage)propertySheetPage).refresh();
                        }
                    }
                });
            }
        };
    }

    protected ResourceSetListener createResourceLoadedListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResource(), (int)4)){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                List notifications = event.getNotifications();
                for (Object object : notifications) {
                    URI editorInputURI;
                    Resource loadedResource;
                    Notification notification;
                    if (!(object instanceof Notification) || !(notification = (Notification)object).getNewBooleanValue() || !(loadedResource = (Resource)notification.getNotifier()).isLoaded() || (editorInputURI = EcoreUIUtil.getURIFromEditorInput((IEditorInput)BasicTransactionalFormEditor.this.getEditorInput())) == null || !loadedResource.getURI().equals((Object)editorInputURI.trimFragment())) continue;
                    this.handleModelRootResourceLoaded();
                    break;
                }
            }

            private void handleModelRootResourceLoaded() {
                IWorkbenchPartSite site = BasicTransactionalFormEditor.this.getSite();
                if (site != null && site.getShell() != null && !site.getShell().isDisposed()) {
                    site.getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            IOperationHistory operationHistory = BasicTransactionalFormEditor.this.getOperationHistory();
                            if (operationHistory != null) {
                                operationHistory.dispose((this).BasicTransactionalFormEditor.this.undoContext, true, true, true);
                            }
                            BasicTransactionalFormEditor.this.firePropertyChange(257);
                            BasicTransactionalFormEditor.this.setPartName(BasicTransactionalFormEditor.this.getEditorInputName());
                            BasicTransactionalFormEditor.this.setTitleImage(BasicTransactionalFormEditor.this.getEditorInputImage());
                            if (BasicTransactionalFormEditor.this.getActionBarContributor().getActiveEditor() == BasicTransactionalFormEditor.this) {
                                BasicTransactionalFormEditor.this.refreshActivePage();
                            } else {
                                (this).BasicTransactionalFormEditor.this.refreshOnActivation = true;
                            }
                        }
                    });
                }
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        };
    }

    protected ResourceSetListener createResourceMovedListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResource(), (int)1)){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                List notifications = event.getNotifications();
                for (Object object : notifications) {
                    Notification notification;
                    if (!(object instanceof Notification) || !((notification = (Notification)object).getOldValue() instanceof URI)) continue;
                    URI oldResourceURI = (URI)notification.getOldValue();
                    URI editorInputURI = EcoreUIUtil.getURIFromEditorInput((IEditorInput)BasicTransactionalFormEditor.this.getEditorInput());
                    if (editorInputURI == null || oldResourceURI == null || !oldResourceURI.equals((Object)editorInputURI.trimFragment())) continue;
                    this.handleModelRootResourceMoved((URI)notification.getNewValue());
                    break;
                }
            }

            private void handleModelRootResourceMoved(final URI newResourceURI) {
                IWorkbenchPartSite site = BasicTransactionalFormEditor.this.getSite();
                if (site != null && site.getShell() != null && !site.getShell().isDisposed()) {
                    site.getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            IOperationHistory operationHistory = BasicTransactionalFormEditor.this.getOperationHistory();
                            if (operationHistory != null) {
                                operationHistory.dispose((this).BasicTransactionalFormEditor.this.undoContext, true, true, true);
                            }
                            BasicTransactionalFormEditor.this.firePropertyChange(257);
                            BasicTransactionalFormEditor.this.updateEditorInput(newResourceURI);
                        }
                    });
                }
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        };
    }

    protected ResourceSetListener createResourceRemovedListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResourceSet(), (int)0).and(NotificationFilter.createEventTypeFilter((int)4).or(NotificationFilter.createEventTypeFilter((int)6)))){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                HashSet<Resource> removedResources = new HashSet<Resource>();
                List notifications = event.getNotifications();
                for (Object object : notifications) {
                    Resource oldResource;
                    if (!(object instanceof Notification)) continue;
                    Notification notification = (Notification)object;
                    Object oldValue = notification.getOldValue();
                    if (oldValue instanceof Resource && (oldResource = (Resource)oldValue).getResourceSet() == null) {
                        removedResources.add(oldResource);
                    }
                    if (!(oldValue instanceof List)) continue;
                    List oldResources = (List)oldValue;
                    for (Resource oldResource2 : oldResources) {
                        if (oldResource2.getResourceSet() != null) continue;
                        removedResources.add(oldResource2);
                    }
                }
                URI editorInputURI = EcoreUIUtil.getURIFromEditorInput((IEditorInput)BasicTransactionalFormEditor.this.getEditorInput());
                if (editorInputURI != null) {
                    URI modelRootResourceURI = editorInputURI.trimFragment();
                    for (Resource removedResource : removedResources) {
                        if (!removedResource.getURI().equals((Object)modelRootResourceURI)) continue;
                        this.handleModelRootResourceRemoved();
                    }
                }
            }

            private void handleModelRootResourceRemoved() {
                BasicTransactionalFormEditor.this.close(false);
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        };
    }

    protected ResourceSetListener createObjectRemovedListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createEventTypeFilter((int)4).or(NotificationFilter.createEventTypeFilter((int)6))){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                HashSet<EObject> removedObjects = new HashSet<EObject>();
                List notifications = event.getNotifications();
                for (Object object : notifications) {
                    EObject oldObject;
                    if (!(object instanceof Notification)) continue;
                    Notification notification = (Notification)object;
                    Object oldValue = notification.getOldValue();
                    if (oldValue instanceof EObject && (oldObject = (EObject)oldValue).eResource() == null) {
                        removedObjects.add(oldObject);
                    }
                    if (!(oldValue instanceof List)) continue;
                    for (Object oldValueItem : (List)oldValue) {
                        EObject oldObject2;
                        if (!(oldValueItem instanceof EObject) || (oldObject2 = (EObject)oldValueItem).eResource() != null) continue;
                        removedObjects.add(oldObject2);
                    }
                }
                if (BasicTransactionalFormEditor.this.getModelRoot() == null) {
                    Object oldModelRoot = BasicTransactionalFormEditor.this.getOldModelRoot();
                    if (removedObjects.contains(oldModelRoot)) {
                        this.handleModelRootRemoved();
                    } else if (oldModelRoot instanceof EObject) {
                        EObject parent = ((EObject)oldModelRoot).eContainer();
                        while (parent != null) {
                            if (removedObjects.contains(parent)) {
                                this.handleModelRootRemoved();
                                return;
                            }
                            parent = parent.eContainer();
                        }
                    }
                }
            }

            private void handleModelRootRemoved() {
                BasicTransactionalFormEditor.this.close(false);
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        };
    }

    protected IOperationHistoryListener createAffectedObjectsListener() {
        return new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                Set affectedResources;
                if (event.getEventType() == 1) {
                    this.handleOperationAboutToExecute(event.getOperation());
                } else if ((event.getEventType() == 4 || event.getEventType() == 10 || event.getEventType() == 9) && (affectedResources = ResourceUndoContext.getAffectedResources((IUndoableOperation)event.getOperation())).contains(BasicTransactionalFormEditor.this.getModelRootResource())) {
                    this.handleOperationFinished(event.getOperation());
                }
            }

            private void handleOperationAboutToExecute(final IUndoableOperation operation) {
                IWorkbenchPartSite site;
                if (operation.canUndo() && (site = BasicTransactionalFormEditor.this.getSite()) != null && site.getShell() != null && !site.getShell().isDisposed()) {
                    site.getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            if (BasicTransactionalFormEditor.this.isActivePart() || BasicTransactionalFormEditor.this.isMyActivePropertySheetPage()) {
                                IWorkspaceCommandStack cmdStack;
                                IUndoContext defaultUndoContext;
                                EditingDomain editingDomain = BasicTransactionalFormEditor.this.getEditingDomain();
                                if (editingDomain != null && editingDomain.getCommandStack() instanceof IWorkspaceCommandStack && (defaultUndoContext = (cmdStack = (IWorkspaceCommandStack)editingDomain.getCommandStack()).getDefaultUndoContext()) != null) {
                                    operation.removeContext(defaultUndoContext);
                                }
                                operation.addContext(BasicTransactionalFormEditor.this.getUndoContext());
                            }
                        }
                    });
                }
            }

            private void handleOperationFinished(final IUndoableOperation operation) {
                IWorkbenchPartSite site = BasicTransactionalFormEditor.this.getSite();
                if (site != null && site.getShell() != null && !site.getShell().isDisposed()) {
                    site.getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            Command command;
                            if ((BasicTransactionalFormEditor.this.isActivePart() || BasicTransactionalFormEditor.this.isMyActivePropertySheetPage()) && operation instanceof EMFCommandOperation && (command = ((EMFCommandOperation)operation).getCommand()) != null) {
                                BasicTransactionalFormEditor.this.setSelectionToViewer(command.getAffectedObjects());
                            }
                            URI newModelRootURI = EcoreUtil.getURI((EObject)((EObject)BasicTransactionalFormEditor.this.getModelRoot()));
                            BasicTransactionalFormEditor.this.updateEditorInput(newModelRootURI);
                            BasicTransactionalFormEditor.this.setPartName(BasicTransactionalFormEditor.this.getEditorInputName());
                            BasicTransactionalFormEditor.this.setTitleImage(BasicTransactionalFormEditor.this.getEditorInputImage());
                        }
                    });
                }
            }
        };
    }

    protected boolean isActivePart() {
        return this == this.getSite().getWorkbenchWindow().getPartService().getActivePart();
    }

    protected boolean isMyActivePropertySheetPage() {
        IWorkbenchPart activePart = this.getSite().getWorkbenchWindow().getPartService().getActivePart();
        if (activePart instanceof PropertySheet) {
            return this.propertySheetPages.contains(((PropertySheet)activePart).getCurrentPage());
        }
        return false;
    }

    protected SaveablesProvider createModelSaveablesProvider() {
        return new BasicModelSaveablesProvider();
    }

    protected ISaveablesLifecycleListener createModelSaveablesLifecycleListener() {
        return new BasicModelSaveablesProvider.SiteNotifyingSaveablesLifecycleListener((IWorkbenchPart)this){

            public void handleLifecycleEvent(SaveablesLifecycleEvent event) {
                super.handleLifecycleEvent(event);
                if (event.getEventType() == 4) {
                    BasicTransactionalFormEditor.this.firePropertyChange(257);
                }
            }
        };
    }

    public EditingDomain getEditingDomain() {
        URI uri = EcoreUIUtil.getURIFromEditorInput((IEditorInput)this.getEditorInput());
        return this.getEditingDomain(uri);
    }

    public AdapterFactory getAdapterFactory() {
        EditingDomain editingDomain = this.getEditingDomain();
        AdapterFactory customAdapterFactory = this.getCustomAdapterFactory();
        if (customAdapterFactory != null) {
            return customAdapterFactory;
        }
        if (editingDomain != null) {
            return ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
        }
        return null;
    }

    protected AdapterFactory getCustomAdapterFactory() {
        return null;
    }

    public AdapterFactoryItemDelegator getItemDelegator() {
        if (this.itemDelegator == null) {
            this.itemDelegator = this.createItemDelegator();
        }
        return this.itemDelegator;
    }

    protected AdapterFactoryItemDelegator createItemDelegator() {
        AdapterFactory adapterFactory = this.getAdapterFactory();
        if (adapterFactory != null) {
            return new AdapterFactoryItemDelegator(adapterFactory);
        }
        return null;
    }

    protected void createPages() {
        if (this.getModelRoot() == null) {
            IFile file = EcoreUIUtil.getFileFromEditorInput((IEditorInput)this.getEditorInput());
            IModelDescriptor modelDescriptor = ModelDescriptorRegistry.INSTANCE.getModel(file);
            if (modelDescriptor == null) {
                this.close(false);
                return;
            }
            ModelLoadManager.INSTANCE.loadModel(modelDescriptor, true, null);
            this.loadingEditorInputPage = this.createLoadingEditorInputPage();
            if (this.loadingEditorInputPage != null) {
                try {
                    this.addPage(this.loadingEditorInputPage);
                }
                catch (PartInitException ex) {
                    PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
                }
                return;
            }
        }
        super.createPages();
    }

    protected IFormPage createLoadingEditorInputPage() {
        return new MessagePage(this, NLS.bind((String)Messages.label_waitingForModelElementBeingLoaded, (Object)this.getPartName()));
    }

    protected void addPages() {
        try {
            this.addPage((IFormPage)new GenericContentsTreePage(this));
        }
        catch (PartInitException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
        }
    }

    protected synchronized void refreshActivePage() {
        if (!this.isDisposed()) {
            if (this.loadingEditorInputPage != null) {
                this.removePage(this.loadingEditorInputPage.getIndex());
                this.loadingEditorInputPage = null;
                this.createPages();
                if (this.getActivePage() == -1) {
                    this.setActivePage(0);
                }
            } else {
                this.pageChange(this.getActivePage());
            }
        }
    }

    public IFormPage getActivePageInstance() {
        if (!this.isDisposed()) {
            return super.getActivePageInstance();
        }
        return null;
    }

    protected void setActivePage(int pageIndex) {
        if (pageIndex >= 0 && pageIndex < this.getPageCount()) {
            super.setActivePage(pageIndex);
        }
    }

    protected IEditorPart getEditor(int pageIndex) {
        if (pageIndex >= 0 && pageIndex < ((CTabFolder)this.getContainer()).getItemCount()) {
            return super.getEditor(pageIndex);
        }
        return null;
    }

    public void saveState(IMemento memento) {
        memento.putBoolean(TAG_EDITOR_DIRTY_ON_WORKBENCH_CLOSE, this.isDirty());
    }

    public void restoreState(IMemento memento) {
        if (memento.getBoolean(TAG_EDITOR_DIRTY_ON_WORKBENCH_CLOSE).booleanValue()) {
            this.close(false);
        }
    }

    public Saveable[] getActiveSaveables() {
        return this.getSaveables();
    }

    public Saveable[] getSaveables() {
        Saveable saveable;
        if (this.getEditorInput() instanceof FileStoreEditorInput) {
            return new Saveable[]{new DefaultSaveable((IWorkbenchPart)this)};
        }
        if (this.modelSaveablesProvider != null && (saveable = this.modelSaveablesProvider.getSaveable((Object)this.getModelRootResource())) != null) {
            return new Saveable[]{saveable};
        }
        return new Saveable[0];
    }

    public String toString() {
        URI uri;
        Object modelRoot = this.getModelRoot();
        if (modelRoot instanceof EObject && (uri = EcoreUtil.getURI((EObject)((EObject)modelRoot))) != null) {
            return uri.toString();
        }
        return super.toString();
    }
}

