/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.ui.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.mwe.core.resources.ResourceLoader;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.sphinx.emf.mwe.resources.BasicWorkspaceResourceLoader;
import org.eclipse.sphinx.emf.mwe.resources.IWorkspaceResourceLoader;
import org.eclipse.sphinx.xtendxpand.util.XtendXpandUtil;
import org.eclipse.xtend.shared.ui.StorageFinder2;
import org.eclipse.xtend.shared.ui.core.internal.ResourceID;

public class WorkspaceStorageFinder
implements StorageFinder2 {
    protected IWorkspaceResourceLoader workspaceResourceLoader = this.createWorkspaceResourceLoader();

    protected IWorkspaceResourceLoader createWorkspaceResourceLoader() {
        return new BasicWorkspaceResourceLoader();
    }

    public ResourceID findXtendXpandResourceID(IJavaProject javaProject, IStorage storage) {
        this.workspaceResourceLoader.setContextProject(javaProject.getProject());
        if (storage instanceof IFile) {
            IFile file = (IFile)storage;
            IPath javaOutputPath = this.getJavaOutputPath(javaProject.getProject());
            if (javaOutputPath != null && javaOutputPath.isPrefixOf(file.getFullPath())) {
                return null;
            }
            return new ResourceID(XtendXpandUtil.getQualifiedName((IFile)file, null), file.getFileExtension());
        }
        return null;
    }

    protected IPath getJavaOutputPath(IProject project) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            return javaProject.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public IStorage findStorage(IJavaProject javaProject, ResourceID resourceID, boolean searchJars) {
        this.workspaceResourceLoader.setContextProject(javaProject.getProject());
        this.workspaceResourceLoader.setSearchArchives(false);
        return XtendXpandUtil.getUnderlyingFile((String)resourceID.name, (String)resourceID.extension, (ResourceLoader)this.workspaceResourceLoader);
    }

    public int getPriority() {
        return 2;
    }
}

