/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.plugin.ExportPackageSection;
import org.eclipse.pde.internal.ui.editor.plugin.ExportPackageVisibilitySection;
import org.eclipse.pde.internal.ui.editor.plugin.LibrarySection;
import org.eclipse.pde.internal.ui.editor.plugin.LibraryVisibilitySection;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class RuntimePage
extends PDEFormPage {
    public static final String PAGE_ID = "runtime";

    public RuntimePage(FormEditor editor) {
        super(editor, PAGE_ID, PDEUIMessages.RuntimePage_tabName);
    }

    protected String getHelpResource() {
        if (((IPluginModelBase)this.getPDEEditor().getAggregateModel()).isFragmentModel()) {
            return "org.eclipse.pde.doc.user.manifest_fragment_runtime";
        }
        return "org.eclipse.pde.doc.user.manifest_plugin_runtime";
    }

    protected void createFormContent(IManagedForm mform) {
        super.createFormContent(mform);
        ScrolledForm form = mform.getForm();
        form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_JAVA_LIB_OBJ));
        form.setText(PDEUIMessages.ManifestEditor_RuntimeForm_title);
        form.getBody().setLayout((Layout)FormLayoutFactory.createFormGridLayout(false, 2));
        if (this.isBundle()) {
            mform.addPart((IFormPart)new ExportPackageSection(this, form.getBody()));
            if (((ManifestEditor)this.getEditor()).isEquinox()) {
                mform.addPart((IFormPart)new ExportPackageVisibilitySection(this, form.getBody()));
            }
            mform.addPart((IFormPart)new LibrarySection(this, form.getBody()));
        } else {
            mform.addPart((IFormPart)new LibrarySection(this, form.getBody()));
            mform.addPart((IFormPart)new LibraryVisibilitySection(this, form.getBody()));
        }
        if (((IPluginModelBase)this.getPDEEditor().getAggregateModel()).isFragmentModel()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.manifest_fragment_runtime");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.manifest_plugin_runtime");
        }
    }

    private boolean isBundle() {
        return this.getPDEEditor().getContextManager().findContext("bundle-context") != null;
    }
}

