/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.refactoring.PDERenameParticipant;

public class ManifestPackageRenameParticipant
extends PDERenameParticipant {
    protected boolean initialize(Object element) {
        block4: {
            IPackageFragment fragment;
            block5: {
                try {
                    if (!(element instanceof IPackageFragment)) break block4;
                    fragment = (IPackageFragment)element;
                    if (fragment.containsJavaResources()) break block5;
                    return false;
                }
                catch (JavaModelException javaModelException) {}
            }
            IJavaProject javaProject = (IJavaProject)fragment.getAncestor(2);
            IProject project = javaProject.getProject();
            if (WorkspaceModelManager.isPluginProject((IProject)project)) {
                this.fProject = javaProject.getProject();
                this.fElements = new HashMap();
                this.fElements.put(fragment, this.getArguments().getNewName());
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return PDEUIMessages.ManifestPackageRenameParticipant_packageRename;
    }

    protected void addBundleManifestChange(CompositeChange result, IProgressMonitor pm) throws CoreException {
        BundleDescription desc;
        super.addBundleManifestChange(result, pm);
        IPluginModelBase model = PluginRegistry.findModel((IProject)this.fProject);
        if (model != null && (desc = model.getBundleDescription()) != null) {
            BundleDescription[] dependents = desc.getDependents();
            int i = 0;
            while (i < dependents.length) {
                IPluginModelBase candidate;
                if (this.isAffected(desc, dependents[i]) && (candidate = PluginRegistry.findModel((BundleDescription)dependents[i])) instanceof IBundlePluginModelBase) {
                    IFile file = (IFile)candidate.getUnderlyingResource();
                    this.addBundleManifestChange(file, result, pm);
                }
                ++i;
            }
        }
    }

    private boolean isAffected(BundleDescription desc, BundleDescription dependent) {
        ImportPackageSpecification[] imports = dependent.getImportPackages();
        Iterator iter = this.fElements.keySet().iterator();
        while (iter.hasNext()) {
            String name = ((IJavaElement)iter.next()).getElementName();
            int i = 0;
            while (i < imports.length) {
                BaseDescription supplier;
                if (name.equals(imports[i].getName()) && (supplier = imports[i].getSupplier()) instanceof ExportPackageDescription && desc.equals((Object)((ExportPackageDescription)supplier).getExporter())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

