/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.adapters.color;

import java.util.ConcurrentModificationException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.core.graph.DynamicNodeLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.ui.adapters.color.AbstractRelativeValueColorProviderAdapter;
import org.eclipse.stem.ui.adapters.color.AbstractRelativeValueColorProviderAdapterFactory;

public class SEIRRelativeValueColorProviderAdapter
extends AbstractRelativeValueColorProviderAdapter
implements AbstractRelativeValueColorProviderAdapterFactory.PropertySelectionListener {
    private ItemPropertyDescriptor selectedProperty;

    public SEIRRelativeValueColorProviderAdapter(ItemPropertyDescriptor selectedProperty) {
        this.selectedProperty = selectedProperty;
    }

    public float getRelativeValue() {
        Node node = (Node)this.getTarget();
        try {
            for (NodeLabel label : node.getLabels()) {
                DynamicNodeLabel nodeLabel;
                if (!(label instanceof DynamicNodeLabel) || (nodeLabel = (DynamicNodeLabel)label).getDecorator() != this.selectedDecorator) continue;
                if (this.selectedDecorator instanceof DiseaseModel && nodeLabel instanceof DiseaseModelLabel) {
                    if (!((DiseaseModelLabel)nodeLabel).getPopulationModelLabel().getPopulationIdentifier().equals(this.selectedPopulationIdentifier)) continue;
                    this.setRVPTarget((Notifier)nodeLabel);
                    return (float)this.rvp.getRelativeValue(this.selectedProperty);
                }
                if (!(this.selectedDecorator instanceof PopulationModel)) continue;
                String popId = this.selectedPopulationIdentifier;
                if (!(nodeLabel instanceof PopulationModelLabel) || !((PopulationModelLabel)nodeLabel).getPopulationIdentifier().equals(popId)) continue;
                this.setRVPTarget((Notifier)nodeLabel);
                return (float)this.rvp.getRelativeValue(this.selectedProperty);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            return this.getRelativeValue();
        }
        return 0.0f;
    }

    public void propertySelected(ItemPropertyDescriptor selectedProperty) {
        this.selectedProperty = selectedProperty;
    }

    public void setSelectedProperty(ItemPropertyDescriptor selectedProperty) {
        this.selectedProperty = selectedProperty;
    }
}

