/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.explorer;

import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.views.explorer.IdentifiableInstanceTreeNode;
import org.eclipse.stem.ui.views.explorer.IdentifiableTreeNode;
import org.eclipse.swt.widgets.Display;

public class IdentifiableInstanceTreeNodeContentProvider
implements ITreeContentProvider,
IResourceChangeListener,
IResourceDeltaVisitor {
    Viewer viewer;

    public IdentifiableInstanceTreeNodeContentProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] retValue = null;
        if (parentElement instanceof IdentifiableTreeNode) {
            ArrayList<IdentifiableInstanceTreeNode> temp = new ArrayList<IdentifiableInstanceTreeNode>();
            IdentifiableTreeNode itn = (IdentifiableTreeNode)parentElement;
            IFolder folder = itn.getProject().getFolder(itn.getFolderName());
            if (folder.exists()) {
                try {
                    IResource[] iResourceArray = folder.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource identifiableFile = iResourceArray[n2];
                        String identifiableName = identifiableFile.getName();
                        String extension = identifiableFile.getFileExtension();
                        String nameWithoutExtension = identifiableName.substring(0, identifiableName.lastIndexOf(extension) - 1);
                        temp.add(new IdentifiableInstanceTreeNode(itn, nameWithoutExtension, extension));
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    Activator.logError("", e);
                }
            }
            retValue = temp.toArray();
        }
        return retValue;
    }

    public Object getParent(Object element) {
        IdentifiableTreeNode retValue = null;
        if (element instanceof IdentifiableInstanceTreeNode) {
            retValue = ((IdentifiableInstanceTreeNode)element).getParent();
        }
        return retValue;
    }

    public boolean hasChildren(Object parentElement) {
        Object[] children = this.getChildren(parentElement);
        return children != null && children.length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return null;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            Activator.logError("", e);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    IdentifiableInstanceTreeNodeContentProvider.this.viewer.refresh();
                }
            });
        }
        return true;
    }
}

