/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.metamodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CompartmentType implements Enumerator
{
    STANDARD(0, "Standard", "Standard"),
    INCIDENCE(1, "Incidence", "Incidence"),
    DEATHS(2, "Deaths", "Deaths"),
    DERIVED(3, "Derived", "Derived");

    public static final int STANDARD_VALUE = 0;
    public static final int INCIDENCE_VALUE = 1;
    public static final int DEATHS_VALUE = 2;
    public static final int DERIVED_VALUE = 3;
    private static final CompartmentType[] VALUES_ARRAY;
    public static final List<CompartmentType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CompartmentType[]{STANDARD, INCIDENCE, DEATHS, DERIVED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CompartmentType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompartmentType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompartmentType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompartmentType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompartmentType get(int value) {
        switch (value) {
            case 0: {
                return STANDARD;
            }
            case 1: {
                return INCIDENCE;
            }
            case 2: {
                return DEATHS;
            }
            case 3: {
                return DERIVED;
            }
        }
        return null;
    }

    private CompartmentType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

