/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.editor.controls;

import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stem.model.metamodel.Compartment;
import org.eclipse.stem.model.metamodel.CompartmentGroup;
import org.eclipse.stem.model.metamodel.CompartmentType;
import org.eclipse.stem.model.ui.editor.VisualModelUtils;
import org.eclipse.stem.model.ui.wizards.WizardHelper;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ModelCompartmentEditorDialog
extends Dialog {
    protected Text nameText;
    protected ComboViewer dataTypeComboViewer;
    protected ComboViewer compartmentTypeComboViewer;
    protected Compartment compartment;
    protected CompartmentGroup compartmentGroup;
    protected String errorMessage = null;

    public ModelCompartmentEditorDialog(Shell parentShell, int style, CompartmentGroup compartmentGroup, Compartment compartment) {
        super(parentShell);
        this.compartment = compartment;
        this.compartmentGroup = compartmentGroup;
    }

    public void create() {
        super.create();
        this.nameText.setText(VisualModelUtils.safeGet(this.compartment.getName()));
        EDataType selectedDataType = this.compartment.getDataType();
        if (selectedDataType == null) {
            selectedDataType = VisualModelUtils.getDefaultCompartmentDataTypes()[0];
        }
        this.dataTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)selectedDataType));
        CompartmentType selectedCompartmentType = this.compartment.getType();
        if (selectedCompartmentType == null) {
            selectedCompartmentType = CompartmentType.values()[0];
        }
        this.compartmentTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)selectedCompartmentType));
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Composite container = new Composite(parent, 0);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        container.setLayoutData((Object)data);
        container.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(container, 0);
        nameLabel.setText("Name");
        this.nameText = new Text(container, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                ModelCompartmentEditorDialog.this.formatTextFields();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.createCompartmentTypeList(container);
        this.createDataTypeList(container);
        return parent;
    }

    private void createCompartmentTypeList(Composite container) {
        Label dataTypeLabel = new Label(container, 0);
        dataTypeLabel.setText("Compartment Type");
        this.compartmentTypeComboViewer = new ComboViewer(container, 8);
        this.compartmentTypeComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.compartmentTypeComboViewer.setLabelProvider((IBaseLabelProvider)new EMFDataTypeLabelProvider());
        this.compartmentTypeComboViewer.setInput((Object)CompartmentType.values());
    }

    private void createDataTypeList(Composite container) {
        Label dataTypeLabel = new Label(container, 0);
        dataTypeLabel.setText("Data Type");
        this.dataTypeComboViewer = new ComboViewer(container, 8);
        this.dataTypeComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.dataTypeComboViewer.setLabelProvider((IBaseLabelProvider)new EMFDataTypeLabelProvider());
        this.dataTypeComboViewer.setInput((Object)WizardHelper.getDefaultCompartmentDataTypes());
        this.dataTypeComboViewer.getCombo().setLayoutData((Object)new GridData(768));
    }

    protected void formatTextFields() {
        this.nameText.setText(WizardHelper.formatToCamelCase((String)this.nameText.getText()));
    }

    protected boolean validate() {
        if (WizardHelper.isNullOrEmpty((String)this.nameText.getText())) {
            this.errorMessage = "Please enter a name for this compartment";
            return false;
        }
        if (this.hasNameConflict()) {
            this.errorMessage = "A compartment named \"" + this.nameText.getText() + "\" already exists in this model.";
            return false;
        }
        return true;
    }

    private boolean hasNameConflict() {
        for (Compartment compartment : WizardHelper.getAllCompartmentsForGroup((CompartmentGroup)this.compartmentGroup)) {
            if (this.compartment == compartment || !compartment.getName().equals(this.nameText.getText())) continue;
            return true;
        }
        return false;
    }

    protected void okPressed() {
        this.formatTextFields();
        if (this.validate()) {
            this.compartment.setName(WizardHelper.safeGet((String)this.nameText.getText()));
            this.compartment.setType((CompartmentType)((StructuredSelection)this.compartmentTypeComboViewer.getSelection()).getFirstElement());
            this.compartment.setDataType((EDataType)((StructuredSelection)this.dataTypeComboViewer.getSelection()).getFirstElement());
            super.okPressed();
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)this.errorMessage);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private static class EMFDataTypeLabelProvider
    extends LabelProvider {
        private EMFDataTypeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Enumerator) {
                return ((Enumerator)element).getLiteral();
            }
            if (element instanceof EDataType) {
                return ((EDataType)element).getInstanceClassName();
            }
            return "";
        }
    }
}

