/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.provider;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.stem.adapters.history.HistoryProvider;
import org.eclipse.stem.adapters.history.HistoryProviderAdapter;
import org.eclipse.stem.adapters.history.HistoryProviderAdapterFactory;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.model.ModelFactory;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.util.StandardAdapterFactory;

public class StandardHistoryProviderAdapterFactory
extends StandardAdapterFactory
implements RelativeValueProviderAdapterFactory {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    public StandardHistoryProviderAdapterFactory() {
        HistoryProviderAdapterFactory.INSTANCE.addAdapterFactory((AdapterFactory)this);
    }

    @Override
    public Adapter createDiseaseModelLabelAdapter() {
        return new DiseaseModelLabelHistoryProvider();
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    @Override
    public boolean isFactoryForType(Object type) {
        return type == HistoryProvider.class || super.isFactoryForType(type);
    }

    public void dispose() {
    }

    private static class DiseaseModelLabelHistoryProvider
    extends HistoryProviderAdapter
    implements HistoryProvider {
        long cycle = 0L;
        final STEMTime startTime = ModelFactory.eINSTANCE.createSTEMTime();
        final Map<STEMTime, DiseaseModelLabel> history = Collections.synchronizedMap(new TreeMap());

        private DiseaseModelLabelHistoryProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyChanged(Notification msg) {
            block2 : switch (msg.getEventType()) {
                case 1: {
                    switch (msg.getFeatureID(LabelValue.class)) {
                        case 7: {
                            if (msg.getNewValue() == null) break block2;
                            STEMTime timeKey = this.generateNextSTEMTime(this.cycle++);
                            Map<STEMTime, DiseaseModelLabel> map = this.history;
                            synchronized (map) {
                                DiseaseModelLabel dml = (DiseaseModelLabel)EcoreUtil.copy((EObject)((DiseaseModelLabel)this.getTarget()));
                                dml.getNode().getLabels().remove((Object)dml);
                                this.history.put(timeKey, dml);
                            }
                            this.fireHistoryExtended();
                            break block2;
                        }
                    }
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public STEMTime[] getAllHistoricTimeValues() {
            STEMTime[] time = null;
            Map<STEMTime, DiseaseModelLabel> map = this.history;
            synchronized (map) {
                time = this.history.keySet().toArray(new STEMTime[0]);
            }
            return time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Identifiable[] getAllHistoricInstances() {
            Identifiable[] allInstances = null;
            Map<STEMTime, DiseaseModelLabel> map = this.history;
            synchronized (map) {
                allInstances = this.history.values().toArray(new Identifiable[0]);
            }
            return allInstances;
        }

        public Identifiable[] getHistoricInstances(STEMTime[] timeRange) {
            Identifiable[] allValues = this.getAllHistoricInstances();
            Identifiable[] retVal = new Identifiable[timeRange.length];
            System.arraycopy(allValues, 0, retVal, 0, timeRange.length);
            return retVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getEarliestCycleNumber() {
            long retValue = 0L;
            Map<STEMTime, DiseaseModelLabel> map = this.history;
            synchronized (map) {
                try {
                    retValue = this.history.keySet().toArray(new Long[0])[0];
                }
                catch (RuntimeException runtimeException) {}
            }
            return (int)retValue;
        }

        public STEMTime getEarliestTimeValue() {
            return this.generateHistoricSTEMTime(this.getEarliestCycleNumber());
        }

        private STEMTime generateHistoricSTEMTime(int daysInPast) {
            STEMTime retValue = ModelFactory.eINSTANCE.createSTEMTime();
            long daysAgo = retValue.getTime().getTime() - (long)daysInPast * STEMTime.Units.DAY.getMilliseconds();
            retValue.setTime(new Date(daysAgo));
            return retValue;
        }

        private STEMTime generateNextSTEMTime(long daysInFuture) {
            STEMTime retValue = ModelFactory.eINSTANCE.createSTEMTime();
            long day = this.startTime.getTime().getTime() + daysInFuture * STEMTime.Units.DAY.getMilliseconds();
            retValue.setTime(new Date(day));
            return retValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            this.cycle = 0L;
            Map<STEMTime, DiseaseModelLabel> map = this.history;
            synchronized (map) {
                this.history.clear();
            }
            super.reset();
        }
    }
}

