/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core;

import java.util.Random;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;

public class STEMURI {
    private static Random rand = new Random(System.currentTimeMillis());
    public static final URI SCENARIO_TYPE_URI = STEMURI.createTypeURI("Scenario");
    public static final URI MODEL_TYPE_URI = STEMURI.createTypeURI("Model");
    public static final URI GRAPH_TYPE_URI = STEMURI.createTypeURI("Graph");
    public static final URI NODE_TYPE_URI = STEMURI.createTypeURI("Node");
    public static final URI EDGE_TYPE_URI = STEMURI.createTypeURI("Edge");
    public static final URI SEQUENCER_TYPE_URI = STEMURI.createTypeURI("Sequencer");
    public static final URI EXPERIMENT_TYPE_URI = STEMURI.createTypeURI("Experiment");
    public static final URI MODIFIER_TYPE_URI = STEMURI.createTypeURI("Modifier");
    public static final URI TRIGGER_TYPE_URI = STEMURI.createTypeURI("Trigger");
    public static final URI PREDICATE_TYPE_URI = STEMURI.createTypeURI("Predicate");
    public static final URI SOLVER_TYPE_URI = STEMURI.createTypeURI("Solver");
    public static final URI LOGGER_TYPE_URI = STEMURI.createTypeURI("Logger");
    public static final URI IDENTIFIABLE_TYPE_URI = STEMURI.createTypeURI("Identifiable");

    public static URI createTypeURI(String segments) {
        return STEMURI.create("stemtype", segments);
    }

    public static URI createURI(String segments) {
        return STEMURI.create("stem", segments);
    }

    public static URI create(String scheme, String segments) {
        return STEMURI.create(scheme, "org.eclipse.stem", segments);
    }

    public static URI create(String scheme, String authority, String segments) {
        StringBuilder sb = new StringBuilder();
        if (segments.indexOf(scheme) != 0) {
            sb.append(scheme);
            sb.append("://");
        }
        if (segments.indexOf(authority) == -1) {
            sb.append(authority);
            sb.append("/");
        }
        sb.append(segments);
        return URI.createURI((String)sb.toString());
    }

    public static String generateUniquePart() {
        long l = rand.nextLong();
        long now = System.currentTimeMillis();
        long r = l + now;
        return Long.toHexString(r).toUpperCase();
    }

    public static URI normalize(URI in) {
        if (in.scheme().equals("platform")) {
            return in;
        }
        if (in.scheme().equals("file")) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IPath location = root.getLocation();
            int ind = in.toString().indexOf(location.toString());
            if (ind > -1) {
                String rest = in.toString().substring(ind + location.toOSString().length());
                URI result = URI.createPlatformResourceURI((String)rest, (boolean)false);
                return result;
            }
        }
        return in;
    }

    public static URI createFromFile(File f) {
        URI uri = STEMURI.normalize(URI.createURI((String)f.getLocationURI().toString()));
        if (uri.scheme().equals("platform")) {
            return uri;
        }
        if (uri.scheme().equals("file")) {
            IPath location = f.getProject().getRawLocation();
            IPath locationWithoutProject = location.removeLastSegments(1);
            int ind = uri.toString().indexOf(locationWithoutProject.toString());
            if (ind > -1) {
                String rest = uri.toString().substring(ind + locationWithoutProject.toOSString().length());
                URI result = URI.createPlatformResourceURI((String)rest, (boolean)false);
                return result;
            }
        }
        return uri;
    }
}

