/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.featurecalls;

import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;

public class IdentifiableSimpleNameProvider {
    public String getSimpleName(JvmIdentifiableElement element) {
        if (element == null || element.eIsProxy()) {
            return null;
        }
        if (element instanceof JvmFeature) {
            return ((JvmFeature)element).getSimpleName();
        }
        if (element instanceof JvmFormalParameter) {
            return ((JvmFormalParameter)element).getName();
        }
        if (element instanceof XVariableDeclaration) {
            return ((XVariableDeclaration)element).getName();
        }
        if (element instanceof XSwitchExpression) {
            XSwitchExpression xSwitchExpression = (XSwitchExpression)element;
            String varName = xSwitchExpression.getLocalVarName();
            if (varName != null) {
                return varName;
            }
            XExpression expression = xSwitchExpression.getSwitch();
            if (expression instanceof XFeatureCall) {
                return this.getSimpleName(((XFeatureCall)expression).getFeature());
            }
            return null;
        }
        return element.getSimpleName();
    }
}

