/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabelComposer;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Display;

public class JavaElementLinks {
    public static final String OPEN_LINK_SCHEME = "eclipse-open";
    public static final String JAVADOC_SCHEME = "eclipse-javadoc";
    public static final String JAVADOC_VIEW_SCHEME = "eclipse-javadoc-view";
    private static final char LINK_BRACKET_REPLACEMENT = '\u2603';
    private static final char LINK_SEPARATOR = '\u2602';

    private JavaElementLinks() {
    }

    public static LocationListener createLocationListener(final ILinkHandler handler) {
        return new LocationAdapter(){

            public void changing(LocationEvent event) {
                IJavaElement linkTarget;
                String scheme;
                String loc = event.location;
                if ("about:blank".equals(loc)) {
                    handler.handleTextSet();
                    return;
                }
                event.doit = false;
                if (loc.startsWith("about:")) {
                    return;
                }
                URI uri = null;
                try {
                    uri = new URI(loc);
                }
                catch (URISyntaxException e) {
                    if (event.widget instanceof Browser && "ie".equals(((Browser)event.widget).getBrowserType()) && loc.startsWith("file://")) {
                        String path = loc.substring(7).replace('/', '\\');
                        if ((loc = new File(path).toURI().toString()).length() > 7 && loc.startsWith("file:/") && !"//".equals(loc.substring(6, 8))) {
                            loc = "file://" + loc.substring(5);
                        }
                        try {
                            uri = new URI(loc);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            JavaPlugin.log(e);
                            return;
                        }
                    }
                    JavaPlugin.log(e);
                }
                String string = scheme = uri == null ? null : uri.getScheme();
                if (JavaElementLinks.JAVADOC_VIEW_SCHEME.equals(scheme)) {
                    linkTarget = JavaElementLinks.parseURI(uri);
                    if (linkTarget == null) {
                        return;
                    }
                    handler.handleJavadocViewLink(linkTarget);
                } else if (JavaElementLinks.JAVADOC_SCHEME.equals(scheme)) {
                    linkTarget = JavaElementLinks.parseURI(uri);
                    if (linkTarget == null) {
                        return;
                    }
                    handler.handleInlineJavadocLink(linkTarget);
                } else if (JavaElementLinks.OPEN_LINK_SCHEME.equals(scheme)) {
                    linkTarget = JavaElementLinks.parseURI(uri);
                    if (linkTarget == null) {
                        return;
                    }
                    handler.handleDeclarationLink(linkTarget);
                } else {
                    try {
                        if (handler.handleExternalLink(new URL(loc), event.display)) {
                            return;
                        }
                        event.doit = true;
                    }
                    catch (MalformedURLException e) {
                        JavaPlugin.log(e);
                    }
                }
            }
        };
    }

    public static String createURI(String scheme, IJavaElement element) throws URISyntaxException {
        return JavaElementLinks.createURI(scheme, element, null, null, null);
    }

    public static String createURI(String scheme, IJavaElement element, String refTypeName, String refMemberName, String[] refParameterTypes) throws URISyntaxException {
        StringBuffer ssp = new StringBuffer(60);
        ssp.append('\u2602');
        ssp.append(element.getHandleIdentifier().replace('[', '\u2603'));
        if (refTypeName != null) {
            ssp.append('\u2602');
            ssp.append(refTypeName);
            if (refMemberName != null) {
                ssp.append('\u2602');
                ssp.append(refMemberName);
                if (refParameterTypes != null) {
                    ssp.append('\u2602');
                    int i = 0;
                    while (i < refParameterTypes.length) {
                        ssp.append(refParameterTypes[i]);
                        if (i != refParameterTypes.length - 1) {
                            ssp.append('\u2602');
                        }
                        ++i;
                    }
                }
            }
        }
        return new URI(scheme, ssp.toString(), null).toASCIIString();
    }

    public static IJavaElement parseURI(URI uri) {
        String ssp = uri.getSchemeSpecificPart();
        String[] segments = ssp.split(String.valueOf('\u2602'), -1);
        IJavaElement element = JavaCore.create((String)segments[1].replace('\u2603', '['));
        if (segments.length > 2) {
            String refTypeName = segments[2];
            if (refTypeName.indexOf(46) == -1) {
                try {
                    IJavaElement resolvedTypeVariable = JavaElementLinks.resolveTypeVariable(element, refTypeName);
                    if (resolvedTypeVariable != null) {
                        return resolvedTypeVariable;
                    }
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
            }
            if (element instanceof IAnnotation) {
                element = element.getParent();
            }
            if (element instanceof ILocalVariable) {
                element = ((ILocalVariable)element).getDeclaringMember();
            } else if (element instanceof ITypeParameter) {
                element = ((ITypeParameter)element).getDeclaringMember();
            }
            if (element instanceof IMember && !(element instanceof IType)) {
                element = ((IMember)element).getDeclaringType();
            }
            if (element instanceof IType) {
                try {
                    IType type = (IType)element;
                    if (refTypeName.length() > 0) {
                        type = JavaElementLinks.resolveType(type, refTypeName);
                    }
                    if (type != null) {
                        element = type;
                        if (segments.length > 3) {
                            String refMemberName = segments[3];
                            if (segments.length > 4) {
                                String[] paramSignatures = new String[segments[4].length() == 0 ? 0 : segments.length - 4];
                                int i = 0;
                                while (i < paramSignatures.length) {
                                    paramSignatures[i] = Signature.createTypeSignature((String)segments[i + 4], (boolean)false);
                                    ++i;
                                }
                                IMethod method = type.getMethod(refMemberName, paramSignatures);
                                IMethod[] methods = type.findMethods(method);
                                if (methods != null) {
                                    return methods[0];
                                }
                                methods = type.getMethods();
                                int i2 = 0;
                                while (i2 < methods.length) {
                                    method = methods[i2];
                                    if (method.getElementName().equals(refMemberName) && method.getNumberOfParameters() == paramSignatures.length) {
                                        return method;
                                    }
                                    ++i2;
                                }
                                ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(type);
                                method = JavaModelUtil.findMethodInHierarchy(hierarchy, type, refMemberName, paramSignatures, false);
                                if (method != null) {
                                    return method;
                                }
                            } else {
                                IField field = type.getField(refMemberName);
                                if (field.exists()) {
                                    return field;
                                }
                                IMethod[] methods = type.getMethods();
                                int i = 0;
                                while (i < methods.length) {
                                    IMethod method = methods[i];
                                    if (method.getElementName().equals(refMemberName)) {
                                        return method;
                                    }
                                    ++i;
                                }
                            }
                        }
                    }
                    return type;
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
            }
        }
        return element;
    }

    private static IJavaElement resolveTypeVariable(IJavaElement baseElement, String typeVariableName) throws JavaModelException {
        while (baseElement != null) {
            switch (baseElement.getElementType()) {
                case 9: {
                    IMethod method = (IMethod)baseElement;
                    ITypeParameter[] typeParameters = method.getTypeParameters();
                    int i = 0;
                    while (i < typeParameters.length) {
                        ITypeParameter typeParameter = typeParameters[i];
                        if (typeParameter.getElementName().equals(typeVariableName)) {
                            return typeParameter;
                        }
                        ++i;
                    }
                    break;
                }
                case 7: {
                    IType type = (IType)baseElement;
                    ITypeParameter[] typeParameters = type.getTypeParameters();
                    int i = 0;
                    while (i < typeParameters.length) {
                        ITypeParameter typeParameter = typeParameters[i];
                        if (typeParameter.getElementName().equals(typeVariableName)) {
                            return typeParameter;
                        }
                        ++i;
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 11: 
                case 12: 
                case 13: {
                    return null;
                }
            }
            baseElement = baseElement.getParent();
        }
        return null;
    }

    private static IType resolveType(IType baseType, String refTypeName) throws JavaModelException {
        if (refTypeName.length() == 0) {
            return baseType;
        }
        String[][] resolvedNames = baseType.resolveType(refTypeName);
        if (resolvedNames != null && resolvedNames.length > 0) {
            return baseType.getJavaProject().findType(resolvedNames[0][0], resolvedNames[0][1].replace('$', '.'), null);
        }
        if (baseType.isBinary()) {
            IType type = baseType.getJavaProject().findType(refTypeName, null);
            if (type == null) {
                type = baseType.getJavaProject().findType(String.valueOf(baseType.getPackageFragment().getElementName()) + '.' + refTypeName, null);
            }
            return type;
        }
        return null;
    }

    public static String createLink(String uri, String label) {
        return "<a href='" + uri + "'>" + label + "</a>";
    }

    public static String createHeaderLink(String uri, String label) {
        return "<a class='header' href='" + uri + "'>" + label + "</a>";
    }

    public static String getElementLabel(IJavaElement element, long flags) {
        return JavaElementLinks.getElementLabel(element, flags, false);
    }

    public static String getElementLabel(IJavaElement element, long flags, boolean linkAllNames) {
        StringBuffer buf = new StringBuffer();
        if (!Strings.USE_TEXT_PROCESSOR) {
            new JavaElementLinkedLabelComposer(linkAllNames ? null : element, buf).appendElementLabel(element, flags);
            return Strings.markJavaElementLabelLTR(buf.toString());
        }
        String label = JavaElementLabels.getElementLabel(element, flags);
        return label.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static interface ILinkHandler {
        public void handleInlineJavadocLink(IJavaElement var1);

        public void handleJavadocViewLink(IJavaElement var1);

        public void handleDeclarationLink(IJavaElement var1);

        public boolean handleExternalLink(URL var1, Display var2);

        public void handleTextSet();
    }

    private static final class JavaElementLinkedLabelComposer
    extends JavaElementLabelComposer {
        private final IJavaElement fElement;

        public JavaElementLinkedLabelComposer(IJavaElement member, StringBuffer buf) {
            super(buf);
            this.fElement = member;
        }

        public String getElementName(IJavaElement element) {
            String elementName = element.getElementName();
            if (element.equals(this.fElement)) {
                return elementName;
            }
            if (elementName.length() == 0) {
                return elementName;
            }
            try {
                String uri = JavaElementLinks.createURI(JavaElementLinks.JAVADOC_SCHEME, element);
                return JavaElementLinks.createHeaderLink(uri, elementName);
            }
            catch (URISyntaxException e) {
                JavaPlugin.log(e);
                return elementName;
            }
        }

        protected String getGT() {
            return "&gt;";
        }

        protected String getLT() {
            return "&lt;";
        }

        protected String getSimpleTypeName(IJavaElement enclosingElement, String typeSig) {
            String typeName = super.getSimpleTypeName(enclosingElement, typeSig);
            try {
                String uri = JavaElementLinks.createURI(JavaElementLinks.JAVADOC_SCHEME, enclosingElement, typeName, null, null);
                return JavaElementLinks.createHeaderLink(uri, typeName);
            }
            catch (URISyntaxException e) {
                JavaPlugin.log(e);
                return typeName;
            }
        }

        protected String getMemberName(IJavaElement enclosingElement, String typeName, String memberName) {
            try {
                String uri = JavaElementLinks.createURI(JavaElementLinks.JAVADOC_SCHEME, enclosingElement, typeName, memberName, null);
                return JavaElementLinks.createHeaderLink(uri, memberName);
            }
            catch (URISyntaxException e) {
                JavaPlugin.log(e);
                return memberName;
            }
        }

        protected void appendAnnotationLabels(IAnnotation[] annotations, long flags) throws JavaModelException {
            this.fBuffer.append("<span style='font-weight:normal;'>");
            super.appendAnnotationLabels(annotations, flags);
            this.fBuffer.append("</span>");
        }
    }
}

