/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.refactoring.participant;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.ui.refactoring.participant.CompositeRefactoringProcessor;
import org.eclipse.xtext.common.types.ui.refactoring.participant.JdtRenameParticipantContext;
import org.eclipse.xtext.common.types.ui.refactoring.participant.JvmElementFinder;
import org.eclipse.xtext.ui.refactoring.impl.AbstractProcessorBasedRenameParticipant;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdtRenameParticipant
extends AbstractProcessorBasedRenameParticipant {
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private JvmElementFinder jvmElementFinder;
    @Inject
    private CompositeRefactoringProcessor.Access compositeRefactoringProcessorAccess;

    public String getName() {
        return "Xtext JdtRenameParticipant";
    }

    protected List<? extends IRenameElementContext> createRenameElementContexts(Object element) {
        IJavaProject javaProject;
        IProject project;
        ResourceSet resourceSet;
        EObject directJvmElement;
        IJavaElement javaElement;
        EClass expectedJvmType;
        if (element instanceof IJavaElement && (expectedJvmType = this.getExpectedJvmType(javaElement = (IJavaElement)element)) != null && (directJvmElement = this.jvmElementFinder.getCorrespondingJvmElement(javaElement, resourceSet = this.resourceSetProvider.get(project = (javaProject = javaElement.getJavaProject()).getProject()))) != null && expectedJvmType.isSuperTypeOf(directJvmElement.eClass())) {
            EObject indexedJvmElement = this.jvmElementFinder.findJvmElementDeclarationInIndex(directJvmElement, project);
            if (indexedJvmElement != null) {
                return this.getContextFactory(indexedJvmElement).createJdtParticipantXtextSourceContexts(indexedJvmElement);
            }
            if (directJvmElement instanceof JvmMember) {
                return this.createJdtRenameParticipantContext((JvmMember)directJvmElement, javaElement);
            }
        }
        return null;
    }

    protected RenameProcessor getRenameProcessor(IRenameElementContext participantContext) {
        RenameProcessor renameProcessor = super.getRenameProcessor(participantContext);
        CompositeRefactoringProcessor current = this.compositeRefactoringProcessorAccess.getCurrent(this.getProcessor());
        current.addProcessor((RefactoringProcessor)renameProcessor);
        if (current.getNumProcessors() == 1) {
            return current;
        }
        return null;
    }

    protected List<? extends IRenameElementContext> createJdtRenameParticipantContext(JvmMember renamedJvmMember, IJavaElement javaElement) {
        return Collections.singletonList(new JdtRenameParticipantContext(renamedJvmMember, javaElement));
    }

    protected List<EObject> getRenamedElementsOrProxies(EObject originalTarget) {
        return null;
    }

    protected EClass getExpectedJvmType(IJavaElement javaElement) {
        try {
            switch (javaElement.getElementType()) {
                case 7: {
                    if (((IType)javaElement).isEnum()) {
                        return TypesPackage.Literals.JVM_ENUMERATION_TYPE;
                    }
                    return TypesPackage.Literals.JVM_TYPE;
                }
                case 9: {
                    if (((IMethod)javaElement).isConstructor()) {
                        return TypesPackage.Literals.JVM_CONSTRUCTOR;
                    }
                    return TypesPackage.Literals.JVM_OPERATION;
                }
                case 8: {
                    if (((IField)javaElement).isEnumConstant()) {
                        return TypesPackage.Literals.JVM_ENUMERATION_LITERAL;
                    }
                    return TypesPackage.Literals.JVM_FIELD;
                }
            }
            return null;
        }
        catch (JavaModelException exc) {
            throw new WrappedException((Exception)((Object)exc));
        }
    }

    protected ContextFactory getContextFactory(EObject jvmMember) {
        return (ContextFactory)this.getGlobalServiceProvider().findService(EcoreUtil.getURI((EObject)jvmMember), ContextFactory.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContextFactory {
        protected List<? extends IRenameElementContext> createJdtParticipantXtextSourceContexts(EObject indexedJvmElement) {
            return Collections.emptyList();
        }
    }
}

