/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import com.ibm.icu.text.MessageFormat;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.SharedDocumentAdapter;
import org.eclipse.compare.contentmergeviewer.IDocumentRange;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.DocumentManager;
import org.eclipse.compare.internal.core.patch.HunkResult;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.patch.IHunk;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class Utilities {
    private static final IPath ICONS_PATH = new Path("$nl$/icons/full/");
    private static final int VALIDATE_EDIT_PROBLEM = 10004;
    public static boolean RUNNING_TESTS = false;
    public static boolean TESTING_FLUSH_ON_COMPARE_INPUT_CHANGE = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public static IWorkbenchPartSite findSite(Control c) {
        while (c != null && !c.isDisposed()) {
            Object data = c.getData();
            if (data instanceof IWorkbenchPart) {
                return ((IWorkbenchPart)data).getSite();
            }
            c = c.getParent();
        }
        return null;
    }

    public static IActionBars findActionBars(Control c) {
        while (c != null && !c.isDisposed()) {
            Object data = c.getData();
            if (data instanceof CompareEditor) {
                return ((CompareEditor)((Object)data)).getActionBars();
            }
            if (data instanceof IViewPart) {
                return ((IViewPart)data).getViewSite().getActionBars();
            }
            c = c.getParent();
        }
        return null;
    }

    public static void setEnableComposite(Composite composite, boolean enable) {
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setEnabled(enable);
            ++i;
        }
    }

    public static boolean getBoolean(CompareConfiguration cc, String key, boolean dflt) {
        Object value;
        if (cc != null && (value = cc.getProperty(key)) instanceof Boolean) {
            return (Boolean)value;
        }
        return dflt;
    }

    public static void firePropertyChange(ListenerList listenerList, Object source, String property, Object old, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(source, property, old, newValue);
        Utilities.firePropertyChange(listenerList, event);
    }

    public static void firePropertyChange(final ListenerList listenerList, final PropertyChangeEvent event) {
        if (listenerList == null || listenerList.isEmpty()) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                Object[] listeners = listenerList.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(this, listener, event){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IPropertyChangeListener val$listener;
                        private final /* synthetic */ PropertyChangeEvent val$event;
                        {
                            this.this$1 = var1_1;
                            this.val$listener = iPropertyChangeListener;
                            this.val$event = propertyChangeEvent;
                        }

                        public void run() throws Exception {
                            this.val$listener.propertyChange(this.val$event);
                        }

                        public void handleException(Throwable exception) {
                        }
                    });
                    ++i;
                }
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public static boolean okToUse(Widget widget) {
        return widget != null && !widget.isDisposed();
    }

    private static ArrayList internalGetResources(ISelection selection, Class type) {
        ArrayList<IResource> tmp = new ArrayList<IResource>();
        if (selection instanceof IStructuredSelection) {
            Object[] s = ((IStructuredSelection)selection).toArray();
            int i = 0;
            while (i < s.length) {
                IResource resource = null;
                Object o = s[i];
                if (type.isInstance(o)) {
                    resource = (IResource)o;
                } else if (o instanceof ResourceMapping) {
                    try {
                        ResourceTraversal[] travs = ((ResourceMapping)o).getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null);
                        if (travs != null) {
                            int k = 0;
                            while (k < travs.length) {
                                IResource[] resources = travs[k].getResources();
                                int j = 0;
                                while (j < resources.length) {
                                    if (type.isInstance(resources[j]) && resources[j].isAccessible()) {
                                        tmp.add(resources[j]);
                                    }
                                    ++j;
                                }
                                ++k;
                            }
                        }
                    }
                    catch (CoreException ex) {
                        CompareUIPlugin.log(ex);
                    }
                } else if (o instanceof IAdaptable) {
                    Object adapter;
                    IAdaptable a = (IAdaptable)o;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (type.isInstance(adapter = a.getAdapter((Class)clazz))) {
                        resource = (IResource)adapter;
                    }
                }
                if (resource != null && resource.isAccessible()) {
                    tmp.add(resource);
                }
                ++i;
            }
        }
        return tmp;
    }

    public static IResource[] getResources(ISelection selection) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ArrayList tmp = Utilities.internalGetResources(selection, clazz);
        return tmp.toArray(new IResource[tmp.size()]);
    }

    public static IFile[] getFiles(ISelection selection) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ArrayList tmp = Utilities.internalGetResources(selection, clazz);
        return tmp.toArray(new IFile[tmp.size()]);
    }

    public static byte[] readBytes(InputStream in) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            try {
                int c;
                while ((c = in.read()) != -1) {
                    bos.write(c);
                }
            }
            catch (IOException iOException) {
                Utilities.close(in);
                try {
                    bos.close();
                }
                catch (IOException iOException2) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            Utilities.close(in);
            try {
                bos.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Utilities.close(in);
        try {
            bos.close();
        }
        catch (IOException iOException) {}
        return bos.toByteArray();
    }

    public static IPath getIconPath(Display display) {
        return ICONS_PATH;
    }

    public static void initAction(IAction a, ResourceBundle bundle, String prefix) {
        String labelKey = "label";
        String tooltipKey = "tooltip";
        String imageKey = "image";
        String descriptionKey = "description";
        if (prefix != null && prefix.length() > 0) {
            labelKey = String.valueOf(prefix) + labelKey;
            tooltipKey = String.valueOf(prefix) + tooltipKey;
            imageKey = String.valueOf(prefix) + imageKey;
            descriptionKey = String.valueOf(prefix) + descriptionKey;
        }
        a.setText(Utilities.getString(bundle, labelKey, labelKey));
        a.setToolTipText(Utilities.getString(bundle, tooltipKey, null));
        a.setDescription(Utilities.getString(bundle, descriptionKey, null));
        String relPath = Utilities.getString(bundle, imageKey, null);
        if (relPath != null && relPath.trim().length() > 0) {
            String ePath;
            String dPath;
            if (relPath.indexOf("/") >= 0) {
                String path = relPath.substring(1);
                dPath = String.valueOf('d') + path;
                ePath = String.valueOf('e') + path;
            } else {
                dPath = "dlcl16/" + relPath;
                ePath = "elcl16/" + relPath;
            }
            ImageDescriptor id = CompareUIPlugin.getImageDescriptor(dPath);
            if (id != null) {
                a.setDisabledImageDescriptor(id);
            }
            if ((id = CompareUIPlugin.getImageDescriptor(ePath)) != null) {
                a.setImageDescriptor(id);
                a.setHoverImageDescriptor(id);
            }
        }
    }

    public static void initToggleAction(IAction a, ResourceBundle bundle, String prefix, boolean checked) {
        String tooltip = null;
        tooltip = checked ? Utilities.getString(bundle, String.valueOf(prefix) + "tooltip.checked", null) : Utilities.getString(bundle, String.valueOf(prefix) + "tooltip.unchecked", null);
        if (tooltip == null) {
            tooltip = Utilities.getString(bundle, String.valueOf(prefix) + "tooltip", null);
        }
        if (tooltip != null) {
            a.setToolTipText(tooltip);
        }
        String description = null;
        description = checked ? Utilities.getString(bundle, String.valueOf(prefix) + "description.checked", null) : Utilities.getString(bundle, String.valueOf(prefix) + "description.unchecked", null);
        if (description == null) {
            description = Utilities.getString(bundle, String.valueOf(prefix) + "description", null);
        }
        if (description != null) {
            a.setDescription(description);
        }
    }

    public static String getString(ResourceBundle bundle, String key, String dfltValue) {
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return dfltValue;
    }

    public static String getFormattedString(ResourceBundle bundle, String key, String arg) {
        if (bundle != null) {
            try {
                return MessageFormat.format((String)bundle.getString(key), (Object[])new String[]{arg});
            }
            catch (MissingResourceException x) {
                CompareUIPlugin.log(x);
            }
        }
        return "!" + key + "!";
    }

    public static String getString(String key) {
        try {
            return CompareUI.getResourceBundle().getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
    }

    public static String getFormattedString(String key, String arg) {
        try {
            return MessageFormat.format((String)CompareUI.getResourceBundle().getString(key), (Object[])new String[]{arg});
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
    }

    public static String getFormattedString(String key, String arg0, String arg1) {
        try {
            return MessageFormat.format((String)CompareUI.getResourceBundle().getString(key), (Object[])new String[]{arg0, arg1});
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
    }

    public static String getString(ResourceBundle bundle, String key) {
        return Utilities.getString(bundle, key, key);
    }

    public static int getInteger(ResourceBundle bundle, String key, int dfltValue) {
        if (bundle != null) {
            try {
                String s = bundle.getString(key);
                if (s != null) {
                    return Integer.parseInt(s);
                }
            }
            catch (NumberFormatException x) {
                CompareUIPlugin.log(x);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return dfltValue;
    }

    public static boolean validateResource(IResource resource, Shell shell, String title) {
        return Utilities.validateResources(new IResource[]{resource}, shell, title);
    }

    public static boolean validateResources(List resources, Shell shell, String title) {
        IResource[] r = resources.toArray(new IResource[resources.size()]);
        return Utilities.validateResources(r, shell, title);
    }

    public static boolean validateResources(IResource[] resources, Shell shell, String title) {
        List readOnlyFiles = Utilities.getReadonlyFiles(resources);
        if (readOnlyFiles.size() == 0) {
            return true;
        }
        Map oldTimeStamps = Utilities.createModificationStampMap(readOnlyFiles);
        IFile[] files = readOnlyFiles.toArray(new IFile[readOnlyFiles.size()]);
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(files, (Object)shell);
        if (!status.isOK()) {
            String message = Utilities.getString("ValidateEdit.error.unable_to_perform");
            Utilities.displayError(shell, title, status, message);
            return false;
        }
        IStatus modified = null;
        Map newTimeStamps = Utilities.createModificationStampMap(readOnlyFiles);
        Iterator iter = oldTimeStamps.keySet().iterator();
        while (iter.hasNext()) {
            Status entry;
            IFile file = (IFile)iter.next();
            if (file.isReadOnly()) {
                entry = new Status(4, CompareUIPlugin.getPluginId(), 10004, Utilities.getFormattedString("ValidateEdit.error.stillReadonly", file.getFullPath().toString()), null);
                modified = Utilities.addStatus(modified, (IStatus)entry);
                continue;
            }
            if (oldTimeStamps.get(file).equals(newTimeStamps.get(file))) continue;
            entry = new Status(4, CompareUIPlugin.getPluginId(), 10004, Utilities.getFormattedString("ValidateEdit.error.fileModified", file.getFullPath().toString()), null);
            modified = Utilities.addStatus(modified, (IStatus)entry);
        }
        if (modified != null) {
            String message = Utilities.getString("ValidateEdit.error.unable_to_perform");
            Utilities.displayError(shell, title, modified, message);
            return false;
        }
        return true;
    }

    private static void displayError(final Shell shell, final String title, final IStatus status, final String message) {
        if (Display.getCurrent() != null) {
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
        } else {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
                }
            });
        }
    }

    private static List getReadonlyFiles(IResource[] resources) {
        ArrayList<IResource> readOnlyFiles = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            ResourceAttributes resourceAttributes = resource.getResourceAttributes();
            if (resource.getType() == 1 && resourceAttributes != null && resourceAttributes.isReadOnly()) {
                readOnlyFiles.add(resource);
            }
            ++i;
        }
        return readOnlyFiles;
    }

    private static Map createModificationStampMap(List files) {
        HashMap<IFile, Long> map = new HashMap<IFile, Long>();
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            IFile file = (IFile)iter.next();
            map.put(file, new Long(file.getModificationStamp()));
        }
        return map;
    }

    private static IStatus addStatus(IStatus status, IStatus entry) {
        if (status == null) {
            return entry;
        }
        if (status.isMultiStatus()) {
            ((MultiStatus)status).add(entry);
            return status;
        }
        MultiStatus result = new MultiStatus(CompareUIPlugin.getPluginId(), 10004, Utilities.getString("ValidateEdit.error.unable_to_perform"), null);
        result.add(status);
        result.add(entry);
        return result;
    }

    public static String readString(IStreamContentAccessor sca, String encoding) throws CoreException {
        String s = null;
        try {
            try {
                s = Utilities.readString(sca.getContents(), encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!encoding.equals(ResourcesPlugin.getEncoding())) {
                    s = Utilities.readString(sca.getContents(), ResourcesPlugin.getEncoding());
                }
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.compare", 0, e.getMessage(), (Throwable)e));
        }
        return s;
    }

    public static String readString(InputStream is, String encoding) throws IOException {
        return Utilities.readString(is, encoding, -1, null);
    }

    public static String readString(InputStream is, String encoding, int length, IProgressMonitor monitor) throws IOException {
        String string;
        block9: {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
            progress.setWorkRemaining(length);
            if (is == null) {
                return null;
            }
            BufferedReader reader = null;
            try {
                StringBuffer buffer = new StringBuffer();
                char[] part = new char[2048];
                int read = 0;
                reader = new BufferedReader(new InputStreamReader(is, encoding));
                while ((read = reader.read(part)) != -1) {
                    buffer.append(part, 0, read);
                    progress.worked(2048);
                    if (!progress.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
                string = buffer.toString();
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    public static String getCharset(Object resource) {
        if (resource instanceof IEncodedStorage) {
            try {
                return ((IEncodedStorage)resource).getCharset();
            }
            catch (CoreException ex) {
                CompareUIPlugin.log(ex);
            }
        }
        return ResourcesPlugin.getEncoding();
    }

    public static byte[] getBytes(String s, String encoding) {
        byte[] bytes = null;
        if (s != null) {
            try {
                bytes = s.getBytes(encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = s.getBytes();
            }
        }
        return bytes;
    }

    public static String readString(IStreamContentAccessor sa) throws CoreException {
        String encoding = null;
        if (sa instanceof IEncodedStreamContentAccessor) {
            encoding = ((IEncodedStreamContentAccessor)sa).getCharset();
        }
        if (encoding == null) {
            encoding = ResourcesPlugin.getEncoding();
        }
        return Utilities.readString(sa, encoding);
    }

    public static void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static IResource getFirstResource(ISelection selection) {
        IResource[] resources = Utilities.getResources(selection);
        if (resources.length > 0) {
            return resources[0];
        }
        return null;
    }

    public static Object getAdapter(Object element, Class adapterType, boolean load) {
        Object adapted;
        if (adapterType.isInstance(element)) {
            return element;
        }
        if (element instanceof IAdaptable && adapterType.isInstance(adapted = ((IAdaptable)element).getAdapter(adapterType))) {
            return adapted;
        }
        if (load ? adapterType.isInstance(adapted = Platform.getAdapterManager().loadAdapter(element, adapterType.getName())) : adapterType.isInstance(adapted = Platform.getAdapterManager().getAdapter(element, adapterType))) {
            return adapted;
        }
        return null;
    }

    public static Object getAdapter(Object element, Class adapterType) {
        return Utilities.getAdapter(element, adapterType, false);
    }

    public static ITypedElement getLeg(char type, Object input) {
        if (input instanceof ICompareInput) {
            switch (type) {
                case 'A': {
                    return ((ICompareInput)input).getAncestor();
                }
                case 'L': {
                    return ((ICompareInput)input).getLeft();
                }
                case 'R': {
                    return ((ICompareInput)input).getRight();
                }
            }
        }
        return null;
    }

    public static IDocument getDocument(char type, Object element, boolean isUsingDefaultContentProvider, boolean canHaveSharedDocument) {
        ITypedElement te = Utilities.getLeg(type, element);
        if (te == null) {
            return null;
        }
        if (te instanceof IDocument) {
            return (IDocument)te;
        }
        if (te instanceof IDocumentRange) {
            return ((IDocumentRange)((Object)te)).getDocument();
        }
        if (isUsingDefaultContentProvider && canHaveSharedDocument) {
            IDocumentProvider provider;
            IEditorInput input;
            ISharedDocumentAdapter sda;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.compare.ISharedDocumentAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((sda = (ISharedDocumentAdapter)Utilities.getAdapter(te, clazz, true)) != null && (input = sda.getDocumentKey(te)) != null && (provider = SharedDocumentAdapter.getDocumentProvider(input)) != null) {
                return provider.getDocument((Object)input);
            }
        }
        if (te instanceof IStreamContentAccessor) {
            return DocumentManager.get(te);
        }
        return null;
    }

    public static boolean isHunk(Object input) {
        if (input != null && input instanceof DiffNode) {
            ITypedElement left;
            ITypedElement right = ((DiffNode)input).getRight();
            if (right != null) {
                Object element;
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("org.eclipse.compare.patch.IHunk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((element = Utilities.getAdapter(right, clazz)) instanceof IHunk) {
                    return true;
                }
            }
            if ((left = ((DiffNode)input).getLeft()) != null) {
                Object element;
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("org.eclipse.compare.patch.IHunk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((element = Utilities.getAdapter(left, clazz)) instanceof IHunk) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isHunkOk(Object input) {
        if (input != null && input instanceof DiffNode) {
            ITypedElement left;
            ITypedElement right = ((DiffNode)input).getRight();
            if (right != null) {
                Object element;
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("org.eclipse.compare.internal.core.patch.HunkResult");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((element = Utilities.getAdapter(right, clazz)) instanceof HunkResult) {
                    return ((HunkResult)element).isOK();
                }
            }
            if ((left = ((DiffNode)input).getLeft()) != null) {
                Object element;
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("org.eclipse.compare.internal.core.patch.HunkResult");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((element = Utilities.getAdapter(left, clazz)) instanceof HunkResult) {
                    return ((HunkResult)element).isOK();
                }
            }
        }
        return false;
    }

    public static void schedule(Job job, IWorkbenchSite site) {
        if (site != null) {
            IWorkbenchSiteProgressService siteProgress;
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((siteProgress = (IWorkbenchSiteProgressService)site.getAdapter((Class)clazz)) != null) {
                siteProgress.schedule(job, 0L, true);
                return;
            }
        }
        job.schedule();
    }

    public static void runInUIThread(final Runnable runnable) {
        if (Display.getCurrent() != null) {
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)runnable);
        } else {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)runnable);
                }
            });
        }
    }

    public static boolean setReadTimeout(URLConnection connection, int timeout) {
        Method[] methods = connection.getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals("setReadTimeout")) {
                try {
                    methods[i].invoke((Object)connection, new Integer(timeout));
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            ++i;
        }
        return false;
    }

    public static String getURLContents(final URL url, IRunnableContext context) throws InvocationTargetException, OperationCanceledException, InterruptedException {
        final String[] result = new String[1];
        context.run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)PatchMessages.InputPatchPage_URLConnecting, (int)100);
                try {
                    try {
                        URLConnection connection = url.openConnection();
                        progress.worked(10);
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        Utilities.setReadTimeout(connection, 60000);
                        progress.setTaskName(PatchMessages.InputPatchPage_URLFetchingContent);
                        String enc = connection.getContentEncoding();
                        if (enc == null) {
                            enc = ResourcesPlugin.getEncoding();
                        }
                        result[0] = Utilities.readString(connection.getInputStream(), enc, connection.getContentLength(), (IProgressMonitor)progress.newChild(90));
                    }
                    catch (SocketTimeoutException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
        return result[0];
    }
}

