/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class LinkedHashSetQueue<T>
extends AbstractQueue<T> {
    private final LinkedHashSet<T> data;

    public LinkedHashSetQueue(LinkedHashSetQueue<T> base) {
        this.data = new LinkedHashSet<T>(base.data);
    }

    public LinkedHashSetQueue() {
        this.data = new LinkedHashSet();
    }

    @Override
    public boolean offer(T e) {
        this.data.add(e);
        return true;
    }

    @Override
    public T poll() {
        Iterator iterator = this.data.iterator();
        if (iterator.hasNext()) {
            Object next = iterator.next();
            iterator.remove();
            return (T)next;
        }
        return null;
    }

    @Override
    public T peek() {
        Iterator iterator = this.data.iterator();
        if (iterator.hasNext()) {
            return (T)iterator.next();
        }
        return null;
    }

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.data.addAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.data.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.data.containsAll(c);
    }
}

