/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.wizards.DiseaseModelPropertyComposite;
import org.eclipse.stem.ui.wizards.DiseaseWizardMessages;
import org.eclipse.stem.ui.wizards.NewDiseaseWizard;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class DiseaseDefinitionControl
extends Composite {
    private DiseaseModel[] diseaseModels = null;
    private final Combo combo;
    private final DiseaseModelPropertyComposite diseaseModelPropertyComposite;
    private NewDiseaseWizard newDiseaseWizard = null;

    public DiseaseDefinitionControl(Composite parent, int style, final ModifyListener projectValidator, IProject project, NewDiseaseWizard ndw) {
        super(parent, style);
        this.newDiseaseWizard = ndw;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Label diseaseModelLabel = new Label((Composite)this, 0);
        GridData gd_diseaseModelLabel = new GridData(4, 0x1000000, true, false);
        gd_diseaseModelLabel.widthHint = 100;
        diseaseModelLabel.setLayoutData((Object)gd_diseaseModelLabel);
        diseaseModelLabel.setText(DiseaseWizardMessages.getString("DDC.0"));
        this.combo = new Combo((Composite)this, 8);
        this.combo.setTextLimit(30);
        GridData gd_combo = new GridData(4, 0x1000000, true, false);
        gd_combo.widthHint = 303;
        this.combo.setLayoutData((Object)gd_combo);
        this.combo.setToolTipText(DiseaseWizardMessages.getString("DDC.1"));
        this.combo.setItems(this.getDiseaseModelNames(this.getDiseaseModels()));
        this.combo.select(0);
        this.combo.addModifyListener(projectValidator);
        this.diseaseModelPropertyComposite = new DiseaseModelPropertyComposite(this, 0, this.getDiseaseModels(), projectValidator, project);
        GridData gd_diseaseModelPropertyControl = new GridData(4, 0x1000000, true, false, 2, 1);
        this.diseaseModelPropertyComposite.setLayoutData(gd_diseaseModelPropertyControl);
        NewDiseaseWizard wizard = ndw;
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiseaseDefinitionControl.this.diseaseModelPropertyComposite.displayDiseaseModel(DiseaseDefinitionControl.this.getDiseaseModels()[DiseaseDefinitionControl.this.combo.getSelectionIndex()]);
                projectValidator.modifyText(null);
                ((DiseaseDefinitionControl)DiseaseDefinitionControl.this).newDiseaseWizard.newDublinCorePage.updateDublinCorePage(DiseaseDefinitionControl.this.getSelectedDiseaseModel().getDublinCore());
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.stem.doc.newdisease_contextid");
    }

    private DiseaseModel[] getDiseaseModels() {
        if (this.diseaseModels == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] diseaseModelConfigElements = registry.getConfigurationElementsFor("org.eclipse.stem.diseasemodels.diseasemodel");
            ArrayList<DiseaseModel> temp = new ArrayList<DiseaseModel>();
            ArrayList<DublinCore> dctemp = new ArrayList<DublinCore>();
            this.diseaseModels = new DiseaseModel[diseaseModelConfigElements.length];
            int i = 0;
            while (i < diseaseModelConfigElements.length) {
                IConfigurationElement element = diseaseModelConfigElements[i];
                DiseaseModel diseaseModel = null;
                if (element.getName().equals("classdef")) {
                    try {
                        diseaseModel = (DiseaseModel)element.createExecutableExtension("class");
                        temp.add(diseaseModel);
                    }
                    catch (CoreException e) {
                        Activator.logError((String)DiseaseWizardMessages.getString("DDC.3"), (Throwable)e);
                    }
                } else if (element.getName().equals("dublin_core")) {
                    dctemp.add(Utility.getPluginDublinCore((IConfigurationElement)element));
                }
                ++i;
            }
            this.diseaseModels = temp.toArray(new DiseaseModel[0]);
            int n = 0;
            while (n < this.diseaseModels.length) {
                this.diseaseModels[n].setDublinCore((DublinCore)dctemp.get(n));
                ++n;
            }
        }
        return this.diseaseModels;
    }

    private String[] getDiseaseModelNames(DiseaseModel[] diseaseModels) {
        String[] retValue = new String[diseaseModels.length];
        int i = 0;
        while (i < diseaseModels.length) {
            String name = diseaseModels[i].getDublinCore().getTitle();
            if (name == null || name.equals("")) {
                name = diseaseModels[i].getClass().getSimpleName();
            }
            retValue[i] = name;
            ++i;
        }
        return retValue;
    }

    DiseaseModel getSelectedDiseaseModel() {
        DiseaseModel retValue = (DiseaseModel)EcoreUtil.copy((EObject)this.getDiseaseModels()[this.combo.getSelectionIndex()]);
        this.diseaseModelPropertyComposite.populateDiseaseModel(retValue);
        return retValue;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public boolean validate() {
        return this.diseaseModelPropertyComposite.validate();
    }

    public String getErrorMessage() {
        return this.diseaseModelPropertyComposite.getErrorMessage();
    }
}

