/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editors.ie.events.impl;

import org.eclipse.actf.util.win32.MemoryUtil;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.Variant;

public abstract class AbstractEventParameters {
    protected OleEvent event;

    protected AbstractEventParameters(OleEvent oleEvent) {
        this.event = oleEvent;
    }

    protected Variant getVariant(int n) {
        try {
            return this.event.arguments[n];
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected String getString(int n) {
        try {
            return this.event.arguments[n].getString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected int getInteger(int n) {
        try {
            return this.event.arguments[n].getInt();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    protected boolean getBoolean(int n) {
        try {
            return this.event.arguments[n].getBoolean();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    protected void setBooleanByRef(int n, boolean bl) {
        try {
            this.event.arguments[n].setByRef(bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected int getIntegerByRef(int n) {
        try {
            int n2 = this.event.arguments[n].getByRef();
            if (n2 != 0) {
                int[] nArray = new int[1];
                MemoryUtil.MoveMemory((int[])nArray, (int)n2, (int)4);
                return nArray[0];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0;
    }

    protected void setIntegerByRef(int n, int n2) {
        try {
            this.event.arguments[n].setByRef(n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected int getDispatchAddress(int n) {
        try {
            return this.event.arguments[n].getDispatch().getAddress();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    protected int getControlSiteAddress() {
        if (this.event.widget instanceof OleControlSite) {
            Variant variant = new Variant(new OleAutomation((OleClientSite)((OleControlSite)this.event.widget)));
            try {
                int n = variant.getDispatch().getAddress();
                return n;
            }
            finally {
                variant.dispose();
            }
        }
        return 0;
    }
}

