/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.IHTTPMessage;
import org.eclipse.actf.util.httpproxy.core.IMessageBody;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.ChunkedMessageBodyReader;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessageBuffer;
import org.eclipse.actf.util.internal.httpproxy.core.HeaderInBuffer;
import org.eclipse.actf.util.internal.httpproxy.core.HeaderToAdd;
import org.eclipse.actf.util.internal.httpproxy.core.MessageBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HTTPMessage
implements IHTTPMessage {
    static final Logger LOGGER = Logger.getLogger(HTTPMessage.class);
    private transient long fSerial;
    private HTTPMessageBuffer fBuffer;
    private IMessageBody fOriginalMessageBody;
    private IMessageBody fTransformedMessageBody = null;
    private List<IHTTPHeader> fHeaders = new ArrayList<IHTTPHeader>(50);
    private List<IHTTPHeader> fTrailingHeaders;
    private boolean isChunkedEncoding = false;
    private long fTid = 0L;
    private static final byte[] CLOSE_A = "close".getBytes();
    private static final byte[] KEEP_ALIVE_A = "Keep-Alive".getBytes();

    public HTTPMessage(long l) {
        this(l, 1024);
    }

    public HTTPMessage(long l, int n) {
        this.fSerial = l;
        this.fBuffer = new HTTPMessageBuffer(n);
        this.fOriginalMessageBody = null;
    }

    protected HTTPMessage(long l, byte[] byArray) {
        this.fSerial = l;
        this.fBuffer = new HTTPMessageBuffer();
        this.setOriginalMessageBody(new MessageBody(new ByteArrayInputStream(byArray), byArray.length));
    }

    @Override
    public long getSerial() {
        return this.fSerial;
    }

    @Override
    public abstract String getHTTPVersionAsString();

    @Override
    public abstract byte[] getHTTPVersionAsBytes();

    protected abstract boolean isBodyEmpty();

    final void setOriginalMessageBody(IMessageBody iMessageBody) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("setOriginalMessageBody: " + iMessageBody);
        }
        this.updateContentLengthHeader(iMessageBody);
        this.fOriginalMessageBody = iMessageBody;
    }

    final void updateContentLengthHeader(IMessageBody iMessageBody) {
        int n;
        int n2 = this.fOriginalMessageBody == null ? -1 : this.fOriginalMessageBody.getContentLength();
        int n3 = n = iMessageBody == null ? -1 : iMessageBody.getContentLength();
        if (n >= 0) {
            this.setHeader(IHTTPHeader.CONTENT_LENGTH_A, Integer.toString(n).getBytes());
        } else if (n2 >= 0) {
            this.removeHeader(IHTTPHeader.CONTENT_LENGTH_A);
        }
    }

    protected IMessageBody getOriginalMessageBody() {
        return this.fOriginalMessageBody;
    }

    protected IMessageBody getTransformedMessageBody() {
        return this.fTransformedMessageBody;
    }

    @Override
    public IMessageBody getMessageBody() {
        return this.fTransformedMessageBody != null ? this.fTransformedMessageBody : this.fOriginalMessageBody;
    }

    protected abstract void writeFirstLine(OutputStream var1) throws IOException;

    protected HTTPMessageBuffer getBuffer() {
        return this.fBuffer;
    }

    @Override
    public final List<IHTTPHeader> getHeaders() {
        return this.fHeaders;
    }

    @Override
    public final IHTTPHeader removeHeader(byte[] byArray) {
        for (IHTTPHeader iHTTPHeader : this.fHeaders) {
            if (iHTTPHeader.isRemoved() || !iHTTPHeader.isFieldNameEqualsTo(byArray)) continue;
            iHTTPHeader.setRemoved(true);
            return iHTTPHeader;
        }
        return null;
    }

    @Override
    public final void setHeader(byte[] byArray, byte[] byArray2) {
        HeaderToAdd headerToAdd = new HeaderToAdd();
        headerToAdd.init(byArray, byArray2);
        this.removeHeader(byArray);
        this.fHeaders.add(headerToAdd);
    }

    final void addHeader(HeaderInBuffer headerInBuffer) {
        this.fHeaders.add(headerInBuffer);
    }

    @Override
    public final void addTrailingHeader(IHTTPHeader iHTTPHeader) {
        if (this.fTrailingHeaders == null) {
            this.fTrailingHeaders = new ArrayList<IHTTPHeader>(50);
        }
        this.fTrailingHeaders.add(iHTTPHeader);
    }

    @Override
    public final IHTTPHeader getHeader(byte[] byArray) {
        for (IHTTPHeader iHTTPHeader : this.fHeaders) {
            if (!iHTTPHeader.isFieldNameEqualsTo(byArray)) continue;
            return iHTTPHeader;
        }
        return null;
    }

    @Override
    public final byte[] getHeaderAsBytes(byte[] byArray) {
        IHTTPHeader iHTTPHeader = this.getHeader(byArray);
        return iHTTPHeader == null ? null : iHTTPHeader.getValue();
    }

    @Override
    public final boolean isChunkedEncoding() {
        return this.isChunkedEncoding;
    }

    @Override
    public final void setChunkedEncoding(boolean bl) {
        this.isChunkedEncoding = bl;
    }

    @Override
    public final void setTid(long l) {
        this.fTid = l;
    }

    @Override
    public long getTid() {
        return this.fTid;
    }

    protected void writeHeaders(OutputStream outputStream) throws IOException {
        this.writeFirstLine(outputStream);
        for (IHTTPHeader iHTTPHeader : this.fHeaders) {
            iHTTPHeader.writeLine(outputStream);
        }
        outputStream.write(13);
        outputStream.write(10);
    }

    protected abstract void writeBodyWithoutContentLength(long var1, IMessageBody var3, OutputStream var4) throws IOException, TimeoutException;

    @Override
    public void writeBody(long l, IMessageBody iMessageBody, OutputStream outputStream) throws IOException, TimeoutException {
        if (iMessageBody == null) {
            return;
        }
        InputStream inputStream = iMessageBody.getMessageBodyInputStream();
        int n = iMessageBody.getContentLength();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("super.writeBody: contentLength=" + n + ", body=" + inputStream + ", isChunkedEncoding=" + iMessageBody.isChunkedEncoding());
        }
        if (inputStream != null) {
            if (n >= 0) {
                int n2 = 0;
                while (n2 < n) {
                    int n3 = inputStream.read();
                    if (n3 < 0) {
                        LOGGER.debug("Unexpected connection shutdown...:" + n2 + ":" + inputStream);
                    }
                    outputStream.write(n3);
                    ++n2;
                }
            } else if (iMessageBody.isChunkedEncoding()) {
                ChunkedMessageBodyReader chunkedMessageBodyReader = new ChunkedMessageBodyReader(inputStream);
                chunkedMessageBodyReader.readChunkedMessage(l, outputStream, this);
            } else {
                this.writeBodyWithoutContentLength(l, iMessageBody, outputStream);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("super.writeBody: done");
        }
    }

    protected IMessageBody transformMessageBody(long l, IMessageBody iMessageBody) throws IOException, TimeoutException {
        return null;
    }

    @Override
    public void write(long l, OutputStream outputStream) throws IOException, TimeoutException {
        if (this.fTransformedMessageBody == null) {
            this.fTransformedMessageBody = this.transformMessageBody(l, this.fOriginalMessageBody);
            if (this.fTransformedMessageBody != null) {
                this.updateContentLengthHeader(this.fTransformedMessageBody);
            }
        }
        this.writeHeaders(outputStream);
        this.writeBody(l, this.getMessageBody(), outputStream);
    }

    @Override
    public boolean isHTTPVersion1_1() {
        return Arrays.equals(IHTTPHeader.HTTP_VERSION_1_1_A, this.getHTTPVersionAsBytes());
    }

    @Override
    public void setConnectionHeader(boolean bl) {
        if (bl) {
            this.setHeader(IHTTPHeader.CONNECTION_A, KEEP_ALIVE_A);
        } else {
            this.setHeader(IHTTPHeader.CONNECTION_A, CLOSE_A);
        }
    }

    @Override
    public boolean isConnectionToBeClosed() {
        IHTTPHeader iHTTPHeader = this.getHeader(IHTTPHeader.CONNECTION_A);
        if (this.isHTTPVersion1_1()) {
            if (iHTTPHeader == null) {
                return false;
            }
            return iHTTPHeader.compareValueIgnoreCase(CLOSE_A);
        }
        if (iHTTPHeader == null) {
            return true;
        }
        return !iHTTPHeader.compareValueIgnoreCase(KEEP_ALIVE_A);
    }

    public String toString() {
        return "HTTPMessage " + this.fSerial + ":" + this.fBuffer.toString();
    }
}

