/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.flash.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.model.flash.FlashPlayerFactory;
import org.eclipse.actf.model.flash.IFlashPlayer;
import org.eclipse.actf.util.win32.FlashMSAAObject;
import org.eclipse.actf.util.win32.FlashMSAAObjectFactory;
import org.eclipse.actf.util.win32.WindowUtil;
import org.eclipse.actf.util.win32.comclutch.ComService;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.eclipse.actf.util.win32.comclutch.IServiceProvider;
import org.eclipse.actf.util.win32.comclutch.IUnknown;

public class FlashMSAAUtil {
    private static boolean SCAN_ALL = false;
    private static boolean SHOW_OFFSCREEN = false;

    public static boolean isFlash(int n) {
        FlashMSAAObject flashMSAAObject = FlashMSAAObjectFactory.getFlashMSAAObjectFromPtr((long)n);
        return FlashMSAAUtil.isFlash(flashMSAAObject);
    }

    public static boolean isInvisibleFlash(int n) {
        FlashMSAAObject flashMSAAObject = FlashMSAAObjectFactory.getFlashMSAAObjectFromPtr((long)n);
        return FlashMSAAUtil.isInvisibleFlash(flashMSAAObject);
    }

    public static IFlashPlayer[] getFlashPlayers(int n) {
        return FlashMSAAUtil.getFlashPlayers(n, SHOW_OFFSCREEN, SCAN_ALL);
    }

    public static IFlashPlayer[] getFlashPlayers(int n, boolean bl, boolean bl2) {
        FlashMSAAObject flashMSAAObject = FlashMSAAObjectFactory.getFlashMSAAObjectFromWindow((long)n);
        FlashMSAAObject[] flashMSAAObjectArray = FlashMSAAUtil.getFlashElements(flashMSAAObject, bl, bl2);
        IFlashPlayer[] iFlashPlayerArray = new IFlashPlayer[flashMSAAObjectArray.length];
        int n2 = 0;
        while (n2 < flashMSAAObjectArray.length) {
            iFlashPlayerArray[n2] = FlashPlayerFactory.getPlayerFromObject(flashMSAAObjectArray[n2]);
            ++n2;
        }
        return iFlashPlayerArray;
    }

    public static boolean isFlash(FlashMSAAObject flashMSAAObject) {
        return FlashMSAAUtil.isFlashClass(flashMSAAObject.getClassName()) || FlashMSAAUtil.isInvisibleFlash(flashMSAAObject);
    }

    public static boolean isInvisibleFlash(FlashMSAAObject flashMSAAObject) {
        String string;
        if (10 == flashMSAAObject.getAccRole() && (string = flashMSAAObject.getAccDescription()) != null && string.startsWith("PLUGIN: type=")) {
            return FlashMSAAUtil.getHtmlAttribute(flashMSAAObject, "WMode") != null;
        }
        return false;
    }

    public static boolean isFlashClass(String string) {
        return "MacromediaFlashPlayerActiveX".equals(string) || "ShockwaveFlashPlugin".equals(string);
    }

    public static FlashMSAAObject[] getFlashElements(FlashMSAAObject flashMSAAObject) {
        return FlashMSAAUtil.getFlashElements(flashMSAAObject, SHOW_OFFSCREEN, SCAN_ALL);
    }

    public static FlashMSAAObject[] getFlashElements(FlashMSAAObject flashMSAAObject, boolean bl, boolean bl2) {
        FlashFinder flashFinder = new FlashFinder();
        flashFinder.find(flashMSAAObject, bl, bl2);
        return flashFinder.getResults();
    }

    public static boolean isScanAll() {
        return SCAN_ALL;
    }

    public static void setScanAll(boolean bl) {
        SCAN_ALL = bl;
    }

    public static boolean isShowOffscreen() {
        return SHOW_OFFSCREEN;
    }

    public static void setShowOffscreen(boolean bl) {
        SHOW_OFFSCREEN = bl;
    }

    public static IDispatch getHtmlElementFromPtr(int n) {
        FlashMSAAObject flashMSAAObject = FlashMSAAObjectFactory.getFlashMSAAObjectFromPtr((long)n);
        return FlashMSAAUtil.getHtmlElementFromObject(flashMSAAObject);
    }

    public static String getHtmlAttribute(int n, String string) {
        FlashMSAAObject flashMSAAObject = FlashMSAAObjectFactory.getFlashMSAAObjectFromPtr((long)n);
        return FlashMSAAUtil.getHtmlAttribute(flashMSAAObject, string);
    }

    public static IDispatch getHtmlElementFromObject(Object object) {
        if (object instanceof FlashMSAAObject) {
            object = ((FlashMSAAObject)object).getIAccessible();
        }
        if (object instanceof IUnknown) {
            IServiceProvider iServiceProvider = (IServiceProvider)((IUnknown)object).queryInterface(IUnknown.IID_IServiceProvider);
            if (iServiceProvider == null) {
                return null;
            }
            IUnknown iUnknown = null;
            try {
                iUnknown = iServiceProvider.queryService(IUnknown.IID_IHTMLElement, IUnknown.IID_IHTMLElement);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (iUnknown == null) {
                return null;
            }
            return ComService.newIDispatch((IUnknown)iUnknown);
        }
        return null;
    }

    private static String getHtmlAttribute(Object object, String string) {
        IDispatch iDispatch = FlashMSAAUtil.getHtmlElementFromObject(object);
        if (iDispatch == null) {
            return null;
        }
        try {
            return (String)iDispatch.get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static class FlashFinder {
        private boolean showOffScreen = false;
        private List<FlashMSAAObject> result = new ArrayList<FlashMSAAObject>();

        private FlashFinder() {
        }

        public void find(FlashMSAAObject flashMSAAObject, boolean bl, boolean bl2) {
            this.showOffScreen = bl;
            if (bl2 || FlashFinder.findFlashWindow(flashMSAAObject.getWindow()) != 0) {
                this.findChildren(flashMSAAObject);
            }
        }

        private static int findFlashWindow(int n) {
            if (n != 0) {
                if (FlashMSAAUtil.isFlashClass(WindowUtil.GetWindowClassName((int)n))) {
                    return n;
                }
                int n2 = WindowUtil.GetChildWindow((int)n);
                while (n2 != 0) {
                    int n3 = FlashFinder.findFlashWindow(n2);
                    if (n3 != 0) {
                        return n3;
                    }
                    n2 = WindowUtil.GetNextWindow((int)n2);
                }
            }
            return 0;
        }

        private void findChildren(FlashMSAAObject[] flashMSAAObjectArray) {
            int n = 0;
            while (n < flashMSAAObjectArray.length) {
                this.findChildren(flashMSAAObjectArray[n]);
                ++n;
            }
        }

        private void findChildren(FlashMSAAObject flashMSAAObject) {
            if (flashMSAAObject != null) {
                int n = flashMSAAObject.getAccRole();
                if ((9 == n || 10 == n) && FlashMSAAUtil.isFlash(flashMSAAObject)) {
                    this.result.add(flashMSAAObject);
                } else {
                    switch (flashMSAAObject.getAccState() & 0x18000) {
                        case 98304: {
                            if (!this.showOffScreen) break;
                        }
                        case 0: {
                            this.findChildren(flashMSAAObject.getChildren());
                        }
                    }
                }
            }
        }

        public FlashMSAAObject[] getResults() {
            FlashMSAAObject[] flashMSAAObjectArray = new FlashMSAAObject[this.result.size()];
            return this.result.toArray(flashMSAAObjectArray);
        }
    }
}

