/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.util.Vector;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.InteriorImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteriorImageComponent {
    InteriorImage containerImage = null;
    int color;
    int numConnectedComponents = 0;
    ConnectedComponent[] connectedComponents = null;
    int count = 0;
    double occupation = 0.0;

    InteriorImageComponent(InteriorImage interiorImage, int n, Vector<ConnectedComponent> vector) {
        this.containerImage = interiorImage;
        this.color = n;
        this.numConnectedComponents = vector.size();
        if (this.numConnectedComponents > 0) {
            this.connectedComponents = new ConnectedComponent[this.numConnectedComponents];
            int n2 = 0;
            while (n2 < this.numConnectedComponents) {
                ConnectedComponent connectedComponent = vector.elementAt(n2);
                this.count += connectedComponent.getCount();
                this.connectedComponents[n2] = connectedComponent;
                ++n2;
            }
            this.occupation = (double)this.count / (double)(interiorImage.getWidth() * interiorImage.getHeight());
        }
    }

    public InteriorImage getContainerImage() {
        return this.containerImage;
    }

    public int getColor() {
        return this.color;
    }

    public int getNumConnectedComponents() {
        return this.numConnectedComponents;
    }

    public ConnectedComponent[] getConnectedComponents() {
        return this.connectedComponents;
    }

    public ConnectedComponent getConnectedComponent(int n) throws ImageException {
        if (n < 0 || this.numConnectedComponents <= n) {
            throw new ImageException("Out of range: specified index = " + n + ", while #ConnectedComponent = " + this.numConnectedComponents);
        }
        return this.connectedComponents[n];
    }

    public int getCount() {
        return this.count;
    }

    public double getOccupation() {
        return this.occupation;
    }
}

