/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.operator;

import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.ILowVisionOperator;

public class BlurOp
implements ILowVisionOperator {
    private ConvolveOp cop = null;

    public BlurOp(LowVisionType lowVisionType) {
        int n;
        double d;
        double d2 = lowVisionType.getEyesightPixel();
        int n2 = (int)Math.ceil(d2);
        int n3 = (int)Math.floor(d2);
        int n4 = 2 * n2 + 1;
        double[][] dArray = new double[n4][n4];
        if (n2 == n3) {
            d = n4 * n4;
            int n5 = 0;
            while (n5 < n4) {
                n = 0;
                while (n < n4) {
                    dArray[n5][n] = 1.0 / d;
                    ++n;
                }
                ++n5;
            }
        } else if (n2 == n3 + 1) {
            double d3;
            double d4;
            d = d2 - (double)n3;
            double d5 = (2.0 * d2 + 1.0) * (2.0 * d2 + 1.0);
            double d6 = 1.0 / d5;
            int n6 = 1;
            while (n6 < n4 - 1) {
                int n7 = 1;
                while (n7 < n4 - 1) {
                    dArray[n6][n7] = d6;
                    ++n7;
                }
                ++n6;
            }
            double d7 = d / d5;
            int n8 = 1;
            while (n8 < n4 - 1) {
                dArray[n8][0] = d7;
                dArray[n8][n4 - 1] = d7;
                dArray[0][n8] = d7;
                dArray[n4 - 1][n8] = d7;
                ++n8;
            }
            dArray[0][0] = d4 = d * d / d5;
            dArray[0][n4 - 1] = d4;
            dArray[n4 - 1][0] = d4;
            dArray[n4 - 1][n4 - 1] = d4;
            double d8 = dArray[0][0] * 4.0;
            dArray[0][0] = d3 = 0.0;
            dArray[0][n4 - 1] = d3;
            dArray[n4 - 1][0] = d3;
            dArray[n4 - 1][n4 - 1] = d3;
            double[] dArray2 = dArray[n4 / 2];
            int n9 = n4 / 2;
            dArray2[n9] = dArray2[n9] + d8;
        }
        float[] fArray = new float[n4 * n4];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n4) {
            n = 0;
            while (n < n4) {
                fArray[n10] = (float)dArray[n11][n];
                ++n10;
                ++n;
            }
            ++n11;
        }
        Kernel kernel = new Kernel(n4, n4, fArray);
        this.cop = new ConvolveOp(kernel, 1, null);
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        return this.newFilter(bufferedImage, bufferedImage2);
    }

    private BufferedImage newFilter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage2 == null) {
            bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        }
        Kernel kernel = this.cop.getKernel();
        int n = kernel.getWidth();
        int n2 = kernel.getHeight();
        float[] fArray = new float[n * n2];
        kernel.getKernelData(fArray);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        double d = 1.005;
        double[] dArray = new double[256];
        int n5 = 0;
        while (n5 < dArray.length) {
            dArray[n5] = Math.pow(d, n5);
            ++n5;
        }
        double d2 = Math.log(d);
        int n6 = 0;
        while (n6 < n3) {
            int n7 = 0;
            while (n7 < n4) {
                int n8;
                int n9;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                int n10 = 0;
                while (n10 < n) {
                    n9 = 0;
                    while (n9 < n2) {
                        n8 = n6 + n10 - n / 2;
                        int n11 = n7 + n9 - n2 / 2;
                        n8 = n8 > 0 ? n8 : 0;
                        n8 = n8 >= n3 ? n3 - 1 : n8;
                        n11 = n11 > 0 ? n11 : 0;
                        n11 = n11 >= n4 ? n4 - 1 : n11;
                        int n12 = bufferedImage.getRGB(n8, n11);
                        int n13 = (n12 & 0xFF0000) >> 16;
                        int n14 = (n12 & 0xFF00) >> 8;
                        int n15 = n12 & 0xFF;
                        d3 += dArray[n13] * (double)fArray[n10 * n + n9];
                        d4 += dArray[n14] * (double)fArray[n10 * n + n9];
                        d5 += dArray[n15] * (double)fArray[n10 * n + n9];
                        ++n9;
                    }
                    ++n10;
                }
                n10 = (int)(Math.log(d3) / d2);
                n9 = (int)(Math.log(d4) / d2);
                n8 = (int)(Math.log(d5) / d2);
                n10 = n10 > 255 ? 255 : n10;
                n9 = n9 > 255 ? 255 : n9;
                n8 = n8 > 255 ? 255 : n8;
                bufferedImage2.setRGB(n6, n7, (n10 << 16) + (n9 << 8) + n8);
                ++n7;
            }
            ++n6;
        }
        return bufferedImage2;
    }

    public WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        return this.cop.filter(raster, writableRaster);
    }
}

