/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.html;

import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.eclipse.actf.model.dom.dombycom.impl.Helper;
import org.eclipse.actf.model.dom.dombycom.impl.NodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.NodeListImpl;
import org.eclipse.actf.model.dom.dombycom.impl.SingletonNodeListImpl;
import org.eclipse.actf.model.dom.dombycom.impl.StyleSheetImpl;
import org.eclipse.actf.model.dom.dombycom.impl.html.HTMLElementImpl;
import org.eclipse.actf.util.dom.EmptyNodeListImpl;
import org.eclipse.actf.util.win32.comclutch.DispatchException;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.eclipse.actf.util.win32.comclutch.IEnumUnknown;
import org.eclipse.actf.util.win32.comclutch.IOleContainer;
import org.eclipse.actf.util.win32.comclutch.IUnknown;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class FrameNodeImpl
extends HTMLElementImpl {
    FrameNodeImpl(NodeImpl nodeImpl, IDispatch iDispatch) {
        super(nodeImpl, iDispatch);
    }

    public NodeList getElementsByTagName(String string) {
        IDispatch iDispatch = (IDispatch)Helper.get(this.inode, "document");
        IDispatch iDispatch2 = (IDispatch)iDispatch.invoke1("getElementsByTagName", (Object)string);
        if (iDispatch2 == null) {
            return null;
        }
        return new NodeListImpl(this, iDispatch2);
    }

    private int getFrameIndex() {
        NodeList nodeList = this.getElementsByTagName("frame");
        if (nodeList.getLength() > 0) {
            return this.getFrameIndex(nodeList);
        }
        NodeList nodeList2 = this.getElementsByTagName("iframe");
        if (nodeList2.getLength() > 0) {
            return this.getFrameIndex(nodeList2);
        }
        return -1;
    }

    private int getFrameIndex(NodeList nodeList) {
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node instanceof INodeEx && ((INodeEx)node).isSameNode(this)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public IDispatch getFrameByIndex(IDispatch iDispatch, int n) {
        IOleContainer iOleContainer = (IOleContainer)iDispatch.queryInterface(IUnknown.IID_IOleContainer);
        IEnumUnknown iEnumUnknown = iOleContainer.enumObjects(1);
        int n2 = -1;
        IUnknown[] iUnknownArray = iEnumUnknown.next(1);
        while (iUnknownArray != null && iUnknownArray.length > 0) {
            try {
                IDispatch iDispatch2 = (IDispatch)iUnknownArray[0].queryInterface(IUnknown.IID_IWebBrowser2);
                iUnknownArray[0].release();
                if (iDispatch2 != null && ++n2 == n) {
                    return iDispatch2;
                }
            }
            catch (DispatchException dispatchException) {}
            iUnknownArray = iEnumUnknown.next(1);
        }
        return null;
    }

    private Element getFrameRootElement() {
        IDispatch iDispatch = (IDispatch)Helper.get(this.inode, "document");
        int n = this.getFrameIndex();
        if (n < 0) {
            return null;
        }
        IDispatch iDispatch2 = this.getFrameByIndex(iDispatch, n);
        if (iDispatch2 == null) {
            return null;
        }
        IDispatch iDispatch3 = (IDispatch)Helper.get(iDispatch2, "Document");
        if (iDispatch3 == null) {
            return null;
        }
        IDispatch iDispatch4 = (IDispatch)Helper.get(iDispatch3, "documentElement");
        if (iDispatch4 == null) {
            return null;
        }
        this.initialize(iDispatch3);
        return (Element)((Object)this.newNode(iDispatch4, (short)1, this));
    }

    private void initialize(IDispatch iDispatch) {
        try {
            IDispatch iDispatch2 = (IDispatch)iDispatch.invoke0("createStyleSheet");
            if (iDispatch2 == null) {
                return;
            }
            StyleSheetImpl styleSheetImpl = new StyleSheetImpl(iDispatch2);
            styleSheetImpl.addRule(".CSStoHighlight", "border: 3px solid green; background: #fdd;");
        }
        catch (DispatchException dispatchException) {}
    }

    public Node getFirstChild() {
        return this.getFrameRootElement();
    }

    public Node getLastChild() {
        return this.getFrameRootElement();
    }

    public NodeList getChildNodes() {
        Element element = this.getFrameRootElement();
        if (element == null) {
            return EmptyNodeListImpl.getInstance();
        }
        return new SingletonNodeListImpl(element);
    }

    public boolean hasChildNodes() {
        Element element = this.getFrameRootElement();
        return element != null;
    }
}

