/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.util.HashSet;
import org.eclipse.dltk.mod.core.IModelElementDelta;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ModelElementInfo;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.Openable;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.core.SourceModule;

public class ModelUpdater {
    HashSet projectsToUpdate = new HashSet();

    protected void addToParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                ModelElementInfo info = (ModelElementInfo)parent.getElementInfo();
                info.addChild(child);
            }
            catch (ModelException modelException) {}
        }
    }

    protected static void close(Openable element) {
        try {
            element.close();
        }
        catch (ModelException modelException) {}
    }

    protected void elementAdded(Openable element) {
        int elementType = element.getElementType();
        if (elementType == 2) {
            this.addToParentInfo(element);
            this.projectsToUpdate.add(element);
        } else {
            this.addToParentInfo(element);
            ModelUpdater.close(element);
        }
        switch (elementType) {
            case 3: {
                this.projectsToUpdate.add(element.getScriptProject());
                break;
            }
            case 4: {
                ScriptProject project = (ScriptProject)element.getScriptProject();
                project.resetCaches();
            }
        }
    }

    protected void elementChanged(Openable element) {
        ModelUpdater.close(element);
    }

    protected void elementRemoved(Openable element) {
        if (element.isOpen()) {
            ModelUpdater.close(element);
        }
        this.removeFromParentInfo(element);
        int elementType = element.getElementType();
        switch (elementType) {
            case 1: {
                ModelManager.getModelManager().getIndexManager().reset();
                break;
            }
            case 2: {
                ModelManager manager = ModelManager.getModelManager();
                ScriptProject scriptProject = (ScriptProject)element;
                manager.removePerProjectInfo(scriptProject);
                manager.containerRemove(scriptProject);
                break;
            }
            case 3: {
                this.projectsToUpdate.add(element.getScriptProject());
                break;
            }
            case 4: {
                ScriptProject project = (ScriptProject)element.getScriptProject();
                project.resetCaches();
            }
        }
    }

    public void processDelta(IModelElementDelta delta) {
        try {
            this.traverseDelta(delta, null, null);
            for (ScriptProject project : this.projectsToUpdate) {
                project.updateProjectFragments();
            }
        }
        finally {
            this.projectsToUpdate = new HashSet();
        }
    }

    protected void removeFromParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                ModelElementInfo info = (ModelElementInfo)parent.getElementInfo();
                info.removeChild(child);
            }
            catch (ModelException modelException) {}
        }
    }

    protected void traverseDelta(IModelElementDelta delta, IProjectFragment root, IScriptProject project) {
        boolean processChildren = true;
        Openable element = (Openable)delta.getElement();
        switch (element.getElementType()) {
            case 2: {
                project = (IScriptProject)((Object)element);
                break;
            }
            case 3: {
                root = (IProjectFragment)((Object)element);
                break;
            }
            case 5: {
                SourceModule cu = (SourceModule)element;
                if (cu.isWorkingCopy() && !cu.isPrimary()) {
                    return;
                }
            }
            case 6: {
                processChildren = false;
            }
        }
        switch (delta.getKind()) {
            case 1: {
                this.elementAdded(element);
                break;
            }
            case 2: {
                this.elementRemoved(element);
                break;
            }
            case 4: {
                if ((delta.getFlags() & 1) == 0) break;
                this.elementChanged(element);
            }
        }
        if (processChildren) {
            IModelElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                IModelElementDelta childDelta = children[i];
                this.traverseDelta(childDelta, root, project);
                ++i;
            }
        }
    }
}

