/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.debug.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.debug.core.model.IScriptWatchpoint;
import org.eclipse.dltk.mod.internal.debug.core.model.ScriptLineBreakpoint;

public class ScriptWatchpoint
extends ScriptLineBreakpoint
implements IScriptWatchpoint {
    private static final String FIELD_NAME = "org.eclipse.dltk.mod.debug.fieldName";
    private static final String ACCESS = "org.eclipse.dltk.mod.debug.access";
    private static final String MODIFICATION = "org.eclipse.dltk.mod.debug.modification";
    private static final String[] UPDATABLE_ATTRS = new String[]{"org.eclipse.dltk.mod.debug.fieldName", "org.eclipse.dltk.mod.debug.access", "org.eclipse.dltk.mod.debug.modification"};

    public ScriptWatchpoint(final String debugModelId, final IResource resource, final IPath path, final int lineNumber, final int start, final int end, final String fieldName) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ScriptWatchpoint.this.setMarker(resource.createMarker(ScriptWatchpoint.this.getMarkerId()));
                HashMap<String, String> attributes = new HashMap<String, String>();
                ScriptWatchpoint.this.addScriptBreakpointAttributes(attributes, debugModelId, true);
                ScriptWatchpoint.this.addLineBreakpointAttributes(attributes, path, lineNumber, start, end);
                attributes.put(ScriptWatchpoint.FIELD_NAME, fieldName);
                ScriptWatchpoint.this.ensureMarker().setAttributes(attributes);
                ScriptWatchpoint.this.register(true);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    public ScriptWatchpoint() {
    }

    @Override
    public String getFieldName() throws CoreException {
        return this.getMarker().getAttribute(FIELD_NAME, "");
    }

    public void setFieldName(String name) throws CoreException {
        this.getMarker().setAttribute(FIELD_NAME, (Object)name);
    }

    @Override
    protected String getMarkerId() {
        return "org.eclipse.dltk.mod.debug.scriptWatchPointMarker";
    }

    public boolean isAccess() throws CoreException {
        return new Boolean(this.getMarker().getAttribute(ACCESS, "true"));
    }

    public boolean isModification() throws CoreException {
        return new Boolean(this.getMarker().getAttribute(MODIFICATION, "true"));
    }

    public void setAccess(boolean access) throws CoreException {
        this.getMarker().setAttribute(ACCESS, (Object)Boolean.toString(access));
    }

    public void setModification(boolean modification) throws CoreException {
        this.getMarker().setAttribute(MODIFICATION, (Object)Boolean.toString(modification));
    }

    public boolean supportsAccess() {
        return true;
    }

    public boolean supportsModification() {
        return true;
    }

    @Override
    public String[] getUpdatableAttributes() {
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(Arrays.asList(super.getUpdatableAttributes()));
        all.addAll(Arrays.asList(UPDATABLE_ATTRS));
        return all.toArray(new String[all.size()]);
    }
}

