/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.kernel.stage;

import org.eclipse.vjet.af.common.error.ErrorFilter;
import org.eclipse.vjet.af.common.error.ErrorId;
import org.eclipse.vjet.af.common.error.ErrorList;
import org.eclipse.vjet.af.common.error.ErrorObject;
import org.eclipse.vjet.af.common.error.ErrorSeverity;
import org.eclipse.vjet.kernel.stage.IStage;
import org.eclipse.vjet.kernel.stage.IStageTransition;

public abstract class BaseStage<T>
implements IStage<T> {
    private T m_id;
    private IStageTransition<T> m_entryTz;
    private IStageTransition<T> m_exitTz;
    private ErrorList m_directErrors;

    protected BaseStage(T id) {
        if (id == null) {
            throw new RuntimeException("id cannot be null");
        }
        this.m_id = id;
    }

    BaseStage() {
    }

    @Override
    public T getId() {
        return this.m_id;
    }

    public void setEntryTransition(IStageTransition<T> tz) {
        this.m_entryTz = tz;
    }

    @Override
    public IStageTransition<T> getEntryTransition() {
        return this.m_entryTz;
    }

    public void setExitTransition(IStageTransition<T> tz) {
        this.m_exitTz = tz;
    }

    @Override
    public IStageTransition<T> getExitTransition() {
        return this.m_exitTz;
    }

    public void addError(ErrorId errorId) {
        this.getDirectErrors().add(new ErrorObject(errorId, ErrorSeverity.ERROR));
    }

    public void addError(ErrorObject error) {
        this.getDirectErrors().add(error);
    }

    public void addErrors(ErrorList errorList) {
        this.getDirectErrors().add(errorList);
    }

    @Override
    public boolean hasDirectErrors() {
        if (this.m_directErrors == null || this.m_directErrors.isEmpty()) {
            return false;
        }
        return this.m_directErrors.hasAnyErrors();
    }

    @Override
    public boolean hasDirectErrors(ErrorFilter errorFilter) {
        if (this.m_directErrors == null || this.m_directErrors.isEmpty()) {
            return false;
        }
        return this.m_directErrors.hasAnyErrors(errorFilter);
    }

    @Override
    public ErrorList getDirectErrors() {
        if (this.m_directErrors == null) {
            this.m_directErrors = new ErrorList(0);
        }
        return this.m_directErrors;
    }

    @Override
    public ErrorList getDirectErrors(ErrorFilter errorFilter) {
        if (this.m_directErrors == null) {
            this.m_directErrors = new ErrorList(0);
        }
        return this.m_directErrors.getAllErrors(errorFilter);
    }

    @Override
    public void clearDirectErrors() {
        if (this.m_directErrors != null) {
            this.m_directErrors.clearAllErrors();
        }
    }

    @Override
    public void clearDirectErrors(ErrorFilter errorFilter) {
        if (this.m_directErrors != null) {
            this.m_directErrors.clearAllErrors(errorFilter);
        }
    }

    @Override
    public boolean hasAnyErrors() {
        return this.hasDirectErrors();
    }

    @Override
    public boolean hasAnyErrors(ErrorFilter errorFilter) {
        return this.hasDirectErrors(errorFilter);
    }

    @Override
    public ErrorList getAllErrors() {
        return this.getDirectErrors();
    }

    @Override
    public ErrorList getAllErrors(ErrorFilter errorFilter) {
        return this.getDirectErrors(errorFilter);
    }

    public String toString() {
        return "Id=" + this.getId();
    }
}

