/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.jsref;

import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.spec.component.BaseJsComponentSpec;
import org.eclipse.vjet.dsf.spec.component.IComponentSpec;
import org.eclipse.vjet.vsf.jsref.JsObj;
import org.eclipse.vjet.vsf.jsref.ctx.ResourceCtx;
import org.eclipse.vjet.vsf.jsref.internals.JsCmpMeta;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceDispenser;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceRef;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResource;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResourceRef;
import org.eclipse.vjet.vsf.resource.pattern.js.JsType;

public class JsObjData {
    private final String m_pkgClassName;
    private final String m_resourceName;
    private final Class m_resolveResourceByClass;
    private final BaseJsComponentSpec m_resourceSpec;
    private final JsResource m_jsResource;
    private final JsCmpMeta m_meta;
    private final JsObj m_staticAnchor;
    private IJsResourceRef m_jsRef;

    public JsObjData(String pkgClassName, Class resolveResourceByClass, String resourceName) {
        this(pkgClassName, resolveResourceByClass, resourceName, false);
    }

    public JsObjData(String pkgClassName, Class resolveResourceByClass, String resourceName, boolean authoredInJava) {
        this.m_pkgClassName = pkgClassName;
        this.m_resolveResourceByClass = resolveResourceByClass;
        this.m_resourceName = resourceName;
        this.m_jsResource = resolveResourceByClass != null ? JsResource.viaName((String)resourceName, (Class)resolveResourceByClass) : null;
        if (authoredInJava && this.m_jsResource != null) {
            this.m_jsResource.enableJava(pkgClassName);
        }
        this.m_resourceSpec = this.createResourceSpec();
        this.m_meta = new JsCmpMeta(pkgClassName, resourceName, (IComponentSpec)this.m_resourceSpec);
        this.m_staticAnchor = new JsObj(this.m_meta, false, new Object[0]);
    }

    public BaseJsComponentSpec getResourceSpec() {
        return this.m_resourceSpec;
    }

    public JsResource getJsResource() {
        return this.m_jsResource;
    }

    public IJsResourceRef getJsResourceRef() {
        return this.m_jsRef;
    }

    public JsCmpMeta getJsCmpMeta() {
        return this.m_meta;
    }

    public JsObj getStaticAnchor() {
        ResourceCtx.ctx().register((IComponentSpec)this.getResourceSpec());
        return this.m_staticAnchor;
    }

    private BaseJsComponentSpec createResourceSpec() {
        SimpleComponentSpec spec = new SimpleComponentSpec();
        if (this.m_jsResource == null) {
            return spec;
        }
        this.m_jsRef = spec.define(this.m_jsResource, JsType.DefOnly);
        spec.addJsRef(this.m_jsRef);
        return spec;
    }

    public String toString() {
        Z z = new Z();
        z.format("packageClassName", (Object)this.m_pkgClassName);
        z.format("resource name", (Object)this.m_resourceName);
        z.format("resolve resource by", (Object)this.m_resolveResourceByClass);
        return z.toString();
    }

    private static class SimpleComponentSpec
    extends BaseJsComponentSpec {
        private SimpleComponentSpec() {
        }

        IJsResourceRef define(JsResource resource, JsType type) {
            IJsResourceRef ref = SimpleComponentSpec.jsRef((JsResource)resource, (JsType)type);
            if (ref instanceof JsResourceRef) {
                ((JsResourceRef)ref).setDispenserInstance((IJsResourceDispenser)this);
            }
            return ref;
        }
    }
}

