/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.jsref.ctx;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.vsf.jsref.ctx.ResourceCtx;

public final class JsResourceCtx {
    private boolean m_optimizeJsResources = false;
    private Map<String, DNode> m_slotAnchorMap = new HashMap<String, DNode>(4);

    public static JsResourceCtx ctx() {
        return ResourceCtx.ctx().getJsResourceCtx();
    }

    JsResourceCtx() {
    }

    private static URL getLocalBaseUrl() {
        File jsDir = new File(".");
        try {
            URL baseUrl = jsDir.toURL();
            return baseUrl;
        }
        catch (MalformedURLException e) {
            throw new DsfRuntimeException(e.getMessage());
        }
    }

    public boolean isOptimizeResources() {
        return this.m_optimizeJsResources;
    }

    public JsResourceCtx setOptimizeResources(boolean optimizeResources) {
        this.m_optimizeJsResources = optimizeResources;
        return this;
    }

    public DNode getSlotAnchor(String slotName) {
        return this.m_slotAnchorMap.get(slotName);
    }

    public void addSlotAnchor(String slotName, DNode node) {
        this.m_slotAnchorMap.put(slotName, node);
    }

    public String toString() {
        Z z = new Z();
        z.format("Optimized JS resources", this.m_optimizeJsResources);
        return z.toString();
    }
}

