/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.jsref.internals;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.common.binding.IValueBinding;
import org.eclipse.vjet.dsf.common.binding.SimpleValueBinding;
import org.eclipse.vjet.dsf.html.js.IParams;
import org.eclipse.vjet.dsf.serializers.ISerializableForVjo;
import org.eclipse.vjet.vsf.jsref.internals.BV;
import org.eclipse.vjet.vsf.jsref.internals.JsTypeConvertor;
import org.eclipse.vjet.vsf.jsruntime.JsObjectRefWrapper;

public class Params
implements IParams {
    Map<String, IValueBinding<?>> m_jsParams = new LinkedHashMap();

    public Params(Object ... values) {
        int x = 0;
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            String argName = "" + x++;
            if (value instanceof String) {
                this.addParam(argName, (String)value);
            } else if (value instanceof Integer) {
                this.addParam(argName, (Integer)value);
            } else if (value instanceof Boolean) {
                this.addParam(argName, (Boolean)value);
            } else if (value instanceof Long) {
                this.addParam(argName, (Long)value);
            } else if (value instanceof Double) {
                this.addParam(argName, (Double)value);
            } else if (value instanceof Character) {
                this.addParam(argName, ((Character)value).charValue());
            } else if (value instanceof Float) {
                this.addParam(argName, ((Float)value).floatValue());
            } else if (value instanceof Byte) {
                this.addParam(argName, (Byte)value);
            } else if (value instanceof Short) {
                this.addParam(argName, (Short)value);
            } else if (value instanceof JsObjectRefWrapper) {
                this.addParam(argName, (JsObjectRefWrapper)value);
            } else if (value instanceof IValueBinding) {
                this.addParam(argName, (IValueBinding)value);
            } else {
                Class clz = value != null && ISerializableForVjo.class.isAssignableFrom(value.getClass()) ? value.getClass() : Object.class;
                this.addParam(argName, (IValueBinding<?>)new SimpleValueBinding(clz, value));
            }
            ++n2;
        }
    }

    public Params addParam(String key, JsObjectRefWrapper value) {
        this.m_jsParams.put(key, (IValueBinding<?>)new SimpleValueBinding(JsObjectRefWrapper.class, (Object)value));
        return this;
    }

    public Params addParam(String key, int value) {
        return this.addParam(key, BV.bind(value));
    }

    public Params addParam(String key, short value) {
        return this.addParam(key, BV.bind(value));
    }

    public Params addParam(String key, long value) {
        return this.addParam(key, BV.bind(value));
    }

    public Params addParam(String key, float value) {
        return this.addParam(key, BV.bind(Float.valueOf(value)));
    }

    public Params addParam(String key, double value) {
        return this.addParam(key, BV.bind(value));
    }

    public Params addParam(String key, byte value) {
        return this.addParam(key, BV.bind(value));
    }

    public Params addParam(String key, boolean value) {
        return this.addParam(key, BV.bind(value));
    }

    public Params addParam(String key, String value) {
        return this.addParam(key, BV.bind(value));
    }

    public Params addParam(String key, char value) {
        return this.addParam(key, BV.bind(Character.valueOf(value)));
    }

    public Params addParam(String key, IValueBinding<?> value) {
        this.m_jsParams.put(key, value);
        return this;
    }

    public Map<String, IValueBinding<?>> getParams() {
        return Collections.unmodifiableMap(this.m_jsParams);
    }

    public String genArgs() {
        if (this.m_jsParams.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        for (IValueBinding<?> value : this.m_jsParams.values()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(JsTypeConvertor.toJsArg(value));
        }
        return sb.toString();
    }

    public String toString() {
        return this.m_jsParams.toString();
    }
}

