/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.context;

public final class IdGenerator {
    private static final int MAX_CACHED = 200;
    private static final String[] s_ids = IdGenerator.getCachedIds(200);
    public static final int MAX_SEQUENCE = 9999;
    private static final String JS_HAN_GEN = "jsEvt";
    private static final String JS_WIN = "jsWin";
    private static final String V4AD_HOC_CSS = "v4Css";
    private static final String V4 = "v4-";
    private String m_scope = "";
    private int m_jsSequence = 0;
    private int m_cssSequence = 0;
    private int m_htmlSequence = 0;
    private int m_jswindowSequence = 0;
    private int m_jsCompSequence = 0;

    public String nextJsHandlerId() {
        if (this.m_jsSequence == 9999) {
            this.resetJsHandlerId();
        }
        return JS_HAN_GEN + this.m_scope + IdGenerator.getId(this.m_jsSequence++);
    }

    public void resetJsHandlerId() {
        this.m_jsSequence = 0;
    }

    public String nextHtmlId() {
        if (this.m_htmlSequence == 9999) {
            this.resetHtmlId();
        }
        return V4 + this.m_scope + IdGenerator.getId(this.m_htmlSequence++);
    }

    public String nextJsCompId() {
        if (this.m_jsCompSequence == 9999) {
            this.resetJsCompId();
        }
        return String.valueOf(this.m_scope) + IdGenerator.getId(this.m_jsCompSequence++);
    }

    public void resetHtmlId() {
        this.m_htmlSequence = 0;
    }

    public String nextAdhocCss() {
        if (this.m_cssSequence == 9999) {
            this.resetAdhocCss();
        }
        return V4AD_HOC_CSS + IdGenerator.getId(this.m_cssSequence++);
    }

    public void resetAdhocCss() {
        this.m_cssSequence = 0;
    }

    public String nextJsWindowId() {
        if (this.m_jswindowSequence == 9999) {
            this.resetJsWindowId();
        }
        return JS_WIN + this.m_scope + IdGenerator.getId(this.m_jswindowSequence++);
    }

    public void resetJsWindowId() {
        this.m_jswindowSequence = 0;
    }

    public void resetJsCompId() {
        this.m_jsCompSequence = 0;
    }

    public void setScope(String scope) {
        if (scope == null) {
            return;
        }
        this.m_scope = scope.replaceAll("\\.", "_");
    }

    public void resetScope() {
        this.m_scope = "";
    }

    public void resetAllIds() {
        this.resetAdhocCss();
        this.resetHtmlId();
        this.resetJsHandlerId();
        this.resetJsWindowId();
        this.resetJsCompId();
        this.resetScope();
    }

    private static String getId(int index) {
        if (index >= 200) {
            return Integer.toString(index);
        }
        return s_ids[index];
    }

    private static String[] getCachedIds(int maxCached) {
        String[] answer = new String[maxCached];
        int i = 0;
        while (i < maxCached) {
            answer[i] = Integer.toString(i);
            ++i;
        }
        return answer;
    }
}

